// file      : CCF/IDL2/SemanticGraph/TypeId.hpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : TypeId.hpp,v 1.1 2003/12/22 22:26:39 boris Exp

#ifndef CCF_IDL2_SEMANTIC_GRAPH_TYPE_ID_HPP
#define CCF_IDL2_SEMANTIC_GRAPH_TYPE_ID_HPP

#include "CCF/IDL2/SemanticGraph/Elements.hpp"
#include "CCF/IDL2/SemanticGraph/Literals.hpp"


namespace CCF
{
  namespace IDL2
  {
    namespace SemanticGraph
    {
      //
      //
      //
      class TypeId : public virtual Nameable
      {
      public:
        //@@ declaration is a bad name.
        //
        ScopedName
        declaration () const
        {
          return name_;
        }

        StringLiteral
        id () const
        {
          return id_;
        }

        static Introspection::TypeInfo const&
        static_type_info ();

      protected:
        friend class Graph<Node, Edge>;

        TypeId (ScopedName const& name, StringLiteral const& id)
            : name_ (name),
              id_ (id)
        {
          type_info (static_type_info ());
        }

      private:
        ScopedName name_;
        StringLiteral id_;
      };


      //
      //
      //
      class TypePrefix : public virtual Nameable
      {
      public:
        ScopedName
        declaration () const
        {
          return name_;
        }

        StringLiteral
        prefix () const
        {
          return prefix_;
        }

        static Introspection::TypeInfo const&
        static_type_info ();

      protected:
        friend class Graph<Node, Edge>;

        TypePrefix (ScopedName const& name, StringLiteral const& prefix)
            : name_ (name),
              prefix_ (prefix)
        {
          type_info (static_type_info ());
        }

      private:
        ScopedName name_;
        StringLiteral prefix_;
      };
    }
  }
}

#endif  // CCF_IDL2_SEMANTIC_GRAPH_TYPE_ID_HPP
