<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays stats on an individual IP address   
 *
 * Input GET/POST variables
 *   - action:
 *   - submit:
 *   - ip:
 *   - netmask:
 */

  $start = time();

  include("acid_constants.inc");
  include("acid_conf.php");
  include("acid_include.inc");
  include_once("acid_db_common.php");
  include_once("acid_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_stat_ipaddr.php");
  $cs->ReadState();

  $ip = ImportHTTPVar("ip");
  $netmask = ImportHTTPVar("netmask");
  $action = ImportHTTPVar("action");
  $submit = ImportHTTPVar("submit");

  $page_title = $ip.'/'.$netmask;
  PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

function PrintPortscanEvents($db, $ip)
{
  GLOBAL $portscan_file;

  if ( !$portscan_file )
  {
     ErrorMessage("PORTSCAN EVENT ERROR: ".
                  "No file was specified in the \$portscan_file variable.");
     return;
  }

  $fp = fopen($portscan_file,"r");
  if ( !$fp )
  {
     ErrorMessage("PORTSCAN EVENT ERROR: ".
                  "Unable to open Portscan event file '".$portscan_file."'");
     return;
  }

  echo '<TABLE BORDER=1 width="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
        <TR>
           <TD CLASS="plfieldhdr">Date/Time</TD>
           <TD CLASS="plfieldhdr">Source IP</TD>
           <TD CLASS="plfieldhdr">Source Port</TD>
           <TD CLASS="plfieldhdr">Destination IP</TD>
           <TD CLASS="plfieldhdr">Destination Port</TD>
           <TD CLASS="plfieldhdr">TCP Flags</TD>
        </TR>';

  $total = 0;

  while ( !feof($fp) )
  {
   $contents = fgets($fp, 255);   

   if(ereg($ip, $contents)) {
     $total++;
     if( $i % 2 == 0 ) {
        $color="DDDDDD";
     }else{
        $color="FFFFFF";
     }
     $contents = ereg_replace("  "," ",$contents);
     $elements = explode(" ", $contents);
     echo '<tr bgcolor='.$color.'><td align="center">'.
             $elements[0].' '.$elements[1].' '.$elements[2].'</td>';
     ereg("([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*):([0-9]*)",$elements[3],$store);
     echo '<td align="center">'.$store[1].'</td>';
     echo '<td align="center">'.$store[2].'</td>';
     ereg("([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*):([0-9]*)",$elements[5],$store);
     echo '<td align="center">'.$store[1].'</td>';
     echo '<td align="center">'.$store[2].'</td>';
     echo '<td align="center">'.$elements[7].'</td></tr>';

   }
  }

  fclose($fp);

  echo '<TR>
         <TD CLASS="plfieldhdr" align="left">Total Hosts Scanned</TD>
         <TD CLASS="plfieldhdr">'.$total.'</TD>
         <TD CLASS="plfieldhdr" colspan="4">&nbsp;</TD>
        </TR>
        </TABLE>';
}

function PrintEventsByIP($db, $ip)
{
  $count = 0;
  /* Jeffs stuff */
  /* Count total events for the given address */
  $event_cnt = EventCntByAddr($db, $ip);

  /* Grab unique alerts and count them */
  $unique_events = UniqueEventCntByAddr($db, $ip, $count);
  $unique_event_cnt = count($unique_events);

 echo '<B>'.$unique_event_cnt.' unique alerts detected among '.$event_cnt.' alerts on '.
       $ip.'/32</B><BR>';
   
  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Signature</TD>
           <TD CLASS="plfieldhdr">Total<BR> Occurrences</TD>
           <TD CLASS="plfieldhdr">Num of Sensors</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurrence</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurrence</TD>
        </TR>';

 for ( $i = 0; $i < $unique_event_cnt; $i++ ) 
 {
   $current_event = $unique_events[$i];

   $total = UniqueEventTotalsByAddr($db, $ip, $current_event);
   $num_sensors = UniqueSensorCntByAddr($db, $ip, $current_event);
   $start_time = StartTimeForUniqueEventByAddr($db, $ip, $current_event);
   $stop_time = StopTimeForUniqueEventByAddr($db, $ip, $current_event);

   /* Print out */ 
   echo '<TR>';
   echo "  <TD ALIGN=CENTER> ".BuildSigByID($unique_events[$i], $db);
   $tmp_iplookup = 'acid_qry_main.php?new=1'.
                   '&sig%5B0%5D=%3D&sig%5B1%5D='.(rawurlencode(GetSignatureName($unique_events[$i], $db))).
                   '&num_result_rows=-1'.
                   '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                   BuildIPFormVars($ip);

   $tmp_sensor_lookup = 'acid_stat_sensor.php?'.
                        'sig%5B0%5D=%3D&sig%5B1%5D='.
                        (rawurlencode($unique_events[$i])).
                        '&ip_addr_cnt=2'.BuildIPFormVars($ip);

   echo "  <TD ALIGN=CENTER> <A HREF=\"$tmp_iplookup\">$total</A> ";
   echo "  <TD ALIGN=CENTER> <A HREF=\"$tmp_sensor_lookup\">$num_sensors</A> ";
   echo "  <TD ALIGN=CENTER> $start_time";
   echo "  <TD ALIGN=CENTER VALIGN=CENTER> $stop_time";
   echo '</TR>';
}

echo "</TABLE>\n";
}

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  if ( strstr($sig[1], "spp_portscan") )
     $sig[1] = "";

  /*  Build new link for criteria-based sensor page 
   *                    -- ALS <aschroll@mitre.org>
   */
   $tmp_sensor_lookup = 'acid_stat_sensor.php?ip_addr_cnt=2'.
                        BuildIPFormVars($ip);


   $tmp_srcdst_iplookup = 'acid_qry_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                          BuildIPFormVars($ip);

   $tmp_src_iplookup    = 'acid_qry_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildSrcIPFormVars($ip);

   $tmp_dst_iplookup    = 'acid_qry_main.php?new=2'.
                          '&num_result_rows=-1'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildDstIPFormVars($ip);
?>

<CENTER>
 <FONT> all alerts with      
     <?php
       echo $ip.'/'.$netmask;
      ?>  as :</FONT> 
<?php
  echo '
 <A HREF="'.$tmp_src_iplookup.'">source</A> | 
 <A HREF="'.$tmp_dst_iplookup.'">destination</A> | 
 <A HREF="'.$tmp_srcdst_iplookup.'">source/destination</A><BR>';

 echo 'show:
       <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=events">unique alerts</A>
       &nbsp; | &nbsp;
       <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=portscan">portscan events</A>
       </FONT><BR>';

 echo '<FONT>
       Registry lookup (whois) in: ';
 //if ( !VerifySocketSupport() )
    echo '
       <A HREF="http://www.arin.net/cgi-bin/whois.pl?queryinput='.$ip.'">ARIN</A> |
       <A HREF="http://www.ripe.net/perl/whois?query='.$ip.'">RIPE</A>
       <A HREF="http://www.apnic.net/apnic-bin/whois.pl?search='.$ip.'">APNIC</A><BR>';

 echo '<FONT>External: '.
      '<A HREF="'.$external_dns_link.$ip.'">DNS</A> | '.
      '<A HREF="'.$external_whois_link.$ip.'">whois</A> | '.
      '<A HREF="'.$external_all_link.$ip.'">SamSpade</A><BR>';
?>
 <P>

</CENTER>
<HR>

<FORM METHOD="POST" ACTION="acid_stat_ipaddr.php">

<?php
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>action</TD><TD>submit</TD><TD>ip</TD><TD>netmask</TD></TR>
             <TR><TD>'.$action.'</TD><TD>'.$submit.'</TD>
                 <TD>'.$ip.'</TD><TD>'.$netmask.'</TD></TR>
           </TABLE>';

  /* Print the Statistics the IP address */
  echo '<CENTER><B>'.$ip.'</B><BR>FQDN: <B>';
  
  if ( $resolve_IP == 0 )
     echo '  (no DNS resolution attempted)';
  else
  {
    if ( $ip != "255.255.255.255" )
        echo acidGetHostByAddr($ip, $db, $dns_cache_lifetime);
     else
        echo $ip.' (Broadcast)';
  } 

  if ( VerifySocketSupport() )
     echo '&nbsp;&nbsp;( <A HREF="acid_stat_ipaddr.php?ip='.$ip.'&netmask='.$netmask.'&action=whois">local whois</A> )';
 
  echo    '</B>
        <TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Num of <BR>Sensors</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Src.</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Dest.</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurance</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurance</TD>
        </TR>';

  $ip_src32 = acidIP2long($ip);
  $ip_dst32 = $ip_src32;

  /* Number of Sensors, First, and Last timestamp */
  $temp = "SELECT COUNT(DISTINCT sid), MIN(timestamp), MAX(timestamp) FROM acid_event ".  
          "WHERE (ip_src = $ip_src32 OR ip_dst = $ip_dst32 )";
  $result2 = $db->acidExecute($temp);
  $row2 = $result2->acidFetchRow();

  $num_sensors = $row2[0];
  $start_time = $row2[1]; 
  $stop_time = $row2[2];
  $result2->acidFreeRows();

  /* Unique instances as Source Address  */
  $temp = "SELECT COUNT(sid) from acid_event WHERE ip_src=$ip_src32";  
  $result2 = $db->acidExecute($temp);
  $row2 = $result2->acidFetchRow();
  $num_src_ip = $row2[0];
  $result2->acidFreeRows(); 

  /* Unique instances Dest. Address  */
  $temp = "SELECT COUNT(sid) from acid_event WHERE ip_dst=$ip_dst32";
  $result2 = $db->acidExecute($temp);
  $row2 = $result2->acidFetchRow();
  $num_dst_ip = $row2[0];
  $result2->acidFreeRows(); 

  /* Print out */ 
  echo '<TR>
         <TD ALIGN=CENTER><A HREF="'.$tmp_sensor_lookup.'">'.$num_sensors.'</A>';
  if ( $num_src_ip == 0 )
         echo '<TD ALIGN=CENTER>'.$num_src_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_src_iplookup.'">'.$num_src_ip.'</A>';
  if ( $num_dst_ip == 0 )         
         echo '<TD ALIGN=CENTER>'.$num_dst_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_dst_iplookup.'">'.$num_dst_ip.'</A>';
  echo '
         <TD ALIGN=CENTER>'.$start_time.'
         <TD ALIGN=CENTER VALIGN=CENTER>'.$stop_time.'
       </TR>
      </TABLE></CENTER>';

  if ( $action == "events" )
  {
     echo '<HR>
            <CENTER><P>';
     PrintEventsByIP($db, $ip);
     echo ' </CENTER>';	
  }
  else if ( $action == "whois" )
  {
     echo "\n<B>Whois Information</B>".
          "<PRE>".acidGetWhois($ip, $db, $whois_cache_lifetime)."</PRE>";
  }
  else if ( $action == "portscan" )
  {
     echo '<HR>
            <CENTER><P>';
     PrintPortscanEvents($db, $ip);
     echo ' </CENTER>';	
  }  

  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>





