#ifndef CalendarUser_h
#define CalendarUser_h

#include "CalendarProtocols.h"

//#include "CalendarGroup.h"

#include <Foundation/Foundation.h>
@class CalendarDomain;
//@class CalendarEvent;

@protocol CalendarUser
/*
- (NSString *) name;
- (NSString *) password;
- (NSDictionary *) userInfo;
- (NSTimeZone *) timeZone;

- (BOOL) setTimeZone:(NSTimeZone *)timeZone;
- (BOOL) setPassword:(NSString *)newPassword;
- (BOOL) setUserInfo:(NSDictionary *)info;

- (CalendarGroup *) calendarGroupWithName:(NSString *)name;
- (void) removeCalendarGroupWithName:(NSString *)name;
- (NSArray *) calendarGroups;

- (id <CalendarEvent>) setCalendarEvent:(id <CalendarEvent>)event;
- (NSArray *) calendarEvents;
- (id <CalendarEvent>) calendarEventWithName:(NSString *)name;
*/
@end

@interface CalendarUser:NSObject <CalendarPrimitive>
{
	CalendarDomain *__domain;

	NSString *_name;
	NSString *_password;
	NSTimeZone *_timeZone;
	NSDictionary *_infoDict;

	/*

	NSMutableDictionary *_eventDict;
	NSMutableDictionary *_eventTrashDict;
	NSMutableDictionary *_groupDict;
	*/
}

+ (void) resetCurrentCalendarUser;
- (void) setCurrentCalendarUser;
+ (id) currentCalendarUser;

+ (CalendarUser *) calendarUserWithCalendarDomain:(CalendarDomain *)domain
										 userName:(NSString *)userName
										 password:(NSString *)password
										 timeZone:(NSTimeZone *)timeZone
										 infoDict:(NSDictionary *)info;

- (id) initWithCalendarDomain:(CalendarDomain *)domain
					 userName:(NSString *)userName
					 password:(NSString *)password
					 timeZone:(NSTimeZone *)timeZone
					 infoDict:(NSDictionary *)info;

- (NSString *)name;
- (NSString *)password;
- (NSDictionary *) infoDict;
- (NSTimeZone *)timeZone;

- (id) setCurrentUser;

@end

@interface CalendarUserManager:NSObject <CalendarUser>
{
	CalendarUser *_user;
}

- (id) initWithCalendarUser:(CalendarUser *)user;
- (NSString *) name;

@end
#endif
