#ifndef _LEVEL_H
#define _LEVEL_H

#include "mudtypes.h"
#include "strings.h"
#include "errlog.h"
#include "parse.h"
#include "flags.h"
#include "entity.h"
#include "mudobject.h"
#include "specials.h"

class Level : public Entity {
 public:

   Level();
   virtual ~Level();
   Level(char *level_name);

   void set_chain_name(char *new_name);
   char *get_chain_name();
   void set_award_string(char *new_str);
   char *get_award_string();
   void set_level_str(char *new_str);
   char *get_level_str();
   void set_lvl_num(int new_num);
   int  get_lvl_num();
   void set_min_str(int new_num);
   int  get_min_str();
   void set_min_dex(int new_num);
   int  get_min_dex();
   void set_min_intel(int new_num);
   int  get_min_intel();
   void set_min_exp(int new_num);
   int  get_min_exp();
   void set_min_con(int new_num);
   int  get_min_con();
   void set_min_wisdom(int new_num);
   int  get_min_wisdom();
   void set_min_cha(int new_num);
   int  get_min_cha();
   void set_req_abilities(char *new_str);
   char *get_req_abilities();
   void set_special_req_str(char *new_str);
   char *get_special_req_str(void);
   void set_special_req(Specials *the_special);
   void set_when_awarded_str(char *new_str);
   char *get_when_awarded_str(void);
   void set_when_awarded(Specials *the_special);
   special_holder *get_when_awarded();
   special_holder *get_special_req();


   int load_level(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();
   virtual void write_object(FILE *the_file, int is_builder);

   int is_modified();
   void set_modified(int the_num);

   Flags *get_lvl_flags();


 private:

   int            modified;

   Strings        chain_name;
   Strings        award_string;
   Strings        level_str;
   int            lvl_num;
   int            min_str;
   int            min_dex;
   int            min_intel;
   int            min_exp;
   int            min_con;
   int            min_wisdom;
   int            min_cha;
   Strings        req_abilities;

   Strings        special_req_str;   
   special_holder *special_req;

   Strings        when_awarded_str;
   special_holder *when_awarded;

   Flags          *lvl_flags;
};

#endif
