#ifndef _TEXT_H
#define _TEXT_H

#include "mudtypes.h"
#include "strings.h"
#include "errlog.h"
#include "parse.h"
#include "entity.h"


#define TEXT_TYPE_HELP    1
#define TEXT_TYPE_INFO    2
#define TEXT_TYPE_BANNER  3

#ifdef TEXT_C

char *texttypename[] = {"Invalid", "Help", "Info", "Banner",
       NULL};

#else

extern char *texttypename[];

#endif

class Builder;

class Text : public Entity {
 public:

   Text();
   ~Text();
   Text(char *action_name, int the_type);

   virtual int set_title(char *the_string);
   char *get_title();

   int set_body(char *the_string);
   char *get_body();

   int get_text_type();
   int load_text();
   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

 private:

   int     text_type;
   Strings title;
   Strings body;

};

#endif
