
#ifndef MODULES_H
#define MODULES_H

#include "../../include/strings.h"
#include "aberpdirt.h"
#include "aime.h"

typedef int (*Module_Func)(FILE *, FILE *, char *, float);

struct mod_function {
   char        *module_name;
   Module_Func the_func;
   float       number;
};

#ifdef MODULES_C

mod_function mod_list[] = {
  {"aber_pdirt", ap_convert, 0.0},
  {"AIME_v0.53", aime_to_pseudo, (float) 0.53},
  {"AIME_v0.54", aime_to_pseudo, (float) 0.54},
  {"AIME_v0.55", aime_to_pseudo, (float) 0.55},
  {"AIME_v0.56", aime_to_pseudo, (float) 0.56},
  {"AIME_v0.57", aime_to_pseudo, (float) 0.57},
  {"AIME_v0.58", aime_to_pseudo, (float) 0.58},
  {"AIME_v0.59", aime_to_pseudo, (float) 0.59},
  {"AIME_V0.59.1", aime_to_pseudo, (float) 0.591},
  {"AIME_v0.59.2", aime_to_pseudo, (float) 0.592},
  {"AIME_v0.60.1", aime_to_pseudo, (float) 0.601},
  {NULL, NULL, 0.0}
};

#else

extern mod_function mod_list[];

#endif

int convert_file(FILE *read_file, char *write_filename, char *format, 
                                                           char *filename);
int verify_version(char *the_version);
int execute_convert(char *the_version, FILE *read_file, FILE *write_file,
                                                        char *filename);
int ask_version(Strings *the_str);
int convert_all(char *format);


#endif





