<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">
     
<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write thumbnail html pages -->
<xsl:template match="album" mode="contactsheets">
<xsl:for-each select="subalbum">
  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_thumbs.html')}"> 
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <style type="text/css">
          &lt;!--
          
		a:link		{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:active	{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:visited	{color:#0066ff;		text-decoration: none;		font-size:8pt}
		a:hover 	{color:#ffffff; 	text-decoration: none; 		font-size:8pt}
        
        font.title{		font-size:			12pt;
						font-weight:		bold;
						text-transform:		uppercase;
						color:				#0066ff;
						letter-spacing:		5pt;	
						font-family:		"Times New Roman";}
		font.desc{		font-size:			8pt;
						font-weight:		normal;
						color:				#ffffff;
						font-family:		"Tahoma";}
        font.credits{	color:				#aaaaaa;
						font-weight:		thin;
						font-style:			italic;
						font-size:			8pt;
						font-family:		"Times New Roman";
						background-color:	#222222}
	
		div.titBox{		border-width:		0;
						background-color:	#000000;
						padding:			5px 5px 5px 5px;
						position:			absolute;
						left:				0;
						top:				0;}	
		div.thumbsBox{	border-width:		0;
						background-color:	#000000;
						padding:			5px 5px 5px 5px;
						position:			absolute;
						left:				0;
						top:				130;}				
		div.botNavBox{	border-width:		0;
						background-color:	#000000;
						padding:			3px;
						position:			absolute;
						left:				220;
						top:				70;}
		div.creditBox{	border-width:		0;
						background-color:	black;
						padding:			2px;
						position:			absolute;
						left:				243;
						top:				100;}
          --&gt;
        </style>
        <title><xsl:value-of select="name"/></title>
      </head>
      <body bgcolor="#000000" text="#ffffff" background="resources/scanline.jpg">
               
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY SUBALBUM NAME/DESC   -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <div class="titBox">
        <font class="title"><xsl:value-of select="name"/></font>
        <hr color="blue" width="600" align="left"/>
		<font class="desc"><xsl:value-of select="description"/></font>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
		
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THUMBS/INDEX BUTTONS -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        <div class="botNavBox">
        <table border="0" bgcolor="#00356A">
          <tr>
            <td width="80">
				<script type="text/javascript" language="JavaScript">
				<![CDATA[
				<!-- HIDE FROM OLD BROWSERS
				document.write("  <a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
				document.write("SLIDESHOW");
				document.write("  </a>")
				-->
				]]>
				</script>
			</td>
			<td width="10"></td>
			<td width="80">
				<a href="Album.html">ALBUM INDEX</a>
			</td>
		  </tr>
		</table>
        </div>
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->


		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THE CREDITS          -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<div class="creditBox">
		<font class="credits">Generated by <a href="http://albumshaper.sourceforge.net">Album Shaper</a></font>
		</div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        
        
        <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY IMAGE THUMBNAILS     -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->       
        <div class="thumbsBox">
          <table border="0" cellspacing="0" cellpadding="5" bgcolor="#00356A">
            <tr>
              <xsl:for-each select="photo">
              <xsl:variable name="photoDescription" select="description"/>
              <td valign="top" align="center" width="290" bgcolor="#00356A">
              
				<!-- THUMB AND TEXT LINK TO FULL IMAGE -->
				
                 <xsl:if test="$smallWebExport=0">                                                                 
				<a href="img/{$subalbumNumber}/{position()}.jpg">
				<img src="img/{$subalbumNumber}/{position()}_thumb.jpg" border="0" alt="{$photoDescription}"/></a>
				<br/>
				<a href="img/{$subalbumNumber}/{position()}.jpg"><xsl:value-of select="description"/></a>
                </xsl:if>

                <xsl:if test="$smallWebExport=1">      
                 <a href="img/{$subalbumNumber}/{position()}_slideshow.jpg">
				<img src="img/{$subalbumNumber}/{position()}_thumb.jpg" border="0" alt="{$photoDescription}"/>></a>
				<br/>
                 <a href="img/{$subalbumNumber}/{position()}_slideshow.jpg">
				<xsl:value-of select="description"/></a>
                </xsl:if>

				<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
              
              </td>
              
              <!-- END THE ROW AFTER 3 IMAGES   -->
              <xsl:if test="not(position() mod 2)">
                <xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr&gt;</xsl:text>
              </xsl:if>
              <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
              
              </xsl:for-each>
              
              <!-- BALANCE GRID WITH TD TAGS    -->
              <xsl:call-template name="endRow">
                <xsl:with-param name="cellsLeft" select="(2 - (count(photo) mod 2))"/>
              </xsl:call-template>
              <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
              
            </tr>
          </table>
        </div>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
        
        
      </body>
    </html>
  </xsl:document>
</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
