//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_CONFIGURATIONWIDGET_H
#define CONFIGURATION_CONFIGURATIONWIDGET_H

//forward declarations
class QGridLayout;
class QIconView;
class QIconViewItem;
class QPushButton;
class GroupIcon;
class QFrame;

class Configuration;
class AlertsWidget;
class LayoutSettingsWidget;
class LoadingSavingWidget;
class GroupsWidget;

#include <qdialog.h>

//=====================================
/*! \brief Configuration/Settings Interface
 */
//=====================================

class ConfigurationWidget : public QDialog
{
Q_OBJECT
public:
  ConfigurationWidget(Configuration* config,
                                    QWidget *parent=0,
                                    const char* name=0);
//----------------------
signals:
void closed();
//----------------------
private slots:
///updates shown settings dialogue based on newly selected group
void updateDialogue( QIconViewItem* selection);

///repaints a group icon if move is moved over it
void repaintGroup( QIconViewItem* pseudoSelection);

///clears any pseudo selections
void clearPseudoSelection();

//save settings
void saveSettings();

void reject();
//----------------------
private:
  void closeEvent( QCloseEvent* e);

  ///Backend config object pointer
  Configuration* config;

  ///Grid widgets place in
  QGridLayout* grid;

  ///list of subalbums
  GroupsWidget* groups;

  ///settings widgets
  LoadingSavingWidget* loadingSavingWidget;
  LayoutSettingsWidget* layoutWidget;
  AlertsWidget* alertsWidget;
  QWidget* currentSettingsWidget;

  //currently hovered over group icon
  GroupIcon* currentPseudoSelection;

  ///settings icons
  GroupIcon *alertsIcon, *layoutIcon, *loadingSavingIcon;

  //ok and cancel buttons, frame, and grid
  QFrame* buttonsFrame;
  QPushButton *okButton, *cancelButton;
  QGridLayout*  buttonsGrid;
};
//======================

#endif //CONFIGURATION_CONFIGURATIONWIDGET_H
