//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_PHOTODESCEDIT_H
#define GUI_PHOTODESCEDIT_H

//--------------------
//forward declarations
class QGridLayout;
class QLabel;
class QTimer;
class QImage;
class QPixmap;
class QTextEdit;
class PhotoPreviewWidget;
class TextEdit;
//--------------------

#define STATIC 0
#define APPEARING 1
#define DISAPPEARING 2
#define DISAPPEARED 3

#include <qwidget.h>
#include <qdatetime.h>
#include <qtextedit.h>
//=====================================
class PhotoDescEdit : public QWidget
{
Q_OBJECT
//----------------------
public:
  PhotoDescEdit( PhotoPreviewWidget* ppw, bool useAnimation, QWidget *parent=0, const char* name=0);
  ~PhotoDescEdit();
//----------------------
public slots:
  void hide();
//----------------------
private slots:
  ///this method is iteratively called and animates the opening/closing of the image
  void animate();

  ///this method is called by the acceptAndClose and rejectAndClose
  ///slots and actually initiates the closing process
  void disappear();
//----------------------
private:
  ///actually animate the opening/closing process?
  bool useAnimation;

  ///photo preview widget pointer
  PhotoPreviewWidget* ppw;

   ///beginning and end pixmaps
  QImage *imageLarge;

  ///text area widget used to computing painting surface
  QImage* textRectangle;

  //beginning and end positions of the photo
  QPoint initPos, finalPos;

  ///bounaries of entire animation
  int left, right, top, bottom;

  ///ultimate text dimension
  int idealTextSize;

  ///this pixmap contains the screen contents for the entire
  ///region which we will be painting on top of
  QPixmap* backgroundImage;

  ///small size
  int smallWidth, smallHeight;
  ///-------------------------------------
  //Main grid
   QGridLayout* mainGrid;
  ///-------------------------------------
  ///Animating Widgets

  ///label which shows moving and expanding photo on background
  QLabel* animationLabel;

  ///buffer we'll iteratively update and use for the label which shows the animation taking place
  QPixmap* buffer;
  ///-------------------------------------
  ///Static Widgets

  ///grid static widgets placed in
  QGridLayout* staticGrid;

  ///frame which contains static widget
  QWidget* staticFrame;

  ///photo being displayed
  QLabel* staticPhoto;

  ///photo description
  TextEdit* photoDesc;
  ///-------------------------------------
  ///Animation Stuff

  //timer stuff
  int initDelay, accel, minDelay, step, delay;

  //appearing or disappearing
  int mode;

  ///are drop shadows enabled in windows (xp)?
  bool dropShadowsEnabled;

  //timer and time variables for ongoing animation
  QTimer* timer;
  QTime lastTime, currentTime;
  ///-------------------------------------
};

//======================
class TextEdit : public QTextEdit
{
Q_OBJECT
//----------------------
public:
  TextEdit(QWidget *parent=0, const char* name=0);
  void paintNow();
//----------------------
private:
    QPopupMenu* contextMenu;
//----------------------
protected:
  void keyPressEvent ( QKeyEvent* e );
  void focusOutEvent ( QFocusEvent* );
  QPopupMenu* createPopupMenu ( const QPoint& pos );
//----------------------
signals:
  void finished();
//----------------------
private slots:
  void contextMenuHiding();
};
//======================



#endif //GUI_PHOTODESCEDIT_H
