# ---------------------------------------------------------------------------
# - t_7500.als                                                              -
# - aleph:www library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   aleph:www url test module
# @author amaury darsch

# get the library
interp:library "aleph-www"

# check for a simple url
trans  url (aleph:www:Url "http://www.aleph-lang.org")
assert "http" (url:get-scheme)
assert "www.aleph-lang.org" (url:get-host)
assert 80      (url:get-port)
assert "/"     (url:get-path)
assert ""      (url:get-query)
assert ""      (url:get-fragment)

# check for a complete url
trans url (aleph:www:Url "http://a.b.org:2003/example?val=hello+world#good")
assert "http"            (url:get-scheme)
assert "a.b.org"         (url:get-host)
assert 2003              (url:get-port)
assert "/example"        (url:get-path)
assert "val=hello+world" (url:get-query)
assert "good"            (url:get-fragment)
