// ---------------------------------------------------------------------------
// - cmth.cxx                                                                -
// - standard system library - c math function implementation                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cthr.hpp"
#include "csys.hpp"
#include "cmth.hpp"
#include "cmth.hxx"

namespace aleph {

  // static mutex creation function
  static void* mtx_create (void);
  // mutex or network services
  static void* mtx = mtx_create ();

  // this function destroy the mutex at exit
  static void mtx_destroy (void) {
    c_mtxdestroy (mtx);
  }

  // this function initialize a mutex statically and register its
  // destruction to be done at exit
  static void* mtx_create (void) {
    void* mtx = c_mtxcreate ();
    c_atexit (mtx_destroy);
    return mtx;
  }

  // return a random number - this function needs a mutex since
  // they are not multi-thread safe

  long c_random (void) {
    c_mtxlock (mtx);
    long result = rand ();
    c_mtxunlock (mtx);
    return result;
  }
  
  // return true if the number is nan

  bool c_isnan (const double x) {
    return (isnan (x) == 0) ? false : true;
  }

  // return the ceiling of the argument

  double c_ceiling (const double x) {
    return ceil (x);
  }

  // return the floor of the argument

  double c_floor (const double x) {
    return floor (x);
  }

  // return the absolute value of the argument

  double c_abs (const double x) {
    return fabs (x);
  }

  // return the remainder of x divided by y

  double c_mod (const double x, const double y) {
    return fmod (x,y);
  }

  // return the square root of the double
 
  double c_sqrt (const double x, bool& status) {
    if (x < 0.0) {
      status = false;
      return 0.0;
    }
    errno  = 0;
    double result = sqrt (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the log of the argument
 
  double c_log (const double x, bool& status) {
    errno  = 0;
    double result = log (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the exponential of the argument
 
  double c_exp (const double x) {
    return exp (x);
  }

  // return the power of x with y
 
  double c_pow (const double x, const double y) {
    return pow (x,y);
  }

  // return the sine of x
 
  double c_sin (const double x) {
    return sin (x);
  }

  // return the cosine of x
 
  double c_cos (const double x) {
    return cos (x);
  }

  // return the tangent of x
 
  double c_tan (const double x) {
    return tan (x);
  }

  // return the arc sine of the argument
 
  double c_asin (const double x, bool& status) {
    errno  = 0;
    double result = asin (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the arc cosine of the argument
 
  double c_acos (const double x, bool& status) {
    errno  = 0;
    double result = acos (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the arc tangent of the argument
 
  double c_atan (const double x, bool& status) {
    errno  = 0;
    double result = atan (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic sine of the argument
 
  double c_sinh (const double x, bool& status) {
    errno  = 0;
    double result = sinh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic cosine of the argument
 
  double c_cosh (const double x, bool& status) {
    errno  = 0;
    double result = cosh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic tangent of the argument
 
  double c_tanh (const double x, bool& status) {
    errno  = 0;
    double result = tanh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic arc sine of the argument
 
  double c_asinh (const double x, bool& status) {
    errno  = 0;
    double result = asinh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic arc cosine of the argument
 
  double c_acosh (const double x, bool& status) {
    errno  = 0;
    double result = acosh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }

  // return the hyperbolic arc tangent of the argument
 
  double c_atanh (const double x, bool& status) {
    errno  = 0;
    double result = atanh (x);
    if (errno != 0) {
      status = false;
      return 0.0;
    }
    status = true;
    return result;
  }
}
