/* $Id: wmbutton.c,v 1.11 2000/06/18 18:59:37 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmain.h"
#include "wmclient.h"
#include "wmbutton.h"
#include "wmdrag.h"
#include "wmmisc.h"
#include <X11/Xlib.h>

static void wm_button_realize (GtkWidget *widget, gpointer data);
static gint wm_button_press(GtkWidget *widget, GdkEventButton *event, 
			    gpointer data);
static gint wm_button_drag(GtkWidget *widget, GdkEventMotion *event, 
			   gpointer data);
static gint wm_button_release(GtkWidget *widget, GdkEventButton *event, 
			      gpointer data);
static void wm_button_class_init(WmButtonClass *class);
static void wm_button_init(WmButton *wm_button);

guint wm_button_get_type(void)
{
    static guint wm_button_type = 0;

    if (!wm_button_type) {
	GtkTypeInfo wm_button_info =
	{
	    "WmButton",
	    sizeof (WmButton),
	    sizeof (WmButtonClass),
	    (GtkClassInitFunc) wm_button_class_init,
	    (GtkObjectInitFunc) wm_button_init,
	    (GtkArgSetFunc) NULL,
	    (GtkArgGetFunc) NULL
	};

	wm_button_type = gtk_type_unique(gtk_button_get_type(), 
					 &wm_button_info);
    }
    return wm_button_type;
}

enum {
    WM_BUTTON_PRESS1,
    WM_BUTTON_PRESS2,
    WM_BUTTON_PRESS3,
    WM_BUTTON_DOUBLE1,
    WM_BUTTON_DOUBLE2,
    WM_BUTTON_DOUBLE3,
    WM_BUTTON_DRAG1,
    WM_BUTTON_DRAG2,
    WM_BUTTON_DRAG3,
    WM_BUTTON_RELEASE1,
    WM_BUTTON_RELEASE2,
    WM_BUTTON_RELEASE3,
    LAST_SIGNAL
};

static gint wm_button_signals[LAST_SIGNAL] = { 0 };

static void wm_button_class_init(WmButtonClass *class)
{
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass*) class;

    wm_button_signals[WM_BUTTON_PRESS1] = 
	gtk_signal_new("press1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, press1),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_PRESS2] = 
	gtk_signal_new("press2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, press2),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_PRESS3] = 
	gtk_signal_new("press3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, press3),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    wm_button_signals[WM_BUTTON_DOUBLE1] = 
	gtk_signal_new("double1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, double1),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_DOUBLE2] = 
	gtk_signal_new("double2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, double2),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_DOUBLE3] = 
	gtk_signal_new("double3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, double3),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    wm_button_signals[WM_BUTTON_DRAG1] = 
	gtk_signal_new("drag1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, drag1),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_DRAG2] = 
	gtk_signal_new("drag2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, drag2),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_DRAG3] = 
	gtk_signal_new("drag3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, drag3),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    wm_button_signals[WM_BUTTON_RELEASE1] = 
	gtk_signal_new("release1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, release1),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_RELEASE2] = 
	gtk_signal_new("release2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, release2),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_button_signals[WM_BUTTON_RELEASE3] = 
	gtk_signal_new("release3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmButtonClass, release3),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    gtk_object_class_add_signals(object_class, wm_button_signals, LAST_SIGNAL);

    class->press1   = NULL;
    class->press2   = NULL;
    class->press3   = NULL;
    class->double1  = NULL;
    class->double2  = NULL;
    class->double3  = NULL;
    class->drag1    = NULL;
    class->drag2    = NULL;
    class->drag3    = NULL;
    class->release1 = NULL;
    class->release2 = NULL;
    class->release3 = NULL;
}

static void wm_button_init(WmButton *wm_button)
{
    GtkWidget *button;
         
    button = gtk_button_new();
    gtk_widget_show(button);
}

GtkWidget* wm_button_new(void)
{
    GtkWidget *button;
    button = GTK_WIDGET(gtk_type_new(wm_button_get_type()));

    GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
    gtk_signal_connect(GTK_OBJECT(button), "realize",
		       GTK_SIGNAL_FUNC(wm_button_realize), NULL);
    return button;
}

GtkWidget* wm_button_new_default(GtkWidget* client)
{
    GtkWidget *button;
    button = wm_button_new();
    /*  all_clients ˤʤ褦ˤ. */
    wm_button_connect_event(button, all_clients);
    return button;
}

void wm_button_connect_event(GtkWidget *button, gpointer data)
{
    gtk_signal_connect (GTK_OBJECT (button), "button_press_event",
			GTK_SIGNAL_FUNC(wm_button_press), data);
    gtk_signal_connect (GTK_OBJECT (button), "motion_notify_event",
			GTK_SIGNAL_FUNC(wm_button_drag), data);
    gtk_signal_connect (GTK_OBJECT (button), "button_release_event",
			GTK_SIGNAL_FUNC(wm_button_release), data);
}

static void wm_button_realize(GtkWidget *widget, gpointer data)
{
    wm_message("WmButton: realize\n");
    wm_event_add(widget, 
		 GDK_BUTTON1_MOTION_MASK |
		 GDK_BUTTON2_MASK | GDK_BUTTON2_MOTION_MASK |
		 GDK_BUTTON3_MASK | GDK_BUTTON3_MOTION_MASK);
}

static gint wm_button_press(GtkWidget *widget, GdkEventButton *event, 
			    gpointer data)
{
    guint signal;

    wm_message("WmButton[%x]: press\n", widget);
    wm_drag_start(widget, (WmGroup *)data, event->button, 
		  (int)(event->x_root), (int)(event->y_root));

    signal = (event->type == GDK_2BUTTON_PRESS) ?
	((event->button	== Button1) ? WM_BUTTON_DOUBLE1 :
	 (event->button	== Button2) ? WM_BUTTON_DOUBLE2 :
	 (event->button	== Button3) ? WM_BUTTON_DOUBLE3 : LAST_SIGNAL) :
	((event->button	== Button1) ? WM_BUTTON_PRESS1 :
	 (event->button	== Button2) ? WM_BUTTON_PRESS2 :
	 (event->button	== Button3) ? WM_BUTTON_PRESS3 : LAST_SIGNAL);

    if(signal != LAST_SIGNAL) {
	gtk_signal_emit(GTK_OBJECT(widget), wm_button_signals[signal], event);
    }
    return FALSE;
}


static gint wm_button_drag(GtkWidget *widget, GdkEventMotion *event, 
			   gpointer data)
{
    guint button, signal;

    if(wm_drag_get_widget() == NULL || wm_drag_get_widget() != widget) {
	wm_message("WmResize: dragInfo.widget is invalid!\n");
	return FALSE;
    }

    button = wm_drag_get_button();
    signal = ((button == Button1) ? WM_BUTTON_DRAG1 :
	      (button == Button2) ? WM_BUTTON_DRAG2 :
	      (button == Button3) ? WM_BUTTON_DRAG3 : LAST_SIGNAL);

    if(signal != LAST_SIGNAL) {
	gtk_signal_emit(GTK_OBJECT(widget), wm_button_signals[signal], event);
    }
    return FALSE;
}

static gint wm_button_release(GtkWidget *widget, GdkEventButton *event, 
			      gpointer data)
{
    guint signal;

    wm_drag_end();
    signal = ((event->button == Button1) ? WM_BUTTON_RELEASE1 :
	      (event->button == Button2) ? WM_BUTTON_RELEASE2 :
	      (event->button == Button3) ? WM_BUTTON_RELEASE3 : LAST_SIGNAL);

    if(signal != LAST_SIGNAL) {
	gtk_signal_emit(GTK_OBJECT(widget), wm_button_signals[signal], event);
    }
    return FALSE;
}



