/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/*
 * php4.swg
 *
 * PHP4 runtime library
 *
 */

#ifdef __cplusplus
extern "C" {
#endif
#include "zend.h"
#include "zend_API.h"
#include "php.h"

/* These TSRMLS_ stuff should already be defined now, but with older php under
   redhat are not... */
#ifndef TSRMLS_D
#define TSRMLS_D
#endif
#ifndef TSRMLS_DC
#define TSRMLS_DC
#endif
#ifndef TSRMLS_C
#define TSRMLS_C
#endif
#ifndef TSRMLS_CC
#define TSRMLS_CC
#endif

#ifdef __cplusplus
}
#endif

/* used to wrap returned objects in so we know whether they are newobject
   and need freeing, or not */
typedef struct _swig_object_wrapper {
  void * ptr;
  int newobject;
} swig_object_wrapper;

/* local scope self_constructors are set to 1 inside function wrappers
   which are also class constructors, so that the php4.swg output typemaps
   know whether or not to wrap returned objects in this_ptr or a new object */
int self_constructor=0;

/* empty zend destructor for types without one */
static ZEND_RSRC_DTOR_FUNC(SWIG_landfill) {};

/* This one makes old swig style string pointers but the php module doesn't
   use these any more.  This is just left here for old times sake and may go */
SWIGRUNTIME(void)
SWIG_MakePtr(char *c, void *ptr, swig_type_info *ty) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char data[32], *r;

  r = data;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= data) {
      *(c++) = *(r--);
    }
    strcpy (c, ty->name);
  } else {
    strcpy (c, "NULL");
  }
}

SWIGRUNTIME(void)
SWIG_SetPointerChar(char **c, void *ptr, swig_type_info *type) {
   char data[512];

   SWIG_MakePtr(data, ptr, type);
   *c = estrdup(data);
}

#define SWIG_SetPointerZval(a,b,c,d) SWIG_ZTS_SetPointerZval(a,b,c,d, SWIG_module_entry TSRMLS_CC)

SWIGRUNTIME(void)
SWIG_ZTS_SetPointerZval(zval *z, void *ptr, swig_type_info *type, int newobject, zend_module_entry* module_entry TSRMLS_DC) {
  swig_object_wrapper *value=NULL;
  /* No need to call SWIG_MakePtr here! */
  if (type->clientdata) {
    if (! (*(int *)(type->clientdata))) zend_error(E_ERROR, "Type: %s failed to register with zend",type->name);
    value=(swig_object_wrapper *)emalloc(sizeof(swig_object_wrapper));
    value->ptr=ptr;
    value->newobject=newobject;
    ZEND_REGISTER_RESOURCE(z, value, *(int *)(type->clientdata));
    return;
  } else { /* have to deal with old fashioned string pointer?
              but this should not get this far */
    zend_error(E_ERROR, "Type: %s not registered with zend",type->name);
  }
}

/* This old-style routine converts an old string-pointer c into a real pointer
   ptr calling making appropriate casting functions according to ty
   We don't use this any more */
SWIGRUNTIME(int)
_SWIG_ConvertPtr(char *c, void **ptr, swig_type_info *ty) {
   register int d;
   unsigned long p;
   swig_type_info *tc;

   if(c == NULL) {
   	*ptr = 0;
	return 0;
   }

   p = 0;
   if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) {
	return 0;
    } else {
	goto type_error;
    }
  }

    c++;
    /* Extract hex value from pointer */
    while ((d = *c)) {
      if ((d >= '0') && (d <= '9'))
        p = (p << 4) + (d - '0');
      else if ((d >= 'a') && (d <= 'f'))
        p = (p << 4) + (d - ('a'-10));
      else
        break;
      c++;
    }
    *ptr = (void *) p;
	
    if(ty) {
	tc = SWIG_TypeCheck(c,ty);
	if(!tc) goto type_error;
	*ptr = SWIG_TypeCast(tc, (void*)p);
    }
    return 0;

type_error:

    return -1;
}

/* This is a new pointer conversion routine
   Taking the native pointer p (which would have been converted from the old
   string pointer) and it's php type id, and it's type name (which also would
   have come from the old string pointer) it converts it to ptr calling 
   appropriate casting functions according to ty
   Sadly PHP has no API to find a type name from a type id, only from an instance
   of a resource of the type id, so we have to pass type_name as well.
   The two functions which might call this are:
   SWIG_ZTS_ConvertResourcePtr which gets the type name from the resource
   and the registered zend destructors for which we have one per type each
   with the type name hard wired in. */
SWIGRUNTIME(int)
SWIG_ZTS_ConvertResourceData(void * p, int type, const char *type_name, void **ptr, swig_type_info *ty TSRMLS_DC) {
  swig_type_info *tc;

  if (ty) {
    if (! type_name) {  
      /* can't convert p to ptr type ty if we don't know what type p is */
      return -1;
    } else {
      /* convert and cast p from type_name to ptr as ty
         Need to sort out const-ness, can SWIG_TypeCast really not take a const? */
      tc = SWIG_TypeCheck((char *)type_name,ty);
      if (!tc) return -1;
      *ptr = SWIG_TypeCast(tc, (void*)p);
    }
  } else {
    /* They don't care about the target type, so just pass on the pointer! */
    *ptr = (void *) p;
  }
  return 0;
}

/* This function fills ptr with a pointer of type ty by extracting the pointer
   and type info from the resource in z.  z must be a resource
   It uses SWIG_ZTS_ConvertResourceData to do the real work. */
SWIGRUNTIME(int)
SWIG_ZTS_ConvertResourcePtr(zval *z, void **ptr, swig_type_info *ty TSRMLS_DC) {
  swig_object_wrapper *value;
  void *p;
  int type;
  char *type_name;

  value = (swig_object_wrapper *) zend_list_find(z->value.lval,&type);
  p = value->ptr;
  if (type==-1) return -1;

  type_name=zend_rsrc_list_get_rsrc_type(z->value.lval);

  return SWIG_ZTS_ConvertResourceData(p,type,type_name,ptr,ty TSRMLS_CC);
}

/* But in fact SWIG_ConvertPtr is the native interface for getting typed
   pointer values out of zvals.  We need the TSRMLS_ macros for when we
   make PHP type calls later as we handle php resources */
#define SWIG_ConvertPtr(a,b,c) SWIG_ZTS_ConvertPtr(a,b,c TSRMLS_CC)

/* We allow passing of a STRING or RESOURCE pointing to the object
   or an OBJECT whose _cPtr is a string or resource pointing to the object
   STRING pointers are very depracated */
SWIGRUNTIME(int)
SWIG_ZTS_ConvertPtr(zval *z, void **ptr, swig_type_info *ty TSRMLS_DC) {
   char *c;
   zval *val;
   
   if(z == NULL) {
	*ptr = 0;
	return 0;
   }

   if (z->type==IS_OBJECT) {
     zval ** _cPtr;
     if (zend_hash_find(HASH_OF(z),"_cPtr",sizeof("_cPtr"),(void**)&_cPtr)==SUCCESS) {
       /* Don't co-erce to string if it isn't */
       if ((*_cPtr)->type==IS_STRING) c = Z_STRVAL_PP(_cPtr);
       else if ((*_cPtr)->type==IS_RESOURCE) {
         return SWIG_ZTS_ConvertResourcePtr(*_cPtr,ptr,ty TSRMLS_CC);
       } else goto type_error; /* _cPtr was not string or resource property */
     } else goto type_error; /* can't find property _cPtr */
   } else if (z->type==IS_RESOURCE) {
     return SWIG_ZTS_ConvertResourcePtr(z,ptr,ty TSRMLS_CC);
   } else if (z->type==IS_STRING) {
     c = Z_STRVAL_P(z); 
     return _SWIG_ConvertPtr(c,ptr,ty);
   } else goto type_error;

type_error:

    return -1;
}


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_librdf_node swig_types[0] 
#define  SWIGTYPE_p_librdf_parser swig_types[1] 
#define  SWIGTYPE_p_librdf_world swig_types[2] 
#define  SWIGTYPE_p_librdf_hash swig_types[3] 
#define  SWIGTYPE_p_librdf_statement swig_types[4] 
#define  SWIGTYPE_p_librdf_iterator swig_types[5] 
#define  SWIGTYPE_p_librdf_storage swig_types[6] 
#define  SWIGTYPE_p_librdf_uri swig_types[7] 
#define  SWIGTYPE_p_librdf_model swig_types[8] 
#define  SWIGTYPE_p_librdf_stream swig_types[9] 
#define  SWIGTYPE_p_librdf_serializer swig_types[10] 
static swig_type_info *swig_types[12];

/* -------- TYPES TABLE (END) -------- */

/* header section */
/*
  +----------------------------------------------------------------------+
  | PHP version 4.0                                                      |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors:                                                             |
  |                                                                      |
  +----------------------------------------------------------------------+
 */
#define SWIG_init	initredland

#define SWIG_name	"redland"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif
#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_redland.h"
#ifdef __cplusplus
}
#endif



#ifdef SWIGPERL
/* for perl, these are passed in by MakeMaker derived makefile */
#undef PACKAGE
#undef VERSION
#endif

/* SWIG BUG - no SWIGTCL is defined - duh */
#ifdef TCL_MAJOR_VERSION
  /* want symbols starting librdf_ not _librdf_ */
#undef SWIG_prefix
#define SWIG_prefix
#endif

#ifdef SWIGRUBY
/* Ruby pollutes the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <rdf_config.h>
#include <redland.h>

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);

#ifdef SWIGPYTHON
void librdf_python_world_init(librdf_world *world);
#endif
#ifdef SWIGPERL
void librdf_perl_world_init(librdf_world *world);
void librdf_perl_world_finish(void);
#endif


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#ifdef SWIGPYTHON
/* swig doesn't declare all prototypes */
static PyObject *_wrap_librdf_copyright_string_get(void);
static PyObject *_wrap_librdf_version_string_get(void);

static PyObject *_wrap_librdf_version_major_get(void);
static PyObject *_wrap_librdf_version_minor_get(void);
static PyObject *_wrap_librdf_version_release_get(void);


static PyObject *librdf_python_callback = NULL;

static PyObject * librdf_python_set_callback(PyObject *dummy, PyObject *args);

/*
 * set the Python function object callback
 */
static PyObject *
librdf_python_set_callback(dummy, args)
  PyObject *dummy, *args;
{
  PyObject *result = NULL;
  PyObject *temp;
  
  if (PyArg_ParseTuple(args, "O:set_callback", &temp)) {
    if (!PyCallable_Check(temp)) {
      PyErr_SetString(PyExc_TypeError, "parameter must be callable");
      return NULL;
    }
    Py_XINCREF(temp);         /* Add a reference to new callback */
    Py_XDECREF(librdf_python_callback);  /* Dispose of previous callback */
    librdf_python_callback = temp;       /* Remember new callback */
    /* Boilerplate to return "None" */
    Py_INCREF(Py_None);
    result = Py_None;
  }
  return result;
}


/* Declare a table of methods that python can call */
static PyMethodDef librdf_python_methods [] = {
    {"set_callback",  librdf_python_set_callback, METH_VARARGS,
     "Set python message callback."},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};


/*
 * calls a python function defined as:
 *   RDF.message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_python_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
#ifdef PYTHON_EXCEPTIONS_WORKING
  PyObject *arglist;
  PyObject *result;
#endif
  char *buffer;
  int len;
  va_list args_copy;

  if(!librdf_python_callback) {
    fprintf(stderr, "librdf_call_python_message: No message callback registered\n");
    return;
  }

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_python_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    if(type == 0) {
#ifdef PYTHON_EXCEPTIONS_WORKING
      PyObject *error = PyErr_NewException("Redland.error", NULL, NULL);
      /* error */
      PyErr_SetString(error, buffer);
#else
      PyErr_Warn(NULL, buffer);
#endif
    } else {
      /* warning */
       PyErr_Warn(NULL, buffer);
    }

#ifdef PYTHON_EXCEPTIONS_WORKING
    /* call the callback */
    arglist = Py_BuildValue("(is)", type, buffer);
    if(!arglist) {
      fprintf(stderr, "librdf_call_python_message: Out of memory\n");
      free(buffer);
      return;
    }
    result = PyEval_CallObject(librdf_python_callback, arglist);
    Py_DECREF(arglist);
    if (result == NULL) {
      free(buffer);
      return;
    }
    
    /* no result */
    Py_DECREF(result);
#endif
    free(buffer);
  }
}

static void
librdf_python_error_handler(void *user_data, 
                            const char *message, va_list arguments)
{
  librdf_call_python_message(0, message, arguments);
}


static void
librdf_python_warning_handler(void *user_data,
                              const char *message, va_list arguments)
{
  librdf_call_python_message(1, message, arguments);
}

void
librdf_python_world_init(librdf_world *world)
{
  (void) Py_InitModule("Redland_python", librdf_python_methods);
  librdf_world_set_error(world, NULL, librdf_python_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_python_warning_handler);
}
 

#endif

#ifdef SWIGPERL
/*
 * calls a perl subroutine defined as:
 *   RDF::Redland::World::message($$)
 * where first argument is an integer, second is a (scalar) string
 */
static void
librdf_call_perl_message(int type, const char *message, va_list arguments)
{
  char empty_buffer[1];
  dSP;
  char *buffer;
  int len;
  va_list args_copy;
  
  ENTER;
  SAVETMPS;

  /* ask vsnprintf size of buffer required */
  va_copy(args_copy, arguments);
  len=vsnprintf(empty_buffer, 1, message, args_copy)+1;
  va_end(args_copy);
  buffer=(char*)malloc(len);
  if(!buffer)
    fprintf(stderr, "librdf_call_perl_message: Out of memory\n");
  else {
    va_copy(args_copy, arguments);
    vsnprintf(buffer, len, message, args_copy);
    va_end(args_copy);

    PUSHMARK(SP) ;
    XPUSHs(sv_2mortal(newSViv(type)));
    XPUSHs(sv_2mortal(newSVpv(buffer, 0)));
    PUTBACK;
  
    call_pv("RDF::Redland::World::message", G_DISCARD);

    free(buffer);
  }
  
  FREETMPS;
  LEAVE;
}

static void
librdf_perl_error_handler(void *user_data, 
                          const char *message, va_list arguments)
{
  librdf_call_perl_message(0, message, arguments);
}


static void
librdf_perl_warning_handler(void *user_data,
                            const char *message, va_list arguments)
{
  librdf_call_perl_message(1, message, arguments);
}

static librdf_world* librdf_perl_world=NULL;

void
librdf_perl_world_init(librdf_world *world)
{
  librdf_world_set_error(world, NULL, librdf_perl_error_handler);
  librdf_world_set_warning(world,  NULL, librdf_perl_warning_handler);

  librdf_perl_world=world;
}

void
librdf_perl_world_finish(void)
{
  librdf_free_world(librdf_perl_world);
}
#endif


/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_error(world, "test error message number %d.", 1);
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_warning(world, "test warning message number %d.", 2);
}


extern char const *const librdf_short_copyright_string;
extern char const *const librdf_copyright_string;
extern char const *const librdf_version_string;
extern unsigned int const librdf_version_major;
extern unsigned int const librdf_version_minor;
extern unsigned int const librdf_version_release;
extern unsigned int const librdf_version_decimal;
/* class entry subsection */


/* entry subsection */
/* Every non-class user visible function must have an entry here */
function_entry redland_functions[] = {
	ZEND_NAMED_FE(librdf_new_world,
		_wrap_librdf_new_world, NULL)
	ZEND_NAMED_FE(librdf_free_world,
		_wrap_librdf_free_world, NULL)
	ZEND_NAMED_FE(librdf_world_open,
		_wrap_librdf_world_open, NULL)
	ZEND_NAMED_FE(librdf_init_world,
		_wrap_librdf_init_world, NULL)
	ZEND_NAMED_FE(librdf_destroy_world,
		_wrap_librdf_destroy_world, NULL)
	ZEND_NAMED_FE(librdf_free_iterator,
		_wrap_librdf_free_iterator, NULL)
	ZEND_NAMED_FE(librdf_iterator_have_elements,
		_wrap_librdf_iterator_have_elements, NULL)
	ZEND_NAMED_FE(librdf_iterator_end,
		_wrap_librdf_iterator_end, NULL)
	ZEND_NAMED_FE(librdf_iterator_get_object,
		_wrap_librdf_iterator_get_object, NULL)
	ZEND_NAMED_FE(librdf_iterator_get_context,
		_wrap_librdf_iterator_get_context, NULL)
	ZEND_NAMED_FE(librdf_iterator_next,
		_wrap_librdf_iterator_next, NULL)
	ZEND_NAMED_FE(librdf_new_uri,
		_wrap_librdf_new_uri, NULL)
	ZEND_NAMED_FE(librdf_new_uri_from_uri,
		_wrap_librdf_new_uri_from_uri, NULL)
	ZEND_NAMED_FE(librdf_new_uri_from_filename,
		_wrap_librdf_new_uri_from_filename, NULL)
	ZEND_NAMED_FE(librdf_free_uri,
		_wrap_librdf_free_uri, NULL)
	ZEND_NAMED_FE(librdf_uri_to_string,
		_wrap_librdf_uri_to_string, NULL)
	ZEND_NAMED_FE(librdf_uri_equals,
		_wrap_librdf_uri_equals, NULL)
	ZEND_NAMED_FE(librdf_new_node,
		_wrap_librdf_new_node, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_uri_string,
		_wrap_librdf_new_node_from_uri_string, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_uri,
		_wrap_librdf_new_node_from_uri, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_literal,
		_wrap_librdf_new_node_from_literal, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_typed_literal,
		_wrap_librdf_new_node_from_typed_literal, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_node,
		_wrap_librdf_new_node_from_node, NULL)
	ZEND_NAMED_FE(librdf_new_node_from_blank_identifier,
		_wrap_librdf_new_node_from_blank_identifier, NULL)
	ZEND_NAMED_FE(librdf_free_node,
		_wrap_librdf_free_node, NULL)
	ZEND_NAMED_FE(librdf_node_get_uri,
		_wrap_librdf_node_get_uri, NULL)
	ZEND_NAMED_FE(librdf_node_get_type,
		_wrap_librdf_node_get_type, NULL)
	ZEND_NAMED_FE(librdf_node_get_literal_value,
		_wrap_librdf_node_get_literal_value, NULL)
	ZEND_NAMED_FE(librdf_node_get_literal_value_as_latin1,
		_wrap_librdf_node_get_literal_value_as_latin1, NULL)
	ZEND_NAMED_FE(librdf_node_get_literal_value_language,
		_wrap_librdf_node_get_literal_value_language, NULL)
	ZEND_NAMED_FE(librdf_node_get_literal_value_datatype_uri,
		_wrap_librdf_node_get_literal_value_datatype_uri, NULL)
	ZEND_NAMED_FE(librdf_node_get_literal_value_is_wf_xml,
		_wrap_librdf_node_get_literal_value_is_wf_xml, NULL)
	ZEND_NAMED_FE(librdf_node_to_string,
		_wrap_librdf_node_to_string, NULL)
	ZEND_NAMED_FE(librdf_node_get_blank_identifier,
		_wrap_librdf_node_get_blank_identifier, NULL)
	ZEND_NAMED_FE(librdf_node_is_resource,
		_wrap_librdf_node_is_resource, NULL)
	ZEND_NAMED_FE(librdf_node_is_literal,
		_wrap_librdf_node_is_literal, NULL)
	ZEND_NAMED_FE(librdf_node_is_blank,
		_wrap_librdf_node_is_blank, NULL)
	ZEND_NAMED_FE(librdf_node_equals,
		_wrap_librdf_node_equals, NULL)
	ZEND_NAMED_FE(librdf_new_statement,
		_wrap_librdf_new_statement, NULL)
	ZEND_NAMED_FE(librdf_new_statement_from_statement,
		_wrap_librdf_new_statement_from_statement, NULL)
	ZEND_NAMED_FE(librdf_new_statement_from_nodes,
		_wrap_librdf_new_statement_from_nodes, NULL)
	ZEND_NAMED_FE(librdf_free_statement,
		_wrap_librdf_free_statement, NULL)
	ZEND_NAMED_FE(librdf_statement_get_subject,
		_wrap_librdf_statement_get_subject, NULL)
	ZEND_NAMED_FE(librdf_statement_set_subject,
		_wrap_librdf_statement_set_subject, NULL)
	ZEND_NAMED_FE(librdf_statement_get_predicate,
		_wrap_librdf_statement_get_predicate, NULL)
	ZEND_NAMED_FE(librdf_statement_set_predicate,
		_wrap_librdf_statement_set_predicate, NULL)
	ZEND_NAMED_FE(librdf_statement_get_object,
		_wrap_librdf_statement_get_object, NULL)
	ZEND_NAMED_FE(librdf_statement_set_object,
		_wrap_librdf_statement_set_object, NULL)
	ZEND_NAMED_FE(librdf_statement_to_string,
		_wrap_librdf_statement_to_string, NULL)
	ZEND_NAMED_FE(librdf_new_model,
		_wrap_librdf_new_model, NULL)
	ZEND_NAMED_FE(librdf_new_model_with_options,
		_wrap_librdf_new_model_with_options, NULL)
	ZEND_NAMED_FE(librdf_new_model_from_model,
		_wrap_librdf_new_model_from_model, NULL)
	ZEND_NAMED_FE(librdf_free_model,
		_wrap_librdf_free_model, NULL)
	ZEND_NAMED_FE(librdf_model_size,
		_wrap_librdf_model_size, NULL)
	ZEND_NAMED_FE(librdf_model_add,
		_wrap_librdf_model_add, NULL)
	ZEND_NAMED_FE(librdf_model_add_typed_literal_statement,
		_wrap_librdf_model_add_typed_literal_statement, NULL)
	ZEND_NAMED_FE(librdf_model_add_statement,
		_wrap_librdf_model_add_statement, NULL)
	ZEND_NAMED_FE(librdf_model_add_statements,
		_wrap_librdf_model_add_statements, NULL)
	ZEND_NAMED_FE(librdf_model_remove_statement,
		_wrap_librdf_model_remove_statement, NULL)
	ZEND_NAMED_FE(librdf_model_contains_statement,
		_wrap_librdf_model_contains_statement, NULL)
	ZEND_NAMED_FE(librdf_model_as_stream,
		_wrap_librdf_model_as_stream, NULL)
	ZEND_NAMED_FE(librdf_model_serialise,
		_wrap_librdf_model_serialise, NULL)
	ZEND_NAMED_FE(librdf_model_find_statements,
		_wrap_librdf_model_find_statements, NULL)
	ZEND_NAMED_FE(librdf_model_get_sources,
		_wrap_librdf_model_get_sources, NULL)
	ZEND_NAMED_FE(librdf_model_get_arcs,
		_wrap_librdf_model_get_arcs, NULL)
	ZEND_NAMED_FE(librdf_model_get_targets,
		_wrap_librdf_model_get_targets, NULL)
	ZEND_NAMED_FE(librdf_model_get_source,
		_wrap_librdf_model_get_source, NULL)
	ZEND_NAMED_FE(librdf_model_get_arc,
		_wrap_librdf_model_get_arc, NULL)
	ZEND_NAMED_FE(librdf_model_get_target,
		_wrap_librdf_model_get_target, NULL)
	ZEND_NAMED_FE(librdf_model_context_add_statement,
		_wrap_librdf_model_context_add_statement, NULL)
	ZEND_NAMED_FE(librdf_model_context_add_statements,
		_wrap_librdf_model_context_add_statements, NULL)
	ZEND_NAMED_FE(librdf_model_context_remove_statement,
		_wrap_librdf_model_context_remove_statement, NULL)
	ZEND_NAMED_FE(librdf_model_context_remove_statements,
		_wrap_librdf_model_context_remove_statements, NULL)
	ZEND_NAMED_FE(librdf_model_context_as_stream,
		_wrap_librdf_model_context_as_stream, NULL)
	ZEND_NAMED_FE(librdf_model_context_serialize,
		_wrap_librdf_model_context_serialize, NULL)
	ZEND_NAMED_FE(librdf_model_sync,
		_wrap_librdf_model_sync, NULL)
	ZEND_NAMED_FE(librdf_new_storage,
		_wrap_librdf_new_storage, NULL)
	ZEND_NAMED_FE(librdf_new_storage_from_storage,
		_wrap_librdf_new_storage_from_storage, NULL)
	ZEND_NAMED_FE(librdf_free_storage,
		_wrap_librdf_free_storage, NULL)
	ZEND_NAMED_FE(librdf_new_parser,
		_wrap_librdf_new_parser, NULL)
	ZEND_NAMED_FE(librdf_free_parser,
		_wrap_librdf_free_parser, NULL)
	ZEND_NAMED_FE(librdf_parser_parse_as_stream,
		_wrap_librdf_parser_parse_as_stream, NULL)
	ZEND_NAMED_FE(librdf_parser_parse_into_model,
		_wrap_librdf_parser_parse_into_model, NULL)
	ZEND_NAMED_FE(librdf_parser_parse_string_as_stream,
		_wrap_librdf_parser_parse_string_as_stream, NULL)
	ZEND_NAMED_FE(librdf_parser_parse_string_into_model,
		_wrap_librdf_parser_parse_string_into_model, NULL)
	ZEND_NAMED_FE(librdf_parser_get_feature,
		_wrap_librdf_parser_get_feature, NULL)
	ZEND_NAMED_FE(librdf_parser_set_feature,
		_wrap_librdf_parser_set_feature, NULL)
	ZEND_NAMED_FE(librdf_new_serializer,
		_wrap_librdf_new_serializer, NULL)
	ZEND_NAMED_FE(librdf_free_serializer,
		_wrap_librdf_free_serializer, NULL)
	ZEND_NAMED_FE(librdf_serializer_serialize_model_to_file,
		_wrap_librdf_serializer_serialize_model_to_file, NULL)
	ZEND_NAMED_FE(librdf_serializer_get_feature,
		_wrap_librdf_serializer_get_feature, NULL)
	ZEND_NAMED_FE(librdf_serializer_set_feature,
		_wrap_librdf_serializer_set_feature, NULL)
	ZEND_NAMED_FE(librdf_free_stream,
		_wrap_librdf_free_stream, NULL)
	ZEND_NAMED_FE(librdf_stream_end,
		_wrap_librdf_stream_end, NULL)
	ZEND_NAMED_FE(librdf_stream_next,
		_wrap_librdf_stream_next, NULL)
	ZEND_NAMED_FE(librdf_stream_get_object,
		_wrap_librdf_stream_get_object, NULL)
	ZEND_NAMED_FE(librdf_stream_get_context,
		_wrap_librdf_stream_get_context, NULL)
	ZEND_NAMED_FE(librdf_internal_test_error,
		_wrap_librdf_internal_test_error, NULL)
	ZEND_NAMED_FE(librdf_internal_test_warning,
		_wrap_librdf_internal_test_warning, NULL)
	ZEND_NAMED_FE(librdf_short_copyright_string_get,
		_wrap_librdf_short_copyright_string_get, NULL)
	ZEND_NAMED_FE(librdf_copyright_string_get,
		_wrap_librdf_copyright_string_get, NULL)
	ZEND_NAMED_FE(librdf_version_string_get,
		_wrap_librdf_version_string_get, NULL)
	ZEND_NAMED_FE(librdf_version_major_get,
		_wrap_librdf_version_major_get, NULL)
	ZEND_NAMED_FE(librdf_version_minor_get,
		_wrap_librdf_version_minor_get, NULL)
	ZEND_NAMED_FE(librdf_version_release_get,
		_wrap_librdf_version_release_get, NULL)
	ZEND_NAMED_FE(librdf_version_decimal_get,
		_wrap_librdf_version_decimal_get, NULL)
	{NULL, NULL, NULL}
};

zend_module_entry redland_module_entry = {
#if ZEND_MODULE_API_NO > 20010900
    STANDARD_MODULE_HEADER,
#endif
    "redland",
    redland_functions,
    PHP_MINIT(redland),
    PHP_MSHUTDOWN(redland),
    PHP_RINIT(redland),
    PHP_RSHUTDOWN(redland),
    PHP_MINFO(redland),
#if ZEND_MODULE_API_NO > 20010900
    NO_VERSION_YET,
#endif
    STANDARD_MODULE_PROPERTIES
};
zend_module_entry* SWIG_module_entry = &redland_module_entry;


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_librdf_node[] = {{"_p_librdf_node", 0, "librdf_node *", 0},{"_p_librdf_node"},{0}};
static swig_type_info _swigt__p_librdf_parser[] = {{"_p_librdf_parser", 0, "librdf_parser *", 0},{"_p_librdf_parser"},{0}};
static swig_type_info _swigt__p_librdf_world[] = {{"_p_librdf_world", 0, "librdf_world *", 0},{"_p_librdf_world"},{0}};
static swig_type_info _swigt__p_librdf_hash[] = {{"_p_librdf_hash", 0, "librdf_hash *", 0},{"_p_librdf_hash"},{0}};
static swig_type_info _swigt__p_librdf_statement[] = {{"_p_librdf_statement", 0, "librdf_statement *", 0},{"_p_librdf_statement"},{0}};
static swig_type_info _swigt__p_librdf_iterator[] = {{"_p_librdf_iterator", 0, "librdf_iterator *", 0},{"_p_librdf_iterator"},{0}};
static swig_type_info _swigt__p_librdf_storage[] = {{"_p_librdf_storage", 0, "librdf_storage *", 0},{"_p_librdf_storage"},{0}};
static swig_type_info _swigt__p_librdf_uri[] = {{"_p_librdf_uri", 0, "librdf_uri *", 0},{"_p_librdf_uri"},{0}};
static swig_type_info _swigt__p_librdf_model[] = {{"_p_librdf_model", 0, "librdf_model *", 0},{"_p_librdf_model"},{0}};
static swig_type_info _swigt__p_librdf_stream[] = {{"_p_librdf_stream", 0, "librdf_stream *", 0},{"_p_librdf_stream"},{0}};
static swig_type_info _swigt__p_librdf_serializer[] = {{"_p_librdf_serializer", 0, "librdf_serializer *", 0},{"_p_librdf_serializer"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_librdf_node, 
_swigt__p_librdf_parser, 
_swigt__p_librdf_world, 
_swigt__p_librdf_hash, 
_swigt__p_librdf_statement, 
_swigt__p_librdf_iterator, 
_swigt__p_librdf_storage, 
_swigt__p_librdf_uri, 
_swigt__p_librdf_model, 
_swigt__p_librdf_stream, 
_swigt__p_librdf_serializer, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/* vdecl subsection */
static int le_swig__p_librdf_node=0; /* handle for  */
static int le_swig__p_librdf_parser=0; /* handle for  */
static int le_swig__p_librdf_world=0; /* handle for  */
static int le_swig__p_librdf_hash=0; /* handle for  */
static int le_swig__p_librdf_statement=0; /* handle for  */
static int le_swig__p_librdf_iterator=0; /* handle for  */
static int le_swig__p_librdf_storage=0; /* handle for  */
static int le_swig__p_librdf_uri=0; /* handle for  */
static int le_swig__p_librdf_model=0; /* handle for  */
static int le_swig__p_librdf_stream=0; /* handle for  */
static int le_swig__p_librdf_serializer=0; /* handle for  */
/* end vdecl subsection */
/* wrapper section */
ZEND_NAMED_FUNCTION(_wrap_librdf_new_world) {
    librdf_world *result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (librdf_world *)librdf_new_world();
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_world, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_world) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_world. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    librdf_free_world(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_world_open) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_world_open. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    librdf_world_open(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_init_world) {
    char *arg1 ;
    librdf_hash *arg2 = (librdf_hash *) 0 ;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    convert_to_string_ex(((0<argbase)?(&this_ptr):(args[0-argbase])));
    arg1 = (char *) Z_STRVAL_PP(((0<argbase)?(&this_ptr):(args[0-argbase])));
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_hash) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_init_world. Expected %s", 2-argbase, SWIGTYPE_p_librdf_hash->name);
    }
    
    librdf_init_world(arg1,arg2);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_destroy_world) {
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    librdf_destroy_world();
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_iterator) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_iterator. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    librdf_free_iterator(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_iterator_have_elements) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_iterator_have_elements. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    result = (int)librdf_iterator_have_elements(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_iterator_end) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_iterator_end. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    result = (int)librdf_iterator_end(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_iterator_get_object) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_iterator_get_object. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    result = (librdf_node *)librdf_iterator_get_object(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_iterator_get_context) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_iterator_get_context. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    result = (librdf_node *)librdf_iterator_get_context(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_iterator_next) {
    librdf_iterator *arg1 = (librdf_iterator *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_iterator) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_iterator_next. Expected %s", 1-argbase, SWIGTYPE_p_librdf_iterator->name);
    }
    
    result = (int)librdf_iterator_next(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_uri) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    result = (librdf_uri *)librdf_new_uri(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_uri, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_uri_from_uri) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_uri_from_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_uri, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_uri_from_filename) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_uri *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_uri_from_filename. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_uri, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_uri) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    librdf_free_uri(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_uri_to_string) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_uri_to_string. Expected %s", 1-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (char *)librdf_uri_to_string(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_uri_equals) {
    librdf_uri *arg1 = (librdf_uri *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_uri_equals. Expected %s", 1-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_uri_equals. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (int)librdf_uri_equals(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    result = (librdf_node *)librdf_new_node(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_uri_string) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_uri_string. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    result = (librdf_node *)librdf_new_node_from_uri_string(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_uri) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_node *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_uri. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_literal) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    int arg4 ;
    librdf_node *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_literal. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    
    convert_to_long_ex(args[3-argbase]);
    arg4 = (int) Z_LVAL_PP(args[3-argbase]);
    
    result = (librdf_node *)librdf_new_node_from_literal(arg1,arg2,arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_typed_literal) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_node *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_typed_literal. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_typed_literal. Expected %s", 4-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_node) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_node. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_node *)librdf_new_node_from_node(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_node_from_blank_identifier) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    librdf_node *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_node_from_blank_identifier. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_node) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_node. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    librdf_free_node(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_uri) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_uri *)librdf_node_get_uri(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_uri, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_type) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_type. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_get_type(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_literal_value) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_literal_value. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (char *)librdf_node_get_literal_value(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_literal_value_as_latin1) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_literal_value_as_latin1. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_literal_value_language) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_literal_value_language. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (char *)librdf_node_get_literal_value_language(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_literal_value_datatype_uri) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_uri *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_literal_value_datatype_uri. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_uri, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_literal_value_is_wf_xml) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_literal_value_is_wf_xml. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_to_string) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_to_string. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (char *)librdf_node_to_string(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_get_blank_identifier) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_get_blank_identifier. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (char *)librdf_node_get_blank_identifier(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_is_resource) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_is_resource. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_is_resource(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_is_literal) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_is_literal. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_is_literal(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_is_blank) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_is_blank. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_is_blank(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_node_equals) {
    librdf_node *arg1 = (librdf_node *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_equals. Expected %s", 1-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_node_equals. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_node_equals(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_statement) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_statement *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    result = (librdf_statement *)librdf_new_statement(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_statement, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_statement_from_statement) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_statement *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement_from_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_statement, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_statement_from_nodes) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    librdf_statement *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement_from_nodes. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement_from_nodes. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement_from_nodes. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_statement_from_nodes. Expected %s", 4-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_statement, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_statement) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    librdf_free_statement(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_get_subject) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_get_subject. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (librdf_node *)librdf_statement_get_subject(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_set_subject) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_subject. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_subject. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    librdf_statement_set_subject(arg1,arg2);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_get_predicate) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_get_predicate. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (librdf_node *)librdf_statement_get_predicate(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_set_predicate) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_predicate. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_predicate. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    librdf_statement_set_predicate(arg1,arg2);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_get_object) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_get_object. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (librdf_node *)librdf_statement_get_object(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_set_object) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_object. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_set_object. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    librdf_statement_set_object(arg1,arg2);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_statement_to_string) {
    librdf_statement *arg1 = (librdf_statement *) 0 ;
    char *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_statement_to_string. Expected %s", 1-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (char *)librdf_statement_to_string(arg1);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_model) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    char *arg3 ;
    librdf_model *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_storage) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model. Expected %s", 2-argbase, SWIGTYPE_p_librdf_storage->name);
    }
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_model, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_model_with_options) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    librdf_storage *arg2 = (librdf_storage *) 0 ;
    librdf_hash *arg3 = (librdf_hash *) 0 ;
    librdf_model *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model_with_options. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_storage) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model_with_options. Expected %s", 2-argbase, SWIGTYPE_p_librdf_storage->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_hash) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model_with_options. Expected %s", 3-argbase, SWIGTYPE_p_librdf_hash->name);
    }
    
    result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_model, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_model_from_model) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_model *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_model_from_model. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (librdf_model *)librdf_new_model_from_model(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_model, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_model) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_model. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    librdf_free_model(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_size) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_size. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (int)librdf_model_size(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_add) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *arg4 = (librdf_node *) 0 ;
    int result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add. Expected %s", 4-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_add_typed_literal_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    char *arg4 ;
    char *arg5 ;
    librdf_uri *arg6 = (librdf_uri *) 0 ;
    int result;
    zval **args[7];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 6) || (zend_get_parameters_array_ex(6-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_typed_literal_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_typed_literal_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_typed_literal_statement. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    convert_to_string_ex(args[3-argbase]);
    arg4 = (char *) Z_STRVAL_PP(args[3-argbase]);
    
    
    convert_to_string_ex(args[4-argbase]);
    arg5 = (char *) Z_STRVAL_PP(args[4-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[5-argbase], (void **) &arg6, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_typed_literal_statement. Expected %s", 6-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_add_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (int)librdf_model_add_statement(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_add_statements) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *arg2 = (librdf_stream *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_statements. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_add_statements. Expected %s", 2-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (int)librdf_model_add_statements(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_remove_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_remove_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_remove_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (int)librdf_model_remove_statement(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_contains_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_contains_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_contains_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (int)librdf_model_contains_statement(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_as_stream) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_as_stream. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (librdf_stream *)librdf_model_as_stream(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_serialise) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_stream *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_serialise. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (librdf_stream *)librdf_model_serialise(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_find_statements) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_statement *arg2 = (librdf_statement *) 0 ;
    librdf_stream *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_find_statements. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_find_statements. Expected %s", 2-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_sources) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_sources. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_sources. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_sources. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_iterator, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_arcs) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arcs. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arcs. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arcs. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_iterator, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_targets) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_iterator *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_targets. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_targets. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_targets. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_iterator, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_source) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_source. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_source. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_source. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_arc) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arc. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arc. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_arc. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_get_target) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_node *arg3 = (librdf_node *) 0 ;
    librdf_node *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_target. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_target. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_get_target. Expected %s", 3-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_add_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statement. Expected %s", 3-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_add_statements) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *arg3 = (librdf_stream *) 0 ;
    int result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statements. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statements. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_add_statements. Expected %s", 3-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_remove_statement) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_statement *arg3 = (librdf_statement *) 0 ;
    int result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_remove_statement. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_remove_statement. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_statement) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_remove_statement. Expected %s", 3-argbase, SWIGTYPE_p_librdf_statement->name);
    }
    
    result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_remove_statements) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    int result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_remove_statements. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_remove_statements. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (int)librdf_model_context_remove_statements(arg1,arg2);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_as_stream) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_as_stream. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_as_stream. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_context_serialize) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    librdf_node *arg2 = (librdf_node *) 0 ;
    librdf_stream *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_serialize. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_node) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_context_serialize. Expected %s", 2-argbase, SWIGTYPE_p_librdf_node->name);
    }
    
    result = (librdf_stream *)librdf_model_context_serialize(arg1,arg2);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_model_sync) {
    librdf_model *arg1 = (librdf_model *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_model_sync. Expected %s", 1-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    librdf_model_sync(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_storage) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 ;
    librdf_storage *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_storage. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    
    convert_to_string_ex(args[3-argbase]);
    arg4 = (char *) Z_STRVAL_PP(args[3-argbase]);
    
    result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_storage, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_storage_from_storage) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    librdf_storage *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_storage) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_storage_from_storage. Expected %s", 1-argbase, SWIGTYPE_p_librdf_storage->name);
    }
    
    result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_storage, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_storage) {
    librdf_storage *arg1 = (librdf_storage *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_storage) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_storage. Expected %s", 1-argbase, SWIGTYPE_p_librdf_storage->name);
    }
    
    librdf_free_storage(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_parser) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_parser *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_parser. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_parser. Expected %s", 4-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_parser, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_parser) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_parser. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    librdf_free_parser(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_parse_as_stream) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_as_stream. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_as_stream. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_as_stream. Expected %s", 3-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_parse_into_model) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_into_model. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_into_model. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_into_model. Expected %s", 3-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_into_model. Expected %s", 4-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_parse_string_as_stream) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_stream *result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_string_as_stream. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_string_as_stream. Expected %s", 3-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_stream, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_parse_string_into_model) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_string_into_model. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_string_into_model. Expected %s", 3-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_parse_string_into_model. Expected %s", 4-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_get_feature) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_get_feature. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_get_feature. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (char *)librdf_parser_get_feature(arg1,arg2);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_parser_set_feature) {
    librdf_parser *arg1 = (librdf_parser *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_parser) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_set_feature. Expected %s", 1-argbase, SWIGTYPE_p_librdf_parser->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_parser_set_feature. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    result = (int)librdf_parser_set_feature(arg1,arg2,(char const *)arg3);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_new_serializer) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    char *arg2 ;
    char *arg3 ;
    librdf_uri *arg4 = (librdf_uri *) 0 ;
    librdf_serializer *result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_serializer. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_new_serializer. Expected %s", 4-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_serializer, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_serializer) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_serializer) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_serializer. Expected %s", 1-argbase, SWIGTYPE_p_librdf_serializer->name);
    }
    
    librdf_free_serializer(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_serializer_serialize_model_to_file) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    char *arg2 ;
    librdf_uri *arg3 = (librdf_uri *) 0 ;
    librdf_model *arg4 = (librdf_model *) 0 ;
    int result;
    zval **args[5];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 4) || (zend_get_parameters_array_ex(4-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_serializer) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_serialize_model_to_file. Expected %s", 1-argbase, SWIGTYPE_p_librdf_serializer->name);
    }
    
    
    convert_to_string_ex(args[1-argbase]);
    arg2 = (char *) Z_STRVAL_PP(args[1-argbase]);
    
    
    if(SWIG_ConvertPtr(*args[2-argbase], (void **) &arg3, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_serialize_model_to_file. Expected %s", 3-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[3-argbase], (void **) &arg4, SWIGTYPE_p_librdf_model) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_serialize_model_to_file. Expected %s", 4-argbase, SWIGTYPE_p_librdf_model->name);
    }
    
    result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_serializer_get_feature) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *result;
    zval **args[3];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 2) || (zend_get_parameters_array_ex(2-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_serializer) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_get_feature. Expected %s", 1-argbase, SWIGTYPE_p_librdf_serializer->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_get_feature. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    result = (char *)librdf_serializer_get_feature(arg1,arg2);
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_serializer_set_feature) {
    librdf_serializer *arg1 = (librdf_serializer *) 0 ;
    librdf_uri *arg2 = (librdf_uri *) 0 ;
    char *arg3 ;
    int result;
    zval **args[4];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 3) || (zend_get_parameters_array_ex(3-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_serializer) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_set_feature. Expected %s", 1-argbase, SWIGTYPE_p_librdf_serializer->name);
    }
    
    
    if(SWIG_ConvertPtr(*args[1-argbase], (void **) &arg2, SWIGTYPE_p_librdf_uri) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_serializer_set_feature. Expected %s", 2-argbase, SWIGTYPE_p_librdf_uri->name);
    }
    
    
    convert_to_string_ex(args[2-argbase]);
    arg3 = (char *) Z_STRVAL_PP(args[2-argbase]);
    
    result = (int)librdf_serializer_set_feature(arg1,arg2,(char const *)arg3);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_free_stream) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_free_stream. Expected %s", 1-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    librdf_free_stream(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_stream_end) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_stream_end. Expected %s", 1-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (int)librdf_stream_end(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_stream_next) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    int result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_stream_next. Expected %s", 1-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (int)librdf_stream_next(arg1);
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_stream_get_object) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_statement *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_stream_get_object. Expected %s", 1-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (librdf_statement *)librdf_stream_get_object(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_statement, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_stream_get_context) {
    librdf_stream *arg1 = (librdf_stream *) 0 ;
    librdf_node *result;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_stream) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_stream_get_context. Expected %s", 1-argbase, SWIGTYPE_p_librdf_stream->name);
    }
    
    result = (librdf_node *)librdf_stream_get_context(arg1);
    
    
    SWIG_SetPointerZval(return_value, (void *)result, SWIGTYPE_p_librdf_node, 0);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_internal_test_error) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_internal_test_error. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    librdf_internal_test_error(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_internal_test_warning) {
    librdf_world *arg1 = (librdf_world *) 0 ;
    zval **args[2];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 1) || (zend_get_parameters_array_ex(1-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    
    if(SWIG_ConvertPtr(*((0<argbase)?(&this_ptr):(args[0-argbase])), (void **) &arg1, SWIGTYPE_p_librdf_world) < 0) {
        zend_error(E_ERROR, "Type error in argument %d of librdf_internal_test_warning. Expected %s", 1-argbase, SWIGTYPE_p_librdf_world->name);
    }
    
    librdf_internal_test_warning(arg1);
    
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_short_copyright_string_get) {
    char *result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (char *)(char *)librdf_short_copyright_string;
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_copyright_string_get) {
    char *result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (char *)(char *)librdf_copyright_string;
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_version_string_get) {
    char *result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (char *)(char *)librdf_version_string;
    
    
    ZVAL_STRING(return_value,result, 1);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_version_major_get) {
    unsigned int result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (unsigned int)(unsigned int)librdf_version_major;
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_version_minor_get) {
    unsigned int result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (unsigned int)(unsigned int)librdf_version_minor;
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_version_release_get) {
    unsigned int result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (unsigned int)(unsigned int)librdf_version_release;
    
    
    ZVAL_LONG(return_value,result);
    
}


ZEND_NAMED_FUNCTION(_wrap_librdf_version_decimal_get) {
    unsigned int result;
    zval **args[1];
    int argbase=0 ;
    
    if (this_ptr && this_ptr->type==IS_OBJECT) {
        /* fake this_ptr as first arg (till we can work out how to do it better */
        argbase++;
    }
    if(((ZEND_NUM_ARGS() + argbase )!= 0) || (zend_get_parameters_array_ex(0-argbase, args)!= SUCCESS)) {
        WRONG_PARAM_COUNT;
    }
    
    result = (unsigned int)(unsigned int)librdf_version_decimal;
    
    
    ZVAL_LONG(return_value,result);
    
}


/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_node) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_parser) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_world) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_hash) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_statement) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_iterator) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_storage) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_uri) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_model) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_stream) {
/* bah! No destructor for this simple type!! */
}
/* NEW Destructor style */
static ZEND_RSRC_DTOR_FUNC(_wrap_destroy_p_librdf_serializer) {
/* bah! No destructor for this simple type!! */
}




/* end wrapper section */
/* init section */
#ifdef __cplusplus
extern "C" {
#endif
ZEND_GET_MODULE(redland)
#ifdef __cplusplus
}
#endif

PHP_MSHUTDOWN_FUNCTION(redland)
{
    return SUCCESS;
}
PHP_MINIT_FUNCTION(redland)
{
    int i;
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
    }

#ifdef TCL_MAJOR_VERSION
Tcl_PkgProvide(interp, PACKAGE, (char*)librdf_version_string);
#endif

/* oinit subsection */

/* Register resource destructors for pointer types */
le_swig__p_librdf_node=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_node,NULL,(char *)(SWIGTYPE_p_librdf_node->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_node,&le_swig__p_librdf_node);
le_swig__p_librdf_parser=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_parser,NULL,(char *)(SWIGTYPE_p_librdf_parser->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_parser,&le_swig__p_librdf_parser);
le_swig__p_librdf_world=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_world,NULL,(char *)(SWIGTYPE_p_librdf_world->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_world,&le_swig__p_librdf_world);
le_swig__p_librdf_hash=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_hash,NULL,(char *)(SWIGTYPE_p_librdf_hash->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_hash,&le_swig__p_librdf_hash);
le_swig__p_librdf_statement=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_statement,NULL,(char *)(SWIGTYPE_p_librdf_statement->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_statement,&le_swig__p_librdf_statement);
le_swig__p_librdf_iterator=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_iterator,NULL,(char *)(SWIGTYPE_p_librdf_iterator->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_iterator,&le_swig__p_librdf_iterator);
le_swig__p_librdf_storage=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_storage,NULL,(char *)(SWIGTYPE_p_librdf_storage->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_storage,&le_swig__p_librdf_storage);
le_swig__p_librdf_uri=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_uri,NULL,(char *)(SWIGTYPE_p_librdf_uri->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_uri,&le_swig__p_librdf_uri);
le_swig__p_librdf_model=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_model,NULL,(char *)(SWIGTYPE_p_librdf_model->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_model,&le_swig__p_librdf_model);
le_swig__p_librdf_stream=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_stream,NULL,(char *)(SWIGTYPE_p_librdf_stream->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_stream,&le_swig__p_librdf_stream);
le_swig__p_librdf_serializer=zend_register_list_destructors_ex(_wrap_destroy_p_librdf_serializer,NULL,(char *)(SWIGTYPE_p_librdf_serializer->name),module_number);
SWIG_TypeClientData(SWIGTYPE_p_librdf_serializer,&le_swig__p_librdf_serializer);
CG(active_class_entry) = NULL;
/* end oinit subsection */

    return SUCCESS;
}
PHP_RINIT_FUNCTION(redland)
{
/* cinit subsection */
/* end cinit subsection */

/* vinit subsection */
/* end vinit subsection */

    return SUCCESS;
}
PHP_RSHUTDOWN_FUNCTION(redland)
{
    return SUCCESS;
}
PHP_MINFO_FUNCTION(redland)
{
}
/* end init section */
