/***************************************************************************
 $RCSfile: aqmloader.cpp,v $
                             -------------------
    cvs         : $Id: aqmloader.cpp,v 1.3 2003/06/14 11:22:42 aquamaniac Exp $
    begin       : Tue Jul 16 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "aqmloader.h"


AQMLoader::AQMLoader(AQMAPI *hbci):HBCI::Loader(hbci), _api(hbci) {
}


AQMLoader::~AQMLoader(){
}



Error AQMLoader::readTransferFile(const string &name,
				  list<AQMTransaction> &xactions){
  SimpleConfig cfg;
  cfgPtr group;
  Error err;

  // read config file
  cfg.setMode(HBCIAPP_CONFIG_MODE);

  if (name.empty())
    err=cfg.readFile(File::StdTypeStdIn);
  else
    err=cfg.readFile(name);
  if (!err.isOk())
    return err;

  // load transactions from config
  group=cfg.root();
  group.child();
  while(group.isValid()) {
    if (-1!=parser::cmpPattern((*group).data,"transaction",false)) {
      AQMTransaction t;
      err=loadAQMTransaction(t,cfg,group);
      if (!err.isOk())
	return err;
      t.setTransactionCode(51);
      xactions.push_back(t);
    } // if transaction group
    if (-1!=parser::cmpPattern((*group).data,"debitnote",false)) {
      AQMTransaction t;
      err=loadAQMTransaction(t,cfg,group);
      if (!err.isOk())
	return err;
      t.setTransactionCode(05);
      xactions.push_back(t);
    } // if transaction group
    group++;
  } // while

  // done
  return err;
}


Error 
AQMLoader::writeTransferFile(const string &name,
			     const list<AQMTransaction> &xactions){
  SimpleConfig cfg;
  cfgPtr group;
  Error err;
  list<AQMTransaction>::const_iterator it;

  // create config
  cfg.setMode(HBCIAPP_CONFIG_MODE);

  for (it=xactions.begin();
       it!=xactions.end();
       it++) {
    if ((*it).transactionCode()==05)
      group=cfg.createGroup("debitnote",cfg.root());
    else
      group=cfg.createGroup("transaction",cfg.root());
    if (!group.isValid())
      return Error("Loader::writeTransactionFile()",
		   ERROR_LEVEL_INTERNAL,
		   0,
		   ERROR_ADVISE_ABORT,
		   "Could not create group",
		   "transaction");
    err=saveAQMTransaction(*it,cfg,group);
    if (!err.isOk())
      return err;
  }

  // then write file
  if (name.empty())
    err=cfg.writeFile(File::StdTypeStdOut);
  else
    err=cfg.writeFile(name);

  // done
  return err;
}



HBCI::Error AQMLoader::saveStatusReport(const HBCI::StatusReport &r,
					SimpleConfig &cfg,
					cfgPtr w){

  cfg.setIntVariable("result",r.result(),w);
  if (r.result()!=-1) {
    if (r.date().isValid())
      cfg.setVariable("date",r.date().toString(),w);
    cfg.setVariable("time",r.time().toString(),w);

    cfg.setVariable("groupref",r.groupReference(),w);
    cfg.setVariable("text", r.resultText(),w);
    cfg.setVariable("dialogid", r.messageReference().dialogId(), w);
    cfg.setIntVariable("msgnum", r.messageReference().messageNumber(),w);
    cfg.setIntVariable("segment", r.segment(),w);
  }

  return HBCI::Error();
}


HBCI::Error AQMLoader::loadStatusReport(HBCI::StatusReport &r,
					SimpleConfig &cfg,
					cfgPtr w){
  r.setResult(cfg.getIntVariable("result",-1,w));
  if (r.result()!=-1) {
    r.setDate(Date(cfg.getVariable("date", "", w)));
    r.setTime(Time(cfg.getVariable("time", "", w)));
    r.setGroupReference(cfg.getVariable("groupref", "", w));
    r.setResultText(cfg.getVariable("text","",w));
    r.setMessageReference(MessageReference(
					   cfg.getVariable("dialogid", "",w),
					   cfg.getIntVariable("msgnum",-1, w)
					  ));
    r.setSegment(cfg.getIntVariable("segment", -1, w));
  }

  return HBCI::Error();
}


HBCI::Error AQMLoader::saveAQMTransaction(const AQMTransaction &t,
					  SimpleConfig &cfg,
					  cfgPtr w){
  HBCI::Error err;
  cfgPtr group;

  err=saveTransaction(t, cfg, w);
  if (!err.isOk())
    return HBCI::Error("AQMLoader::saveAQMTransactionOut", err);

  // save additional data
  cfg.setVariable("customer",t.customerId(),w);
  cfg.setIntVariable("replyid", t.replyId(),w);

  group=cfg.createGroup("status", w);
  if (!group.isValid())
    return HBCI::Error("Loader::saveUpdJob()",
		       ERROR_LEVEL_INTERNAL,
		       0,
		       ERROR_ADVISE_ABORT,
		       "Could not create group",
		       "status");
  if (t.status().result()!=-1) {
    err=saveStatusReport(t.status(),
			 cfg,
			 group);
    if (!err.isOk())
      return HBCI::Error("AQMLoader::saveAQMTransactionOut", err);
  }

  return HBCI::Error();
}


HBCI::Error AQMLoader::loadAQMTransaction(AQMTransaction &t,
					  SimpleConfig &cfg,
					  cfgPtr w){
  HBCI::Error err;
  cfgPtr group;

  err=loadTransaction(t, cfg, w);
  if (!err.isOk())
      return HBCI::Error("AQMLoader::loadAQMTransactionOut", err);

  // read additional data
  t.setCustomerId(cfg.getVariable("customer","",w));
  t.setReplyId(cfg.getIntVariable("replyid",0,w));

  group=cfg.findGroup("status", w, false);
  if (group.isValid()) {
    HBCI::StatusReport r;

    err=loadStatusReport(r,
			 cfg,
			 group);
    if (!err.isOk())
      return HBCI::Error("AQMLoader::loadAQMTransactionOut", err);
    t.setStatus(r);
  }

  return HBCI::Error();
}


HBCI::Error AQMLoader::loadAQMTransfers(SimpleConfig &cfg,
					cfgPtr w){
  HBCI::Error err;
  cfgPtr group;
  cfgPtr group1;
  cfgPtr group2;

  group=cfg.findGroup("transfers",w,false);
  if (group.isValid()) {
    group1=group;
    group1.child();
    while(group1.isValid()) {
      AQMTransaction xa;

      group2=group1;
      group2.child();
      if (group2.isValid()) {
	err=loadAQMTransaction(xa, cfg, group2);
	if (!err.isOk())
	  return err;
	// add transfer to list
	_api->addTransfer(xa);
      }
      group1++;
    } // while there are transfers
  } // if group exists

  return HBCI::Error();
}


HBCI::Error AQMLoader::saveAQMTransfers(SimpleConfig &cfg,
					cfgPtr w){
  list<AQMTransaction>::const_iterator it;
  cfgPtr group, group2, group3;
  HBCI::Error err;
  int nextnum;

  nextnum=0;
  if (!_api->transfers().empty()) {
    group3=cfg.createGroup("transfers",cfg.root());
    if (!group3.isValid())
      return HBCI::Error("AQMLoader::saveAQMTransfer()",
			 ERROR_LEVEL_INTERNAL,
			 0,
			 ERROR_ADVISE_ABORT,
			 "Could not create group",
			 "transfers");

    for (it=_api->transfers().begin();
	 it!=_api->transfers().end();
	 it++) {
      group2=cfg.createGroup(String::num2string(nextnum),group3);
      if (!group2.isValid())
	return HBCI::Error("AQMLoader::writeAQMTransfer()",
			   ERROR_LEVEL_INTERNAL,
			   0,
			   ERROR_ADVISE_ABORT,
			   "Could not create group",
			   String::num2string(nextnum));

      if ((*it).transactionCode()==05)
	group=cfg.createGroup("debitnote",group2);
      else
	group=cfg.createGroup("transaction",group2);
      if (!group.isValid())
	return HBCI::Error("AQMLoader::writeAQMTransfer()",
			   ERROR_LEVEL_INTERNAL,
			   0,
			   ERROR_ADVISE_ABORT,
			   "Could not create group");
      err=saveAQMTransaction(*it,cfg,group);
      if (!err.isOk())
	return err;
      nextnum++;
    } // for
  }

  return HBCI::Error();
}



HBCI::Error AQMLoader::loadAQM(SimpleConfig &cfg,
			       cfgPtr w) {
  HBCI::Error err;
  cfgPtr group;

  err=loadAQMTransfers(cfg, w);
  if (!err.isOk())
    return HBCI::Error("AQMLoader::loadAQM", err);

  return HBCI::Error();
}


HBCI::Error AQMLoader::saveAQM(SimpleConfig &cfg,
			       cfgPtr w) {
  HBCI::Error err;

  err=saveAQMTransfers(cfg, w);
  if (!err.isOk())
    return HBCI::Error("AQMLoader::saveAQM", err);

  return HBCI::Error();
}










