/***************************************************************************
 $RCSfile: aqmconvertertrans.cpp,v $
                             -------------------
    cvs         : $Id: aqmconvertertrans.cpp,v 1.1 2003/05/29 15:37:48 aquamaniac Exp $
    begin       : Sat May 17 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "aqmconvertertrans.h"




AQMConverterTRANS::AQMConverterTRANS():AQMConverter(){
}


AQMConverterTRANS::~AQMConverterTRANS(){
}


Error AQMConverterTRANS::saveTransaction(const AQMTransaction &t,
					 SimpleConfig &cfg,
					 cfgPtr w){
  list<string> sl;
  list<string>::const_iterator it;

  cfg.setVariable("institute",t.ourBankCode(),w);
  cfg.setVariable("id",t.ourAccountId(),w);
  cfg.setVariable("otherinstitute",t.otherBankCode(),w);
  cfg.setVariable("otherid",t.otherAccountId(),w);
  sl=t.otherName();
  for (it=sl.begin(); it!=sl.end(); it++)
    cfg.setVariable("othername",*it,w);
  cfg.setVariable("primanota",t.primanota(),w);
  cfg.setVariable("key",t.transactionKey(),w);
  cfg.setIntVariable("code",t.transactionCode(),w);
  sl=t.description();
  for (it=sl.begin(); it!=sl.end(); it++)
    cfg.setVariable("description",*it,w);
  cfg.setVariable("text",t.transactionText(),w);
  cfg.setVariable("customerreference",t.customerReference(),w);
  cfg.setVariable("bankreference",t.bankReference(),w);
  cfg.setVariable("date",t.date().toString(),w);
  cfg.setVariable("valutadate",t.valutaDate().toString(),w);
  cfg.setVariable("value",t.value().toString(),w);
  cfg.setVariable("originalvalue",t.originalValue().toString(),w);
  cfg.setVariable("charge",t.charge().toString(),w);

  return Error();
}


Error AQMConverterTRANS::loadTransaction(Transaction &t,
					 SimpleConfig &cfg,
					 cfgPtr w){
  cfgPtr val;

  t.setOurBankCode(cfg.getVariable("institute","",w));
  t.setOurAccountId(cfg.getVariable("id","",w));

  t.setOtherBankCode(cfg.getVariable("otherinstitute","",w));
  t.setOtherAccountId(cfg.getVariable("otherid","",w));
  val=cfg.findVariable("othername",w);
  if (val.isValid()) {
    // add othername
    val.child();
    while(val.isValid()) {
      t.addOtherName((*val).data);
      val++;
    } // while
  }
  t.setPrimanota(cfg.getVariable("primanota","",w));
  t.setTransactionKey(cfg.getVariable("key","",w));
  t.setTransactionCode(cfg.getIntVariable("code",51,w));
  val=cfg.findVariable("description",w);
  if (val.isValid()) {
    // add description
    val.child();
    while(val.isValid()) {
      t.addDescription((*val).data);
      val++;
    } // while
  }
  t.setTransactionText(cfg.getVariable("text","",w));
  t.setCustomerReference(cfg.getVariable("customerreference","NONREF",w));
  t.setBankReference(cfg.getVariable("bankreference","",w));
  t.setDate(Date(cfg.getVariable("date","",w)));
  t.setValutaDate(Date(cfg.getVariable("valutadate","",w)));
  t.setValue(Value(cfg.getVariable("value","0,:EUR",w)));
  t.setOriginalValue(Value(cfg.getVariable("originalvalue","0,:EUR",w)));
  t.setCharge(Value(cfg.getVariable("charge","0,:EUR",w)));

  return Error();
}


HBCI::Error AQMConverterTRANS::readFromStream(HBCI::Pointer<Stream> s){
  HBCI::Error err;
  SimpleConfig cfg;
  cfgPtr group, group1;

  cfg.setMode(HBCIAPP_CONFIG_MODE);
  err=cfg.readFromStream(s.ptr(),cfg.root());
  if (!err.isOk())
    return HBCI::Error("AQMConverterTRANS::readFromStream", err);

  // load transactions
  group=cfg.root();
  group.child();
  while(group.isValid()) {
    if (-1!=parser::cmpPattern((*group).data,"transaction",false)) {
      AQMTransaction t;
      err=loadTransaction(t,cfg,group);
      if (!err.isOk())
	return err;
      t.setTransactionCode(51);
      addTransaction(t);
    } // if transaction group
    if (-1!=parser::cmpPattern((*group).data,"debitnote",false)) {
      AQMTransaction t;
      err=loadTransaction(t,cfg,group);
      if (!err.isOk())
	return err;
      t.setTransactionCode(05);
      addTransaction(t);
    } // if transaction group
    group++;
  } // while

  return HBCI::Error();
}


HBCI::Error AQMConverterTRANS::writeToStream(HBCI::Pointer<Stream> s) {
  SimpleConfig cfg;
  cfgPtr group;
  Error err;
  list<AQMTransaction>::const_iterator it;

  // create config
  cfg.setMode(HBCIAPP_CONFIG_MODE);

  for (it=transactions().begin();
       it!=transactions().end();
       it++) {
    if ((*it).transactionCode()==05)
      group=cfg.createGroup("debitnote",cfg.root());
    else
      group=cfg.createGroup("transaction",cfg.root());
    if (!group.isValid())
      return Error("Loader::writeTransactionFile()",
		   ERROR_LEVEL_INTERNAL,
		   0,
		   ERROR_ADVISE_ABORT,
		   "Could not create group",
		   "transaction");
    err=saveTransaction(*it,cfg,group);
    if (!err.isOk())
      return err;
  }

  err=cfg.writeToStream(s.ptr(),cfg.root());
  if (!err.isOk())
    return HBCI::Error("AQMConverterTRANS::writeToStream", err);

  return HBCI::Error();
}



