/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CONFIGDLG_H__
#define __CONFIGDLG_H__

#include <kdialogbase.h>

/*========================================================*/

class ArsonConfig;

class ArsonConfigPage
{
public:
	ArsonConfigPage (ArsonConfig &cfg)
		: m_cfg(cfg) { }

	const ArsonConfig &cfg (void) const { return m_cfg; }
	ArsonConfig &cfg (void) { return m_cfg; }

private:
	ArsonConfig &m_cfg;
};

/*========================================================*/

class ArsonConfigDlg : public KDialogBase
{
	Q_OBJECT
	
public:
	enum { BURNER, GENERAL, RIPPER, DEVICE, PROGRAM, COUNT };
	
	ArsonConfigDlg (ArsonConfig &cfg, int page = BURNER, QWidget *parent = NULL);

	virtual void adjustSize (void);

public slots:
	void configure_devices (void);

private:
	void createPages (void);

	ArsonConfig &m_cfg;
};

/*========================================================*/
#endif	/*	__CONFIGDLG_H__	*/
