/* ---------------------------------------------------------------------
 *
 * -- Automatically Tuned Linear Algebra Software (ATLAS)
 *    (C) Copyright 2000 All Rights Reserved
 *
 * -- ATLAS routine -- Version 3.2 -- December 15, 2000
 *
 * -- Suggestions,  comments,  bugs reports should be sent to the follo-
 *    wing e-mail address: atlas@cs.utk.edu
 *
 * Author         : Antoine P. Petitet
 * University of Tennessee - Innovative Computing Laboratory
 * Knoxville TN, 37996-1301, USA.
 *
 * ---------------------------------------------------------------------
 *
 * -- Copyright notice and Licensing terms:
 *
 *  Redistribution  and  use in  source and binary forms, with or without
 *  modification, are  permitted provided  that the following  conditions
 *  are met:
 *
 * 1. Redistributions  of  source  code  must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce  the above copyright
 *    notice,  this list of conditions, and the  following disclaimer in
 *    the documentation and/or other materials provided with the distri-
 *    bution.
 * 3. The name of the University,  the ATLAS group,  or the names of its
 *    contributors  may not be used to endorse or promote products deri-
 *    ved from this software without specific written permission.
 *
 * -- Disclaimer:
 *
 * THIS  SOFTWARE  IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,  INCLUDING,  BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  INDIRECT, INCIDENTAL, SPE-
 * CIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO,  PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEO-
 * RY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  (IN-
 * CLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ---------------------------------------------------------------------
 */
/*
 * Include files
 */
#include "atlas_ptmisc.h"

void ATL_gesplit
(
   const unsigned int         NT,
   const int                  N,
   const int                  NB,
   unsigned int               * NT1,
   unsigned int               * NT2,
   int                        * N1,
   int                        * N2
)
{
/*
 * Purpose
 * =======
 *
 * ATL_gesplit equally splits a problem dimension N within NT threads.
 *
 * Arguments
 * =========
 *
 * NT      (input)                       const unsigned int
 *         On entry, NT specifies the initial total number of threads.
 *
 * N       (input)                       const int
 *         On entry, N specifies the problem dimension to be split.
 *
 * NB      (input)                       const unsigned int
 *         On entry,  NB  specifies the blocking factor to be used along
 *         this dimension N.
 *
 * NT1     (ouput)                       unsigned int *
 *         On exit,  NT1  specifies the number of threads to be used for
 *         the first part of the problem size N1.
 *
 * NT2     (ouput)                       unsigned int *
 *         On exit,  NT2  specifies the number of threads to be used for
 *         the second part of the problem size N2.
 *
 * N1      (ouput)                       int *
 *         On exit,  N1  specifies  the length of the problem size to be
 *         run on the NT1 threads.
 *
 * N2      (ouput)                       int *
 *         On exit,  N2  specifies  the length of the problem size to be
 *         run on the NT2 threads.
 *
 * ---------------------------------------------------------------------
 */
/*
 * .. Local Variables ..
 */
   double                     r;
   int                        nblks, nhalf;
/* ..
 * .. Executable Statements ..
 *
 */
   nhalf = ( nblks = ( N + NB - 1 ) / NB ) >> 1;
   if( nblks == 2 ) { *N2 = N - ( *N1 = (int)( ((unsigned int)(N)) >> 1 ) ); }
   else             { *N2 = N - ( *N1 = nhalf * NB ); }
   r    = (double)(nhalf) / (double)(nblks);
   *NT2 = NT - ( *NT1 = (unsigned int)floor( r * (double)(NT) + 0.5 ) );
/*
 * End of ATL_gesplit
 */
}
