/* Symbol.h, Uros Platise */

#ifndef __Symbol
#define __Symbol

#include "Lexer.h"
#include "Segment.h"
#include <string>
#include <map>

#define SYM_MAX_PARAM	32

class TSymbolRec{
public:
  enum TAttr{Internal=0,Extern=1,Public=2,Virtual=4};
  
private:  
  TAttr sym_attr;		/* attributes */
  
public:  
  int tbl_offset;		/* attribute error chk. */
  string macro;			/* macro string */
  int noArgs;			/* number of parameters */
  
  int segNo;			/* symbol belongs to segment */
  PSegDep dep;			/* segment dependencies */
  
  string ref;			/* file reference and */
  bool label;			/* if symbol is label */
  bool internal;		/* protected symbols, for internal use */
  PSegTable segP;		/* link to translation table: segP is
                                   also used to declare owner - since each file
				   has its own translation table */				   
public:				   
  TSymbolRec():sym_attr((TAttr)0),noArgs(0),segNo(SEGNUMBER_UNDEFINED),
               label(false),internal(false){}
	       
  inline TAttr attr() const {return sym_attr;}
  
  inline void attr(TAttr _sym_attr){
    if (_sym_attr & Extern){dep = new TSegDep();}
    if ((sym_attr & Extern) && !(_sym_attr & Extern)){dep=NULL;}
    sym_attr=_sym_attr;
  }
  inline void attr_add(TAttr add_attr){attr((TAttr)(sym_attr|add_attr));}
};


class TMacroParam{
  char param_stack[SYM_MAX_PARAM][LX_LINEBUF];
  int psi;	/* Parameter's Stack Index */

public:
  TMacroParam():psi(0){}
  ~TMacroParam(){}

  /* Parameter Stack Operations on one token */
  void Clear(){psi=0;}
  void Add(char *s);
  void Replace(char *s);
  
  /* Parameter Stack Operations on multiple tokens */  
  void ReplaceAll(char* s);  
  
  /* Read-back */
  int Psi() const {return psi;}
};


class TSymbol{
  enum TOperation{Define=1,OK=2,Common=3,Error1,Error2};
  typedef map< string, TSymbolRec, less<string> >::const_iterator TsymCI;
  typedef map< string, TSymbolRec, less<string> >::iterator TsymI;
  
  map< string, TSymbolRec, less<string> > sym;
  static TOperation ErrorTable[16];
  
  bool HaltOnMacro;
  bool undefEqZero;
  
private:
  void GiveUndefinedSymVal(bool zero=false){undefEqZero=zero;}
  int  Replace2Zero();
  void storeSym(TSymbolRec* tmpRec, const string& macroName);
  void MergeDependencies(TSymbolRec* dest, TSymbolRec* src);
  void parseFlags(TSymbolRec* pRec, int terminator_type);
  void parseMacro(TSymbolRec* pRec);
  void reparseMacro(TSymbolRec* pRec);
  void parseReference(TSymbolRec* pRec);
  TOperation test(TSymbolRec* pRec, const string& macroName);
  
public:
  TSymbol():HaltOnMacro(false),undefEqZero(false){}
  ~TSymbol(){}  
  
  bool addMacro();	/* returns true, if symbol is written as "__XXX" */
  void addMacro(const char* macroName, const char* label=NULL,
                TSymbolRec::TAttr macro_attr=TSymbolRec::Internal);                       
  int addLabel();	/* return 1, if label was added ... otherwise 0 */
  bool ifexpr();	/* return true if expression is true */
  bool ifdef();		/* return true if symbol is already in database */
  string* findMacro(const string& macroName);
  bool QueryMacro(const string& macro_name, const string& macro_str);
  bool QueryMacro(const string& macro_name, long val);
  void undefine();
  void undefine(const string& macroName);
  
	/* Segment dep. of the extern virtual symbols are updated
	   after reading all object files. */	
  void SetAllExternVirtualDependencies();
  
  void addInternalLabel(const char* macroName, const char* label=NULL);
  void modifyValue(const char* macroName, const char* macroString);  
  int replaceWithMacro(); /* test if str is macro -> replace it and return 1 
  			     otherwise 0 */
  void haltOnMacro(bool confirm=true){HaltOnMacro=confirm;}
  
  void saveSymbols();
  void loadSymbols(); 
  void loadNonPublicSymbols();
  void updatePublic();
};

extern TSymbol symbol;

#endif

