#!/usr/bin/php4 -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    lu-index-story.php                                      */
/* Author:      Paul Waite                                              */
/* Description: Wrapper for indexing an HTML story file on disk, to     */
/*              Lucene. We expect the path to the file to be passed on  */
/*              the command line as well as the Story ID.               */
/*                                                                      */
/*       usage: ./lu-index-story.php <storypath> <storyid>              */
/*                                                                      */
/* ******************************************************************** */
// CLI Program working dir is always its own directory
// so we need to get into the website root directory..
chdir("..");

include_once("application.php");
include_once("$LIBDIR/lucene-defs.php");

//debug_on(DBG_DIAGNOSTIC);
//debug_output(DBG_O_CLI);

// Only do anything if there are args..
if ($argc > 1) {
  $storypath = $argv[1];
  $storyid = $argv[2];

  // Check for verbose mode of operation..
  if ($storypath == "-v") {
    debug_on(DBG_DEBUG);
    debug_output(DBG_O_CLI);
    $storypath = $argv[2];
    $storyid = $argv[3];
  }
  if (file_exists($storypath)) {
    $indexer = new lucene_fileindexer();
    $indexer->scantags();

    // Note: for this case the following fields should all be
    // defined in the application properties file, so we don't
    // need to use define_field() here. Instead we just make sure
    // they get processed as meta tags from the files..
    $indexer->meta_field("Id", "Id");
    $indexer->meta_field("title", "Text");
    $indexer->meta_field("slug", "Text");
    $indexer->meta_field("date", "Date");
    $indexer->meta_field("added", "Date");
    $indexer->meta_field("category", "Text");
    $indexer->meta_field("subcategory", "Text");
    $indexer->meta_field("type", "Text");
    $indexer->meta_field("source", "Text");
    $indexer->meta_field("sourcetype", "Text");

    $indexer->index_file($storypath, $storyid);
  }
  else {
    debugbr("story not found '$storypath'");
  }
}
?>
