/*
 * gAcc_grlst.c
 * Thomas Nemeth, le 20.06.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "acclists.h"
#include "structs.h"
#include "gAcc_grlst.h"
#include "gAcc_grln.h"
#include "gAcc_grop.h"
#include "locale_formats.h"
#include "gAcc_nyi.h"


/*** Create the "Search" dialog box ****************************/

void grlst_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list = (MY_LIST *) data;
    GtkWidget *grln_radio;
    GtkWidget *grop_radio;
    GtkWidget *grpi_radio;
    GtkWidget *font;
    GtkWidget *date1;
    GtkWidget *date2;
    GtkWidget *grid;

    grln_radio  = (GtkWidget *) my_list_get_element (list,  1);
    grop_radio  = (GtkWidget *) my_list_get_element (list,  2);
    grpi_radio  = (GtkWidget *) my_list_get_element (list,  3);
    date1       = (GtkWidget *) my_list_get_element (list,  4);
    date2       = (GtkWidget *) my_list_get_element (list,  5);
    font        = (GtkWidget *) my_list_get_element (list,  6);
    grid        = (GtkWidget *) my_list_get_element (list,  7);

    if (config.graph_d0 != NULL) free (config.graph_d0);
    if (config.graph_d1 != NULL) free (config.graph_d1);
    config.graph_d0  = unformat_date (gtk_entry_get_text (GTK_ENTRY (date1) ) );
    config.graph_d1  = unformat_date (gtk_entry_get_text (GTK_ENTRY (date2) ) );
    MY_ALLOC (config.graph_fnt,
        strlen (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (font) -> entry ) ) )
        + 1,
        char);
    strcpy (config.graph_fnt,
        gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (font) -> entry ) ) );
    if (GTK_TOGGLE_BUTTON (grid)->active)
        config.graph_grd = VRAI;
    else
        config.graph_grd = FAUX;

    if (GTK_TOGGLE_BUTTON (grln_radio) -> active ) {
        GtkWidget *grln_dialog = create_grln_dialog ();
        gtk_window_set_modal (GTK_WINDOW (grln_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (grln_dialog) );
    } else if (GTK_TOGGLE_BUTTON (grop_radio) -> active ) {
        GtkWidget *grop_dialog = create_grop_dialog ();
        gtk_window_set_modal (GTK_WINDOW (grop_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (grop_dialog) );
    } else if (GTK_TOGGLE_BUTTON (grpi_radio) -> active ) {
        GtkWidget *nyi_dialog = create_nyi_dialog ();
        gtk_window_set_modal (GTK_WINDOW (nyi_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (nyi_dialog) );
    }

    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         list, 0) );
    my_list_free (list);
}

void grlst_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_grlst_dialog () {
    GtkWidget *GrLst_Dialog;
    GtkWidget *bouton;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *frame;
    GtkWidget *texte;
    GtkWidget *grln_radio;
    GtkWidget *grop_radio;
    GtkWidget *grpi_radio;
    GtkWidget *font_combo;
    GtkWidget *date_entry1;
    GtkWidget *date_entry2;
    GtkWidget *grid_check;
    GList     *font_glist = NULL;
    MY_LIST   *list       = NULL;
    long int   date0, today;
    char      *date, *uft;

    GrLst_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (GrLst_Dialog), _("Choose graphic") );
    list = my_list_add (list, GrLst_Dialog);

    gtk_signal_connect_object (GTK_OBJECT (GrLst_Dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (GrLst_Dialog) );
    gtk_signal_connect_object (GTK_OBJECT (GrLst_Dialog), "destroy", 
		                       GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                       GTK_OBJECT (GrLst_Dialog) );

    gtk_container_set_border_width (GTK_CONTAINER (
                                    GTK_DIALOG (GrLst_Dialog) -> vbox), 6);

    /* Search type */
    frame = gtk_frame_new (_(" Graphic type : ") );
    vbox  = gtk_vbox_new (FALSE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* GrLn */
    hbox = gtk_hbox_new (TRUE, 6);
    grln_radio = gtk_radio_button_new_with_label (
                            NULL, 
                            _("Balance graphic (line)") );
    gtk_box_pack_start (GTK_BOX (hbox), grln_radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grln_radio), TRUE);
    gtk_widget_show (grln_radio);

    list = my_list_add (list, grln_radio);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* GrOp */
    hbox = gtk_hbox_new (TRUE, 6);
    grop_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (grln_radio) ),
                            _("Operations graphic (line)") );
    gtk_box_pack_start (GTK_BOX (hbox), grop_radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grop_radio), FALSE);
    gtk_widget_show (grop_radio);

    list = my_list_add (list, grop_radio);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* GrPi */
    hbox = gtk_hbox_new (TRUE, 6);
    grpi_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (grln_radio) ),
                            _("Credit/Debit pies") );
    gtk_box_pack_start (GTK_BOX (hbox), grpi_radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grpi_radio), FALSE);
    gtk_widget_show (grpi_radio);

    list = my_list_add (list, grpi_radio);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Date */
    hbox = gtk_hbox_new (FALSE, 6);

    uft   = unformat_today ();
    today = atol (uft);
    date0 = today - 10000;            /* today - 1 year yyyymmdd*/
    date  = int_to_date_f (date0);

    texte = gtk_label_new (_("From : ") );
    gtk_box_pack_start (GTK_BOX (hbox), texte, FALSE, FALSE, 6);
    gtk_widget_show (texte);

    date_entry1 = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), date_entry1, TRUE, TRUE, 6);
    gtk_entry_set_text (GTK_ENTRY (date_entry1), date);
    gtk_widget_show (date_entry1);

    free (date);

    texte = gtk_label_new (_("To : ") );
    gtk_box_pack_start (GTK_BOX (hbox), texte, FALSE, FALSE, 6);
    gtk_widget_show (texte);

    date  = format_today ();

    date_entry2 = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), date_entry2, TRUE, TRUE, 6);
    gtk_entry_set_text (GTK_ENTRY (date_entry2), date);
    gtk_widget_show (date_entry2);

    free (date);

    list = my_list_add (list, date_entry1);
    list = my_list_add (list, date_entry2);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Font */
    hbox = gtk_hbox_new (FALSE, 6);
    texte = gtk_label_new (_("Font : ") );
    gtk_box_pack_start (GTK_BOX (hbox), texte, FALSE, FALSE, 6);
    gtk_widget_show (texte);

    font_combo = gtk_combo_new ();
    font_glist = g_list_append (font_glist,
        "-b&h-lucidatypewriter-medium-r-normal-*-*-120-*-*-m-*-*-*");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--0-0-75-75-c-0-iso8859-1");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--10-100-75-75-c-60-iso8859-1");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--10-70-100-100-c-60-iso8859-1");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--13-100-100-100-c-70-iso8859-1");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--13-100-100-100-c-80-iso8859-1");
    font_glist = g_list_append (font_glist,
        "-misc-fixed-medium-r-normal--15-140-75-75-c-90-iso8859-1");
    gtk_combo_set_popdown_strings (GTK_COMBO (font_combo), font_glist);
    gtk_combo_set_use_arrows_always(GTK_COMBO (font_combo), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO (font_combo), TRUE);
    gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (
                                 font_combo) -> entry ), FALSE );
    gtk_box_pack_start (GTK_BOX (hbox), font_combo, TRUE, TRUE, 6);
    gtk_widget_show (font_combo);

    list = my_list_add (list, font_combo);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Grid */
    hbox = gtk_hbox_new (TRUE, 6);
    grid_check = gtk_check_button_new_with_label (_("Grid") );
    gtk_box_pack_start (GTK_BOX (hbox), grid_check, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grid_check), TRUE);
    gtk_widget_show (grid_check);
    list = my_list_add (list, grid_check);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (GrLst_Dialog)->vbox), frame,
                        TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    bouton = gtk_button_new_with_label ( _("Show graphic") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (grlst_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (GrLst_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (grlst_cancel_cb),
                        list);
    /*
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Search_Dialog) );
    */
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (GrLst_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);


    return GrLst_Dialog;
}
