//
// $Source: /cvsroot/gambit/gambit/sources/gcl/Attic/gsmfunc.h,v $
// $Date: 2002/08/27 18:57:18 $
// $Revision: 1.2 $
//
// DESCRIPTION:
// Predefined function handling routines for GCL
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef GSMFUNC_H
#define GSMFUNC_H

#include "gsmincl.h"
#include "base/base.h"

class gOutput;

typedef unsigned int    FuncFlagType;
#define funcNULL        ( (FuncFlagType) 0x0000 )
#define funcNONLISTABLE funcNULL
#define funcLISTABLE    ( (FuncFlagType) 0x0001 )
#define funcGAMEMATCH   ( (FuncFlagType) 0x0002 )


#define REQUIRED          ( (Portion*)  0 )

#define BYREF                true
#define BYVAL                false

#define NO_PREDEFINED_PARAMS ( (gclParameter*) 0 )

#define AUTO_VAL_OR_REF      true

#define PARAM_NOT_FOUND   ( (int)      -1 )
#define PARAM_AMBIGUOUS   ( (int)      -2 )


class gclFunction;
class CallFuncObj;

class gInteger;
class GSM;
class Portion;
class ListPortion;
class ReferencePortion;
class gText;
class gclExpression;

template <class T> class gList;
template <class T> class RefCountHashTable;


class gclParameter
{
public:
  gText      Name;
  PortionSpec  Spec;
  Portion*     DefaultValue;
  bool         PassByReference;

  gclParameter(void);
  gclParameter(const gclParameter& paraminfo);
  gclParameter(const gText &name, const PortionSpec &spec,
		Portion *default_value = REQUIRED, 
		const bool pass_by_ref = false);
  ~gclParameter();
};


class gclSignature  {
public:
  bool UserDefined;
  union  {
    Portion *(*FuncPtr)(GSM &, Portion **);
    gclExpression *FuncInstr;
  };
  PortionSpec ReturnSpec;
  FuncFlagType Flag;
  int NumParams;
  gclParameter *ParamInfo;
  gText Desc;

  gclSignature(void);
  gclSignature(const gclSignature& funcinfo);
  gclSignature(Portion *(*funcptr)(GSM &, Portion**),
	       PortionSpec returnspec, int numparams,
	       gclParameter* paraminfo = 0, FuncFlagType = funcLISTABLE);
  gclSignature(gclExpression* funcinstr, PortionSpec returnspec,
	       int numparams, gclParameter* paraminfo = 0,
	       FuncFlagType = funcLISTABLE);
  ~gclSignature();
};



class gclFunction  {
friend class gclFunctionCall;
private:
  static RefCountHashTable<gclExpression *> _RefCountTable;

protected:
  gclFunction( gclFunction& func );

  gText        _FuncName;
  int            _NumFuncs;
  gclSignature*  _FuncInfo;
  GSM &m_environment;

public:
  gclFunction(GSM &m_environment, const gText& func_name, int numfuncs);
  gclFunction(GSM &m_environment, const gText& func_proto,
	      Portion *(*funcptr)(GSM &, Portion **),
	      FuncFlagType = funcLISTABLE);
  virtual ~gclFunction();

  void SetFuncInfo(int funcindex, gclSignature funcinfo);
  void SetFuncInfo(int funcindex, const gText& s);
  void SetFuncInfo(int funcindex, const gText& s, 
                   Portion* (*funcptr)(GSM &, Portion **), 
                   FuncFlagType = funcLISTABLE);
  void SetParamInfo(int funcindex, int index, const gclParameter paraminfo);  
  void SetParamInfo(int funcindex, const gclParameter paraminfo[]);
  
  bool Combine(gclFunction* newfunc);
  bool Delete(gclFunction* newfunc);
  void Delete(int delete_index);

  gText FuncName(void) const;
  
  bool UDF( void ) const;
  bool BIF( void ) const;

  gList<gText> FuncList(bool udf = true, bool bif = true, 
			  bool getdesc = false) const;
  void Dump(gOutput& f, int i) const;
  void Dump(gOutput& f) const;
};




class CallFuncObj : public gclFunction {
private:
  struct RunTimeParamInfoType {
    ReferencePortion *Ref;
    bool Defined, AutoValOrRef;
  };

  int m_line;
  gText m_file;
  int m_funcIndex, m_numParams, m_numParamsDefined;
  Portion **m_params;
  RunTimeParamInfoType *m_runTimeParamInfo;
  bool *m_funcMatch;
  int m_currParamIndex;

  // PRIVATE AUXILIARY MEMBER FUNCTIONS
  gText ParamName(int index) const;

  void ComputeFuncIndex(void);
  Portion *CallNormalFunction(GSM *, Portion **);
  Portion *CallListFunction(GSM *, Portion **);

 public:
  CallFuncObj(gclFunction *, int, const gText &);
  ~CallFuncObj();

  int NumParams(void) const { return m_numParams; }
  bool SetCurrParamIndex(const gText &);
  bool SetCurrParam(Portion *, bool = false);

  ReferencePortion *GetParamRef(int p_index) const;
  Portion *CallFunction(GSM *, Portion **);

  void Dump(gOutput &) const;
};

PortionSpec ToSpec(gText &str, int num = 0);


#endif  // GSMFUNC_H


