//
// $Source: /cvsroot/gambit/gambit/sources/gui/Attic/nfgoutcome.h,v $
// $Revision: 1.4 $
// $Date: 2002/08/27 20:29:33 $
//
// DESCRIPTION:
// Declaration of normal form outcome palette window
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef NFGOUTCOME_H
#define NFGOUTCOME_H

#include "wx/grid.h"
#include "nfgshow.h"

class NfgOutcomeWindow : public wxGrid {
private:
  NfgShow *m_parent;
  wxMenu *m_menu;

  void OnChar(wxKeyEvent &);
  void OnCellChanged(wxGridEvent &);
  void OnCellRightClick(wxGridEvent &);
  void OnLabelRightClick(wxGridEvent &);

  void OnPopupOutcomeNew(wxCommandEvent &);
  void OnPopupOutcomeDelete(wxCommandEvent &);
  void OnPopupOutcomeAttach(wxCommandEvent &);
  void OnPopupOutcomeDetach(wxCommandEvent &);

public:
  NfgOutcomeWindow(NfgShow *p_efgShow, wxWindow *p_parent);
  virtual ~NfgOutcomeWindow() { }

  void UpdateValues(void);

  DECLARE_EVENT_TABLE()
};


#endif  // NFGOUTCOME_H
