/* sqlquerygrid.h
 *
 * Copyright (C) 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_GRID__
#define __SQL_QUERY_GRID__

#include <gnome.h>
#include "sqlqueryexec.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_GRID(obj)          GTK_CHECK_CAST (obj, sql_query_grid_get_type(), SqlQueryGrid)
#define SQL_QUERY_GRID_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_grid_get_type (), SqlQueryGridClass)
#define IS_SQL_QUERY_GRID(obj)       GTK_CHECK_TYPE (obj, sql_query_grid_get_type ())


	typedef struct _SqlQueryGrid SqlQueryGrid;
	typedef struct _SqlQueryGridClass SqlQueryGridClass;

	/* struct for the object's data */
	struct _SqlQueryGrid
	{
		GtkVBox object;

		SqlQueryExec *qx;
		GtkWidget *grid;

		/* private */
		GtkWidget *private;
		glong sel_row;
	};

	/* struct for the object's class */
	struct _SqlQueryGridClass
	{
		GtkVBoxClass parent_class;

		void (*action_refresh) (SqlQueryGrid * qgr);
		void (*action_insert) (SqlQueryGrid * qgr);
		void (*action_edit) (SqlQueryGrid * qgr, gulong row);
		void (*action_delete) (SqlQueryGrid * qgr, gulong row);
		void (*action_choose) (SqlQueryGrid * qgr, gulong row);
	};

	/* generic widget's functions */
	guint sql_query_grid_get_type (void);
	GtkWidget *sql_query_grid_new (SqlQueryExec * exec);
	void sql_query_grid_refresh (SqlQueryGrid * qgr);


#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
