/******************************************************************************
 * $Id: ogrcompoint.cpp,v 1.5 1999/05/21 02:39:50 warmerda Exp $
 *
 * Project:  OpenGIS Simple Features Reference Implementation
 * Purpose:  Implementation of OGRCOMPoint class.
 * Author:   Frank Warmerdam, warmerda@home.com
 *
 ******************************************************************************
 * Copyright (c) 1999, Frank Warmerdam
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************
 *
 * $Log: ogrcompoint.cpp,v $
 * Revision 1.5  1999/05/21 02:39:50  warmerda
 * Added IWks support
 *
 * Revision 1.4  1999/05/17 14:43:10  warmerda
 * Added Polygon, linestring and curve support.  Changed IGeometryTmpl to
 * also include COM interface class as an argument.
 *
 * Revision 1.3  1999/05/14 14:08:39  warmerda
 * OGRComGeometry converted to template OGRComGeometryTmpl
 *
 * Revision 1.2  1999/05/14 13:28:38  warmerda
 * client and service now working for IPoint
 *
 * Revision 1.1  1999/05/13 19:49:01  warmerda
 * New
 *
 */

#include "ogrcomgeometry.h"
#include "ogrcomgeometrytmpl.h"

/************************************************************************/
/*                            OGRComPoint()                             */
/************************************************************************/

OGRComPoint::OGRComPoint( OGRPoint * poPointIn ) 
        : OGRComGeometryTmpl<OGRPoint,IPoint>( poPointIn )

{
}

// =======================================================================
// IUnknown methods
// =======================================================================

/************************************************************************/
/*                           QueryInterface()                           */
/************************************************************************/

STDMETHODIMP OGRComPoint::QueryInterface(REFIID rIID,
                                         void** ppInterface)
{
   // Set the interface pointer
   if (rIID == IID_IUnknown) {
      *ppInterface = this;
   }

   else if (rIID == IID_IGeometry) {
      *ppInterface = this;
   }

   else if (rIID == IID_IWks) {
      *ppInterface = &oWks;
   }

   else if (rIID == IID_IPoint) {
      *ppInterface = this;
   }

   // We don't support this interface
   else {
      *ppInterface = NULL;
      return E_NOINTERFACE;
   }

   // Bump up the reference count
   ((LPUNKNOWN) *ppInterface)->AddRef();

   return NOERROR;
}

// =======================================================================
// IPoint methods
// =======================================================================

/************************************************************************/
/*                               Coords()                               */
/************************************************************************/

STDMETHODIMP OGRComPoint::Coords( double * x, double * y )

{
    *x = poGeometry->getX();
    *y = poGeometry->getY();

    return ResultFromScode( S_OK );
}

/************************************************************************/
/*                               get_X()                                */
/************************************************************************/

STDMETHODIMP OGRComPoint::get_X( double * x )

{
    *x = poGeometry->getX();

    return ResultFromScode( S_OK );
}

/************************************************************************/
/*                               get_Y()                                */
/************************************************************************/

STDMETHODIMP OGRComPoint::get_Y( double * y )

{
    *y = poGeometry->getY();

    return ResultFromScode( S_OK );
}

