/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  hyperlinksignals.cc - Atk::Hyperlink virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hyperlink.hh"
#include "hyperlinksignals.hh"
#include "private/hyperlinkclass.hh"

using namespace GFC;

/*  Atk::HyperlinkSignals
 */

Atk::HyperlinkSignals::HyperlinkSignals(Hyperlink *hyperlink) 
: G::ObjectSignals(hyperlink)
{
	Atk::HyperlinkClass::init(ATK_HYPERLINK_GET_CLASS(hyperlink->atk_hyperlink()));
}

Atk::HyperlinkSignals::~HyperlinkSignals() 
{
}
	
void
Atk::HyperlinkSignals::on_link_activated()
{
	AtkHyperlinkClass *g_class = HyperlinkClass::get_parent_class(instance_);
	if (g_class->link_activated)
		g_class->link_activated((AtkHyperlink*)instance_);
}

/*  Atk::HyperlinkClass
 */

void
Atk::HyperlinkClass::init(AtkHyperlinkClass *g_class)
{
	g_class->link_activated = &link_activated_proxy;
}

AtkHyperlinkClass*
Atk::HyperlinkClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(ATK_HYPERLINK_GET_CLASS(instance));
	return static_cast<AtkHyperlinkClass*>(ptr);
}

GType
Atk::HyperlinkClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_HYPERLINK);
	}
	return type;
}

void*
Atk::HyperlinkClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Atk::HyperlinkClass::link_activated_proxy(AtkHyperlink *link)
{
	void *ptr = g_object_get_qdata((GObject*)link, G::ObjectSignals::quark());
	if (ptr)
		static_cast<HyperlinkSignals*>(ptr)->on_link_activated();
	else
	{
		AtkHyperlinkClass *g_class = HyperlinkClass::get_parent_class(link);
		if (g_class->link_activated)
			g_class->link_activated(link);
	}
}

