/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/cellrendererpixbuf.hh
/// @brief A GtkCellRendererPixbuf C++ wrapper interface.
///
/// Provides CellRendererPixbuf, an object that renders a pixbuf in a cell.

#ifndef GFC_GTK_CELL_RENDERER_PIXBUF_HH
#define GFC_GTK_CELL_RENDERER_PIXBUF_HH

#ifndef GFC_GTK_CELL_RENDERER_HH
#include <gfc/gtk/cellrenderer.hh>
#endif

#ifndef GFC_G_PROPERTY_HH
#include <gfc/glib/property.hh>
#endif

#ifndef __GTK_CELL_RENDERER_PIXBUF_H__
#include <gtk/gtkcellrendererpixbuf.h>
#endif

namespace GFC {

namespace Gdk {
class Pixbuf;
}

namespace Gtk {

class StockId;

/// @class CellRendererPixbuf cellrendererpixbuf.hh gfc/gtk/cellrendererpixbuf.hh
/// @brief A GtkCellRendererPixbuf C++ wrapper class.
///
/// CellRendererPixbuf is an object that renders a pixbuf in a cell.

class CellRendererPixbuf : public CellRenderer
{
	friend class G::Object;

	CellRendererPixbuf(const CellRendererPixbuf&);
	CellRendererPixbuf& operator=(const CellRendererPixbuf&);

protected:
/// @name Constructors
/// @{

	explicit CellRendererPixbuf(GtkCellRendererPixbuf *cell, bool owns_reference = false);
	///< Construct a new CellRendererPixbuf from an existing GtkCellRendererPixbuf.
	///< @param cell A pointer to a GtkCellRendererPixbuf.
	///< @param owns_reference Set false if the initial reference count is floating, set true if it's not.
	///<
	///< <BR>The <EM>cell</EM> can be a newly created GtkCellRendererPixbuf or an existing
	///< GtkCellRendererPixbuf. (see G::Object::Object).

/// @}
/// @name Property Prototypess
/// @{

	typedef G::Property<Gdk::Pixbuf*, G::Object*> PixbufPropertyType;
	typedef G::PropertyProxy<G::Object, PixbufPropertyType> PixbufPropertyProxy;
	static const PixbufPropertyType pixbuf_property;
	///< The pixbuf to render (see prop_pixbuf()).

	typedef G::Property<Gdk::Pixbuf*, G::Object*> PixbufExpanderOpenPropertyType;
	typedef G::PropertyProxy<G::Object, PixbufExpanderOpenPropertyType> PixbufExpanderOpenPropertyProxy;
	static const PixbufExpanderOpenPropertyType pixbuf_expander_open_property;
	///< Pixbuf for open expander (see prop_pixbuf_expander_open()).

	typedef G::Property<Gdk::Pixbuf*, G::Object*> PixbufExpanderClosedPropertyType;
	typedef G::PropertyProxy<G::Object, PixbufExpanderClosedPropertyType> PixbufExpanderClosedPropertyProxy;
	static const PixbufExpanderClosedPropertyType pixbuf_expander_closed_property;
	///< Pixbuf for closed expander (see prop_pixbuf_expander_closed()).

	typedef G::Property<String> StockIdPropertyType;
	typedef G::PropertyProxy<G::Object, StockIdPropertyType> StockIdPropertyProxy;
	static const StockIdPropertyType stock_id_property;
	///< The stock ID of the stock icon to render (see prop_stock_id()).

	typedef G::Property<IconSize, int> StockSizePropertyType;
	typedef G::PropertyProxy<G::Object, StockSizePropertyType> StockSizePropertyProxy;
	static const StockSizePropertyType stock_size_property;
	///< The size of the rendered icon (see prop_stock_size()).

	typedef G::Property<String> StockDetailPropertyType;
	typedef G::PropertyProxy<G::Object, StockDetailPropertyType> StockDetailPropertyProxy;
	static const StockDetailPropertyType stock_detail_property;
	///< The render detail to pass to the theme engine (see prop_stock_detail()).
	
/// @}

public:
/// @name Constructors
/// @{

	CellRendererPixbuf();
	///< Construct a new CellRendererPixbuf.
	///< Adjust rendering parameters using object properties. Also, with TreeViewColumn, you 
	///< can bind a property to a value in a TreeModel. For example, you can bind the "pixbuf"
	///< property on the cell renderer to a pixbuf value in the model, thus rendering a 
	///< different image in each row of the TreeView.

	virtual ~CellRendererPixbuf();
	///< Destructor.
	
/// @}
/// @name Accessors
/// @{

	GtkCellRendererPixbuf* gtk_cell_renderer_pixbuf() const;
	///< Get a pointer to the GtkCellRendererPixbuf structure.

	operator GtkCellRendererPixbuf* () const;
	///< Conversion operator; safely converts a CellRendererPixbuf to a GtkCellRendererPixbuf pointer.

/// @}
/// @name Property Proxies
/// @{

	const PixbufPropertyProxy prop_pixbuf();
	///< The pixbuf to render (Gdk::Pixbuf* : Read / Write).

	const PixbufExpanderOpenPropertyProxy prop_pixbuf_expander_open();
	///< Pixbuf for open expander (Gdk::Pixbuf* : Read / Write).

	const PixbufExpanderClosedPropertyProxy prop_pixbuf_expander_closed();
	///< Pixbuf for closed expander (Gdk::Pixbuf* : Read / Write).

	const StockIdPropertyProxy prop_stock_id();
	///< The stock ID of the stock icon to render (String : Read / Write).

	const StockSizePropertyProxy prop_stock_size();
	///< The size of the rendered icon (IconSize : Read / Write).

	const StockDetailPropertyProxy prop_stock_detail();
	///< The render detail to pass to the theme engine (String : Read / Write).

///@}
};

} // namespace Gtk

} // namespace GFC

#include <gfc/gtk/inline/cellrendererpixbuf.inl>

#endif // GFC_GTK_CELL_RENDERER_PIXBUF_HH

