/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  cellrenderertoggle.cc - GtkCellRendererToggle C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderertoggle.hh"
#include "private/marshal.hh"
#include "private/cellrenderertoggleclass.hh"

using namespace GFC;

/*  Gtk::CellRendererToggle
 */

Gtk::CellRendererToggle::CellRendererToggle(GtkCellRendererToggle *cell, bool owns_reference)
: CellRenderer((GtkCellRenderer*)cell, owns_reference)
{
}

Gtk::CellRendererToggle::CellRendererToggle()
: CellRenderer((GtkCellRenderer*)CellRendererToggleClass::create())
{
}

Gtk::CellRendererToggle::~CellRendererToggle()
{
}

/* Gtk::CellRendererToggle properties
 */

const Gtk::CellRendererToggle::ActivePropertyType Gtk::CellRendererToggle::active_property("active");

const Gtk::CellRendererToggle::ActivatablePropertyType Gtk::CellRendererToggle::activatable_property("activatable");

const Gtk::CellRendererToggle::RadioPropertyType Gtk::CellRendererToggle::radio_property("radio");

const Gtk::CellRendererToggle::InconsistentPropertyType Gtk::CellRendererToggle::inconsistent_property("inconsistent");

/*  Gtk::CellRendererToggle signals
 */

const Gtk::CellRendererToggle::ToggledSignalType Gtk::CellRendererToggle::toggled_signal("toggled", (GCallback)&Marshal::void_string_callback);

