/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  togglebutton.cc - GtkToggleButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "togglebutton.hh"
#include "togglebuttonsignals.hh"
#include "private/togglebuttonclass.hh"

using namespace GFC;

/*  Gtk::ToggleButtonSignals
 */

Gtk::ToggleButtonSignals::ToggleButtonSignals(ToggleButton *toggle_button)
: ButtonSignals(toggle_button)
{
	Gtk::ToggleButtonClass::init(GTK_TOGGLE_BUTTON_GET_CLASS(toggle_button->gtk_toggle_button()));
}

Gtk::ToggleButtonSignals::~ToggleButtonSignals()
{
}

void
Gtk::ToggleButtonSignals::on_toggled()
{
	GtkToggleButtonClass *g_class = ToggleButtonClass::get_parent_class(instance_);
	if (g_class->toggled)
		g_class->toggled((GtkToggleButton*)instance_);
}

/*  Gtk::ToggleButtonClass
 */

void
Gtk::ToggleButtonClass::init(GtkToggleButtonClass *g_class)
{
	g_class->toggled = &toggled_proxy;
}

GtkToggleButtonClass*
Gtk::ToggleButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOGGLE_BUTTON_GET_CLASS(instance));
	return static_cast<GtkToggleButtonClass*>(ptr);
}

GType
Gtk::ToggleButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOGGLE_BUTTON);
	}
	return type;
}

void*
Gtk::ToggleButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ToggleButtonClass::toggled_proxy(GtkToggleButton *toggle_button)
{
	void *ptr = g_object_get_qdata((GObject*)toggle_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToggleButtonSignals*>(ptr)->on_toggled();
	else
	{
		GtkToggleButtonClass *g_class = ToggleButtonClass::get_parent_class(toggle_button);
		if (g_class->toggled)
			g_class->toggled(toggle_button);
	}
}

