/*           Callbacks.c - Every Callback can be found here  -  S.Ekanth           */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <time.h>


#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gfs_func.h"
#include "gfs_defs.h"
#include "gfs_conf.h"

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

/*GtkWidget *slice;
GtkWidget *deslice;
GtkWidget *tar;
GtkWidget *untar;
GtkWidget *preferences;
GtkWidget *log;
GtkWidget *about;*/

GtkWidget *widget;

static gchar *sin_file_path, *sin_file_name, *sin_file_size, *sout_file_name, *ssp_size, *snum_pieces, *sout_file_path;
gchar *sifp_to_func, *sofp_to_func;

unsigned long int file_size=0, split_size, no_of_pieces=0;

static gchar *din_file_path, *din_file_name, *dout_file_size, *dout_file_name, *dsp_size, *dnum_pieces, *dout_file_path;
gchar *difp_to_func, *dofp_to_func;

FILE *logfp;
gchar *logfname, *logtime;
struct tm* tmptr;
time_t timeptr;


void
on_slice1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  slice = create_slice ();
  gtk_widget_show (slice);

  widget = lookup_widget(slice, "entry16");
  gtk_entry_set_text(GTK_ENTRY(widget),"Welcome to gfslicer. Select a file to slice.");
}


void
on_deslice1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  deslice = create_deslice ();
  gtk_widget_show (deslice);

  widget = lookup_widget(deslice, "entry17");
  gtk_entry_set_text(GTK_ENTRY(widget),"Welcome to gfslicer. Select a file with .b00 extn to deslice.");
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (prefs.set.saveset)
    gfs_conf_write ();
  gtk_main_quit();
/*  return(FALSE);*/
}


void
on_help1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  about = create_about();
  gtk_widget_show (about);
}


void
on_slice_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  slice = create_slice ();
  gtk_widget_show (slice);

  widget = lookup_widget(slice, "entry16");
  gtk_entry_set_text(GTK_ENTRY(widget),"Welcome to gfslicer. Select a file to slice.");
}


void
on_deslice_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{


  deslice = create_deslice ();
  gtk_widget_show (deslice);

  widget = lookup_widget(deslice, "entry17");
  gtk_entry_set_text(GTK_ENTRY(widget),"Welcome to gfslicer. Select a file with .b00 extn to deslice.");
}


void
on_slice_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  gint len = 0;
  gboolean boo;  
  
  sifp_to_func = g_malloc0(100);
  sofp_to_func = g_malloc0(100);

  widget = lookup_widget(slice, "combo_entry2");
  sout_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
    
  len = strlen(sout_file_path);

  if(sout_file_path[len-1] != '/')
  {
    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"Select a correct output path");

    widget = lookup_widget(slice, "slice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    return;
  }

  strcpy (sifp_to_func, sin_file_path);
  strcpy (sofp_to_func, sout_file_path);

  boo = file_slice (sifp_to_func, sofp_to_func, sin_file_name, split_size, no_of_pieces, slice); 

  if(boo == 1)
  {
    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"File sliced successfully!!!");
  }

  if (!(prefs.set.nolog))
  {
    logfname = g_malloc0 (100);
    logtime = g_malloc0 (50);

    strcpy(logfname, prefs.dir.logdir);
    strcat(logfname,"log.txt");

    if((logfp = fopen (logfname,"rb+")) == NULL)
      logfp = fopen (logfname,"wb");
    
    timeptr = time (NULL);
    tmptr = localtime(&timeptr);
  
    fseek (logfp, 0 , SEEK_END);

    fprintf (logfp, "%s%s", asctime (tmptr), "[Slice]");
    if(prefs.log.fpath) 
      fprintf (logfp, "\nFile Path  :  %s", sifp_to_func);
    if(prefs.log.fname)
      fprintf (logfp, "\nFile Name  :  %s", sin_file_name);
    if(prefs.log.fsize)
      fprintf (logfp, "\nFile Size  :  %s", sin_file_size);    
    if(prefs.log.spsize)
      fprintf (logfp, "\nSplit Size  :  %ld", split_size);
    if(prefs.log.pieces)
      fprintf (logfp, "\nNo of pieces  :  %ld\n\n", no_of_pieces);

    fclose (logfp);
  }
   
}


void
on_recheck_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  char dfmark[30], dbuf;
  gchar dfile_num[3], *dcheck_fname, *dcheck_fpath, *dcheck_temp_name, *dcheck_temp_path, *dcheck_count, *dfile_ext;
  gint dlen=0, ddum_len=0, dflag=0, dfile_count=0, i, j;
  FILE *dinfile;

  din_file_path = g_malloc0(100);
  din_file_name = g_malloc0(100);
  dout_file_name = g_malloc0(100);
  dsp_size = g_malloc0(15);
  dnum_pieces = g_malloc0(15);
  dout_file_path = g_malloc0(100);
  dfile_ext = g_malloc0(20);
  dcheck_fname = g_malloc0(100);
  dcheck_fpath = g_malloc0(100);
  dcheck_temp_name = g_malloc0(100);
  dcheck_temp_path = g_malloc0(100);
  dcheck_count = g_malloc0(100);
  difp_to_func = g_malloc0(100);
  dofp_to_func = g_malloc0(100);


/*         Extracting input file name                */

  widget = lookup_widget(deslice, "combo_entry3");
  din_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
  ddum_len = strlen(din_file_path);
  ddum_len--;
  
  while(din_file_path[ddum_len]!='\0')
  {

    if(din_file_path[ddum_len]!='/')
      ddum_len--;
    else
      break;
  }

  ddum_len++;

/*      Extracting the file path to check the file availability below   */

  i=0;
  while(i <= ddum_len-1)
    dcheck_fpath[i] = din_file_path[i++];

  if(i > 0)
    dcheck_fpath[i] = '\0';

/*     End of file path extraction       */

  while(din_file_name[dlen++] = din_file_path[ddum_len++])
  {
    dflag=1;
  }

  if(dflag == 1)
    din_file_name[dlen] = '\0';

  dlen = strlen (din_file_name);
  dlen--;

  while(din_file_name[dlen] != '\0')
  {

    if(din_file_name[dlen]!='.')
      dlen--;
    else
      break;
  }

  dlen++;
  
  dflag = 0;
  i=0;
  while(dfile_ext[i++] = din_file_name[dlen++])
  {
    dflag=1;
  }

  if(dflag == 1)
    dfile_ext[i] = '\0';

  if (strcmp(dfile_ext,"b00") == 0)
  {
    widget = lookup_widget(deslice, "entry15");
    gtk_entry_set_text(GTK_ENTRY(widget),din_file_name);
  }
  else
  {
    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"Open the correct file. The file's extension must be b00");
    return;
  }

/*        End of input file name extraction            */

/*          Extracting number of actual pieces, output file name, output file size        */

  if((dinfile = fopen (din_file_path, "rb")) == NULL)
  {
    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"Error opening file!!! Select a file to open");
    return;
  }    

  fread(dfmark,sizeof(dfmark),1,dinfile);
  fscanf (dinfile,"%ld",&file_size);
  dbuf = fgetc (dinfile);
  fscanf (dinfile,"%ld",&no_of_pieces);
  fclose (dinfile);
  
  file_size /= 1024;
  dout_file_size = itoa (file_size);
  dnum_pieces = itoa (no_of_pieces);

  widget = lookup_widget(deslice, "entry10");
  gtk_entry_set_text(GTK_ENTRY(widget),dnum_pieces);

  widget = lookup_widget(deslice, "entry8");
  gtk_entry_set_text(GTK_ENTRY(widget),dout_file_size);

  i=0;
  while(dfmark[i]!='@')
  {
    dout_file_name[i]=dfmark[i];
    i++;
  }

  if (i > 0)
    dout_file_name[i] = '\0';

  widget = lookup_widget(deslice, "entry9");
  gtk_entry_set_text(GTK_ENTRY(widget),dout_file_name);

/*     Check for the availability of all pieces        */


  i=0;

  while(din_file_name[i]!='.')
  {
    if(din_file_name[i]=='\0')
      break;
    dcheck_fname[i] = din_file_name[i++];
  }

  if(i>0)
    dcheck_fname[i]='\0';

  i=48;
  j=48;
  dfile_num[0]=toascii(i);
  dfile_num[1]=toascii(j);
  dfile_num[2]='\0';

  strcpy (dcheck_temp_name, dcheck_fname);
  strcat (dcheck_fname, ".b");
  strcat (dcheck_fname, dfile_num);

  strcpy (dcheck_temp_path, dcheck_fpath);
  strcat (dcheck_fpath, dcheck_fname);

  strcpy (difp_to_func, dcheck_temp_path);
  strcat (difp_to_func, dcheck_temp_name);

  while ((dinfile = fopen (dcheck_fpath, "rb")) != NULL)
  {  
    dfile_count++;

    j++;
    if(j>57)
    {
      i++;
      j=48;
    }
    dfile_num[0]=toascii(i);
    dfile_num[1]=toascii(j);
    dfile_num[2]='\0';

    strcpy (dcheck_fname, dcheck_temp_name);
    strcat (dcheck_fname, ".b");
    strcat (dcheck_fname, dfile_num);

    strcpy (dcheck_fpath, dcheck_temp_path);
    strcat (dcheck_fpath, dcheck_fname);
  }   

  dcheck_count = itoa (dfile_count);
  widget = lookup_widget(deslice, "entry11");
  gtk_entry_set_text(GTK_ENTRY(widget),dcheck_count);

  if(no_of_pieces != dfile_count)
  {
    widget = lookup_widget(deslice, "deslice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"Some files may be missing. Replace them and re-check");
    return;
  } 

/*      Checking the output file path               */

  widget = lookup_widget(deslice, "combo_entry4");
  dout_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
  
  dlen = strlen(dout_file_path);

  if(dout_file_path[dlen-1] != '/')
  {
    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"Select a correct output path");

    widget = lookup_widget(deslice, "deslice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    return;
  }

/*        End of output file path checking      */

/*     This is generated to pass as an argument to the de slice function      */

  strcpy (dofp_to_func, dout_file_path);
  strcat (dofp_to_func, dout_file_name); 

/*     If everything is okay then enable deslice button        */

  widget = lookup_widget(deslice, "entry17");
  gtk_entry_set_text(GTK_ENTRY(widget),"Click Deslice to join the file !!!");

  widget = lookup_widget(deslice, "deslice_button");
  gtk_widget_set_sensitive (widget, TRUE);


}


void
on_deslice_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{

  gint len = 0;
  gboolean boo;  
  
 /* difp_to_func = g_malloc0(100);
  dofp_to_func = g_malloc0(100);*/

  widget = lookup_widget(deslice, "combo_entry4");
  dout_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
    
  len = strlen(dout_file_path);

  if(dout_file_path[len-1] != '/')
  {
    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"Select a correct output path");

    widget = lookup_widget(deslice, "deslice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    return;
  }

  boo = file_deslice (difp_to_func, dofp_to_func, deslice); 

  if(boo == 1)
  {
    widget = lookup_widget(deslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(widget),"File Desliced successfully!!!");    
  }

  if (!(prefs.set.nolog))
  {
    logfname = g_malloc0 (100);
    logtime = g_malloc0 (50);

    strcpy(logfname, prefs.dir.logdir);
    strcat(logfname,"log.txt");

    if((logfp = fopen (logfname,"rb+")) == NULL)
      logfp = fopen (logfname,"wb");
    
    timeptr = time (NULL);
    tmptr = localtime(&timeptr);
  
    fseek (logfp, 0 , SEEK_END);

    fprintf (logfp, "%s%s", asctime (tmptr), "[Deslice]");
    if(prefs.log.fpath)
    {    		 
      fprintf (logfp, "\nFile Path  :  %s", dofp_to_func);
      fprintf (logfp, "\nInput File  :  %s\n\n", din_file_path);
    }

    fclose (logfp);
  }

}


void
on_scheck_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar sbuf, sfile_num[3];
  gint slen=0, sdum_len=0, sflag=0, i, j;
  FILE *sinfile;
  
  sin_file_path = g_malloc0(100);
  sin_file_name = g_malloc0(100);
  sout_file_name = g_malloc0(100);
  ssp_size = g_malloc0(15);
  snum_pieces = g_malloc0(15);
  sout_file_path = g_malloc0(100);

  widget = lookup_widget(slice, "combo_entry1");
  sin_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
  sdum_len = strlen(sin_file_path);
  sdum_len--;
  
  if(sin_file_path[sdum_len] == '/')
  {
    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"Your selection seems to be a folder!!!");
    return;
  }
    
/*  while(sin_file_path[sdum_len]!='\0')  This seemed unnecessary*/

  while(sdum_len !=  0)
  {

    if(sin_file_path[sdum_len]!='/')
      sdum_len--;
    else
      break;
  }

  sdum_len++;

  while(sin_file_name[slen++] = sin_file_path[sdum_len++])
  {
    sflag=1;
  }

  if(sflag == 1)
    sin_file_name[slen] = '\0';

  widget = lookup_widget(slice, "entry13");
  gtk_entry_set_text(GTK_ENTRY(widget),sin_file_name);

  /*memset(sin_file_path, 0, strlen(sin_file_path));
  memset(sin_file_name, 0, strlen(sin_file_name));
  g_free(sin_file_path);
  g_free(sin_file_name);       */

/* Checking for file size */

  if((sinfile=fopen(sin_file_path,"rb"))==NULL)
  {
    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"Error opening file!!! Select a file to open");
    return;
  }

  while (!feof(sinfile))
  {
    sbuf=fgetc(sinfile);
    file_size++;
  }

  file_size /= 1024;
  fclose(sinfile);
  sin_file_size = itoa(file_size);
  strcat(sin_file_size," KB");
  
  widget = lookup_widget(slice, "entry6");
  gtk_entry_set_text(GTK_ENTRY(widget),sin_file_size);

/* Extracting the output file name */

  i=48;
  j=48;
  sfile_num[0]=toascii(i);
  sfile_num[1]=toascii(j);
  sfile_num[2]='\0';

  i=0;

  while(sin_file_name[i]!='.')
  {
    if(sin_file_name[i]=='\0')
      break;
    sout_file_name[i] = sin_file_name[i++];
  }

  if(i>0)
    sout_file_name[i]='\0';

  strcat(sout_file_name,".b");
  strcat(sout_file_name,sfile_num);

  widget = lookup_widget(slice, "entry14");
  gtk_entry_set_text(GTK_ENTRY(widget), sout_file_name);

/* Checking for number of split files */

  if (GTK_TOGGLE_BUTTON(lookup_widget(slice, "radiobutton1"))->active)
	split_size = 1280;

  if (GTK_TOGGLE_BUTTON(lookup_widget(slice, "radiobutton2"))->active)
	split_size = 1024;

  if (GTK_TOGGLE_BUTTON(lookup_widget(slice, "radiobutton3"))->active)
	split_size = 512;

  if (GTK_TOGGLE_BUTTON(lookup_widget(slice, "radiobutton4"))->active)
	split_size = 102;

  if (GTK_TOGGLE_BUTTON(lookup_widget(slice, "radiobutton5"))->active)
  {
    widget = lookup_widget(slice, "usr_def_size");
    ssp_size = gtk_entry_get_text(GTK_ENTRY(widget));
    slen = strlen (ssp_size);

    if (slen == 0)    
    {
      widget = lookup_widget(slice, "entry16");
      gtk_entry_set_text(GTK_ENTRY(widget),"Enter a size to split...");
      return;    
    }

    split_size = atoi(ssp_size);
  }

  if(file_size > split_size)
  {  
    no_of_pieces =  file_size/split_size;    
    no_of_pieces++;

      if(no_of_pieces > 100)
      {
        widget = lookup_widget(slice, "entry16");
        gtk_entry_set_text(GTK_ENTRY(widget),"No of pieces exceeds 100. Select a larger split size.");
        return;         
      }

    snum_pieces = itoa(no_of_pieces);

    widget = lookup_widget(slice, "entry12");
    gtk_entry_set_text(GTK_ENTRY(widget),snum_pieces);

  }
  else
  {
    widget = lookup_widget(slice, "entry12");
    gtk_entry_set_text(GTK_ENTRY(widget),"0");

    widget = lookup_widget(slice, "slice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"Check file size. File can't be split");


     return;
  }

/*       Checking Output file path        */

  widget = lookup_widget(slice, "combo_entry2");
  sout_file_path = gtk_entry_get_text(GTK_ENTRY(widget));
  
  slen = strlen(sout_file_path);

  if(sout_file_path[slen-1] != '/')
  {
    widget = lookup_widget(slice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(widget),"Select a correct output path");

    widget = lookup_widget(slice, "slice_button");
    gtk_widget_set_sensitive (widget, FALSE);

    
    return;
  }

/*   If everything is okay then enable slice button.     */

  widget = lookup_widget(slice, "entry16");
  gtk_entry_set_text(GTK_ENTRY(widget),"Click Slice to split the file");

  widget = lookup_widget(slice, "slice_button");
  gtk_widget_set_sensitive (widget, TRUE);
   
}

gboolean
on_slice_delete_event                  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  gtk_widget_destroy (widget); 
  return FALSE;

}

void
on_gfslicer_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  if (prefs.set.saveset)
    gfs_conf_write ();
  gtk_main_quit();

}

void
on_radiobutton5_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

/*     Enable user defined file size entry box if user-defined radio-button is checked      */

  if (GTK_TOGGLE_BUTTON(togglebutton)->active)
  {
    widget = lookup_widget(slice, "usr_def_size");
    gtk_widget_set_sensitive (widget, TRUE);
  }
  else
  {
    widget = lookup_widget(slice, "usr_def_size");
    gtk_widget_set_sensitive (widget, FALSE);
  }
}


void
on_tar_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  tar = create_tar ();
  gtk_widget_show (tar);
}


void
on_untar_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  untar = create_untar();
  gtk_widget_show (untar);
}




void
on_tar_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  tar = create_tar ();
  gtk_widget_show (tar);
}


void
on_untar_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  untar = create_untar ();
  gtk_widget_show (untar);
}


void
on_tar_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

  gchar *tin_fol, *tout_fol, *tout_fname, *tout_fextn, *tparams, *tcommand;
  int check;

  tin_fol = g_malloc0 (100);
  tout_fol = g_malloc0 (100);
  tout_fname = g_malloc0 (50);
  tout_fextn = g_malloc0 (20);
  tparams = g_malloc0 (10);
  tcommand = g_malloc0 (250);

/*                Checking the integrity of all entries                */

  widget = lookup_widget(tar, "combo_entry5");
  tin_fol = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(tin_fol) == 0)
  {
    gtk_widget_show (create_msg_box("error", "Select an input folder"));
    return;
  }

  widget = lookup_widget(tar, "combo_entry6");
  tout_fol = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(tout_fol) == 0)
  {
    gtk_widget_show (create_msg_box("info", "Select an output path"));
    return;
  }

  widget = lookup_widget(tar, "entry19");
  tout_fname = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(tout_fname) == 0)
  {
    gtk_widget_show (create_msg_box("info", "Select a file name"));
    return;
  }

  widget = lookup_widget(tar, "combo_entry9");
  tout_fextn = gtk_entry_get_text(GTK_ENTRY(widget));

  if (GTK_TOGGLE_BUTTON(lookup_widget(tar, "radiobutton6"))->active)
    strcpy(tparams,"cvfz");
  else
    strcpy(tparams,"cvfI");	

/*                Generating the tar command                         */

  strcpy(tcommand, "tar ");
  strcat(tcommand, tparams);
  strcat(tcommand, " ");
  strcat(tcommand, tout_fol);
  strcat(tcommand, tout_fname);
  strcat(tcommand, tout_fextn);
  strcat(tcommand, " ");
  strcat(tcommand, tin_fol);

  check = system (tcommand);
  if(check == 0)
  {
    gtk_widget_show (create_msg_box("info", "Tar completed"));

    if (!(prefs.set.nolog))
    {
      logfname = g_malloc0 (100);
      logtime = g_malloc0 (50);

      strcpy(logfname, prefs.dir.logdir);
      strcat(logfname,"log.txt");
 
      if((logfp = fopen (logfname,"rb+")) == NULL)
        logfp = fopen (logfname,"wb");
    
      timeptr = time (NULL);
      tmptr = localtime(&timeptr);
  
      fseek (logfp, 0 , SEEK_END);
  
      fprintf (logfp, "%s%s", asctime (tmptr), "[Tar]");
      if(prefs.log.fpath) 
      {  
        fprintf (logfp, "\nInput Folder  :  %s", tin_fol);
        fprintf (logfp, "\nOutput File Path  :  %s", tout_fol);
      }
      if(prefs.log.fname)
        fprintf (logfp, "\nOutput File Name  :  %s%s\n\n", tout_fname, tout_fextn);

      fclose (logfp);
      return;
    }
  }

/*               To be commented for some time till I learn                  */
/*  else
  {
    gtk_widget_show (create_msg_box("error", "Tar can't complete process."));
    return;
  }*/
 
}


void
on_untar_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

  gchar *utin_file, *utout_fol, *utparams, *utcommand;
  int check;

  utin_file = g_malloc0 (100);
  utparams = g_malloc0 (10);
  utcommand = g_malloc0 (250);

/*                Checking the integrity of all entries                */

  widget = lookup_widget(untar, "combo_entry7");
  utin_file = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(utin_file) == 0)
  {
    gtk_widget_show (create_msg_box("error", "Select an input file"));
    return;
  }

  widget = lookup_widget(untar, "combo_entry8");
  utout_fol = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(utout_fol) == 0)
  {
    gtk_widget_show (create_msg_box("error", "Select an Output path"));
    return;
  }

  if (GTK_TOGGLE_BUTTON(lookup_widget(untar, "radiobutton8"))->active)
    strcpy(utparams,"xvfz");
  else
    strcpy(utparams,"xvfI");	


/*                Generating the tar command                         */

  strcpy(utcommand, "tar ");
  strcat(utcommand, utparams);
  strcat(utcommand, " ");
  strcat(utcommand, utin_file);
  strcat(utcommand, " ");
  strcat(utcommand, "-C");
  strcat(utcommand, " ");
  strcat(utcommand, utout_fol);

  check = system (utcommand);
  if(check == 0)
  {
    gtk_widget_show (create_msg_box("info", "Untar completed"));

    if (!(prefs.set.nolog))
    {
      logfname = g_malloc0 (100);
      logtime = g_malloc0 (50);

      strcpy(logfname, prefs.dir.logdir);
      strcat(logfname,"log.txt");
 
      if((logfp = fopen (logfname,"rb+")) == NULL)
        logfp = fopen (logfname,"wb");
    
      timeptr = time (NULL);
      tmptr = localtime(&timeptr);
  
      fseek (logfp, 0 , SEEK_END);
  
      fprintf (logfp, "%s%s", asctime (tmptr), "[Untar]");
      if(prefs.log.fpath) 
        fprintf (logfp, "\nOutput File Path  :  %s", utout_fol);
      if(prefs.log.fname)
        fprintf (logfp, "\nInput File Name  :  %s\n\n", utin_file);

      fclose (logfp);
      return;
    }
  }
  else
  {
    gtk_widget_show (create_msg_box("error", "Tar can't complete process. Check the compression selected"));
    return;
  }

}


void
on_tarcan_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy (tar);

}


void
on_untarcan_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy (untar);

}

void
on_tar_options_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  preferences = create_preferences ();
  gtk_widget_show (preferences);

}


void
on_save_settings_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  gfs_conf_write ();

}


void
on_default_settings_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  gfs_conf_default (&prefs);
  gfs_conf_default (&temprefs);

}


void
on_view_log_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  log = create_log ();
  gtk_widget_show (log);
  gfs_show_log(log);

}

void
on_clear_log_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 
  logfname = g_malloc0 (100);
  logtime = g_malloc0 (50);

  strcpy(logfname, prefs.dir.logdir);
  strcat(logfname,"log.txt");
 
  remove(logfname);

}

void
on_prefs_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  
  preferences = create_preferences ();
  gtk_widget_show (preferences);

}


void
on_doswin_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.set.doswin = !temprefs.set.doswin;

}


void
on_saveset_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.set.saveset = !temprefs.set.saveset;

}


void
on_nolog_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.set.nolog = !temprefs.set.nolog;

}


void
on_seplog_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.seplog = !temprefs.log.seplog;

}


void
on_samelog_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.samelog = !temprefs.log.samelog;

}


void
on_fpath_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.fpath = !temprefs.log.fpath;

}


void
on_fname_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.fname = !temprefs.log.fname;

}


void
on_fsize_toggled                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.fsize = !temprefs.log.fsize;

}


void
on_date_toggled                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.date = !temprefs.log.date;

}


void
on_spsize_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.spsize = !temprefs.log.spsize;

}


void
on_pieces_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.pieces = !temprefs.log.pieces;

}


void
on_errors_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  temprefs.log.error = !temprefs.log.error;

}


void
on_opdir_changed                       (GtkEditable     *editable,
                                        gpointer         user_data)
{

  g_free (temprefs.dir.opdir);
  temprefs.dir.opdir = NULL;
  temprefs.dir.opdir = g_strdup (gtk_editable_get_chars (editable, 0, -1));

}


void
on_logdir_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{

  g_free (temprefs.dir.logdir);
  temprefs.dir.logdir = NULL;
  temprefs.dir.logdir = g_strdup (gtk_editable_get_chars (editable, 0, -1));

}


void
on_scrdir_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{

  g_free (temprefs.dir.scrdir);
  temprefs.dir.scrdir = NULL;
  temprefs.dir.scrdir = g_strdup (gtk_editable_get_chars (editable, 0, -1));

}


void
on_pref_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{

  gfs_conf_copy (&prefs, &temprefs);
  gtk_widget_destroy (preferences);

}


void
on_pref_app_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  gfs_conf_copy (&prefs, &temprefs);
  
}


void
on_pref_can_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy (preferences);

}

void
on_close_log_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy (log);

}

