/*         gfs_conf.c - Configuration settings  -  S.Ekanth         */

#include "gfs_defs.h"
#include "gfs_conf.h"


void gfs_conf_init (void)
{

  gboolean def;
  gchar* homdir, *tmpdir;

  homdir = g_get_home_dir ();
  strcat (homdir, "/");
  tmpdir = g_get_tmp_dir ();
  strcat (tmpdir, "/");

/*                        Settings tab                             */

  prefs.set.doswin = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/settings/doswin=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/settings/doswin", prefs.set.doswin);

  prefs.set.saveset = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/settings/saveset=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/settings/saveset", prefs.set.saveset);

  prefs.set.nolog = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/settings/nolog=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/settings/nolog", prefs.set.nolog);

/*                        Directories tab                              */ 

  prefs.dir.opdir = gnome_config_private_get_string_with_default (g_strdup_printf ("gfslicer/directories/opdir=%s" ,homdir), &def);
  if (def) gnome_config_private_set_string ("gfslicer/directories/opdir", prefs.dir.opdir);

  prefs.dir.logdir = gnome_config_private_get_string_with_default (g_strdup_printf ("gfslicer/directories/logdir=%s" ,homdir), &def);
  if (def) gnome_config_private_set_string ("gfslicer/directories/logdir", prefs.dir.logdir);

  prefs.dir.scrdir = gnome_config_private_get_string_with_default (g_strdup_printf ("gfslicer/directories/scrdir=%s" ,tmpdir), &def);
  if (def) gnome_config_private_set_string ("gfslicer/directories/scrdir", prefs.dir.scrdir);

/*                         Logs tab                                     */

  prefs.log.samelog = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/samelog=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/samelog", prefs.log.samelog);

  prefs.log.seplog = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/seplog=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/seplog", prefs.log.seplog);

  prefs.log.fpath = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/fpath=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/fpath", prefs.log.fpath);

  prefs.log.fname = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/fname=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/seplog", prefs.log.fname);

  prefs.log.fsize = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/fsize=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/fsize", prefs.log.fsize);

  prefs.log.date = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/date=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/date", prefs.log.date);

  prefs.log.spsize = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/spsize=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/spsize", prefs.log.spsize);

  prefs.log.pieces = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/pieces=%s" ,"TRUE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/pieces", prefs.log.pieces);

  prefs.log.error = gnome_config_private_get_bool_with_default (g_strdup_printf ("gfslicer/logs/error=%s" ,"FALSE"), &def);
  if (def) gnome_config_private_set_bool ("gfslicer/logs/error", prefs.log.error);

  gnome_config_sync ();

}


void gfs_conf_write (void)
{

  gnome_config_private_set_bool ("gfslicer/settings/doswin", prefs.set.doswin);
  gnome_config_private_set_bool ("gfslicer/settings/saveset", prefs.set.saveset);
  gnome_config_private_set_bool ("gfslicer/settings/nolog", prefs.set.nolog);

  gnome_config_private_set_string ("gfslicer/directories/opdir", prefs.dir.opdir);
  gnome_config_private_set_string ("gfslicer/directories/logdir", prefs.dir.logdir);
  gnome_config_private_set_string ("gfslicer/directories/scrdir", prefs.dir.scrdir);

  gnome_config_private_set_bool ("gfslicer/logs/samelog", prefs.log.samelog);
  gnome_config_private_set_bool ("gfslicer/logs/seplog", prefs.log.seplog);
  gnome_config_private_set_bool ("gfslicer/logs/fpath", prefs.log.fpath);
  gnome_config_private_set_bool ("gfslicer/logs/seplog", prefs.log.fname);
  gnome_config_private_set_bool ("gfslicer/logs/fsize", prefs.log.fsize);
  gnome_config_private_set_bool ("gfslicer/logs/date", prefs.log.date);
  gnome_config_private_set_bool ("gfslicer/logs/spsize", prefs.log.spsize);
  gnome_config_private_set_bool ("gfslicer/logs/pieces", prefs.log.pieces);
  gnome_config_private_set_bool ("gfslicer/logs/error", prefs.log.error);

  gnome_config_sync ();

}


void gfs_conf_copy (gfs_prefs *old, gfs_prefs *new)
{  

  gfs_dir *direc;  

  old->set.doswin = new->set.doswin;
  old->set.saveset = new->set.saveset;
  old->set.nolog = new->set.nolog;


  direc = &(old->dir);
/*  g_free(direc->opdir);
  direc->opdir = NULL;*/
  if ((new->dir.opdir))
		direc->opdir = g_strdup (new->dir.opdir);

/*  g_free(direc->logdir);
  direc->logdir = NULL;*/
  if ((new->dir.logdir))
		direc->logdir = g_strdup (new->dir.logdir);

/*  g_free(direc->scrdir);
  direc->scrdir = NULL;*/
  if ((new->dir.scrdir))
		direc->scrdir = g_strdup (new->dir.scrdir);


  old->log.samelog = new->log.samelog;
  old->log.seplog = new->log.seplog;
  old->log.fpath = new->log.fpath;
  old->log.fname = new->log.fname;
  old->log.fsize = new->log.fsize;
  old->log.date = new->log.date;
  old->log.spsize = new->log.spsize;
  old->log.pieces = new->log.pieces;
  old->log.error = new->log.error;

}

void gfs_conf_default (gfs_prefs* pre)
{

  gchar* homdir, *tmpdir;

  homdir = g_get_home_dir ();
  tmpdir = g_get_tmp_dir ();

  pre->set.doswin = TRUE;
  pre->set.saveset = FALSE;
  pre->set.nolog = FALSE;

  pre->dir.opdir = homdir;
  pre->dir.logdir = homdir;
  pre->dir.scrdir = tmpdir;

  pre->log.samelog = TRUE;
  pre->log.seplog =FALSE;
  pre->log.fpath = TRUE;
  pre->log.fname = TRUE;
  pre->log.fsize = FALSE;
  pre->log.date = TRUE;
  pre->log.spsize = FALSE;
  pre->log.pieces = TRUE;
  pre->log.error = FALSE;

}