// $Id: adjustment.cc,v 1.18 2002/12/19 08:55:54 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "adjustment.hh"
#include "stringtok.h"

static Gtk_Adjustment Gtk_Adjustment;
//static Gtk_Adjustment hGtk_Adjustment('h');
//static Gtk_Adjustment vGtk_Adjustment('v');

const std::string Gtk_Adjustment::TypeName(const Widget &w) const
{  return GtkPrefix()+"Adjustment";
}

const std::string Gtk_Adjustment::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"adjustment.h";
}

Gtk_Adjustment::Gtk_Adjustment()
{  Writer["GtkAdjustment"]=this;
}

void Gtk_Adjustment::ConstructionArgs(const Widget &w, CxxFile &f) const
{  float value=0,lower=0,upper=100,step=1,page=10,page_size=10;
   if (w.hasProperty("adjustment"))
   {  std::list<std::string>  list;
      stringtok (list, w.getProperty("adjustment"));
      for (std::list<std::string>::iterator i = list.begin(); i != list.end(); ++i)
      {  f.FunctionArg() << (*i);
      }
   }
   else
   {  value=w.getFloatProperty("value",value);
      lower=w.getFloatProperty("lower",lower);
      upper=w.getFloatProperty("upper",upper);
      step=w.getFloatProperty("step",step);
      page=w.getFloatProperty("page",page);
      page_size=w.getFloatProperty("page_size",page_size);

   f.FunctionArg() << value;
   f.FunctionArg() << lower;
   f.FunctionArg() << upper;
   f.FunctionArg() << step;
   f.FunctionArg() << page;
   f.FunctionArg() << page_size;
   }
}
