// $Id: frame.cc,v 1.25 2002/10/24 10:40:59 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_Frame : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Frame();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
};

static Gtk_Frame Gtk_Frame;

const std::string Gtk_Frame::TypeName(const Widget &w) const
{  return GtkPrefix()+"Frame";
}

const std::string Gtk_Frame::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"frame.h";
}

Gtk_Frame::Gtk_Frame()
{  Writer["GtkFrame"]=this;
}

void Gtk_Frame::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   if (w.hasProperty("label"))
   {  const std::string label(w.getProperty("label"));
      if (!label.empty()) f << Configuration.Translatable(label);
   }
}

bool Gtk_Frame::NeedExplicitCtor(const Widget &w) const
{  return w.hasProperty("label") && !w.getProperty("label").empty(); }

void Gtk_Frame::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "shadow_type");
   WriteFloatFloatProperty(w,f,instance, "label_xalign", "label_yalign", "label_align", false, 0);
}

void Gtk_Frame::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  // at least two widgets are needed for the new style
   if (!Configuration.glade2 || w.begin()==w.end() || ++w.begin()==w.end()) 
   {  Parent::AddChildren(w,f,instance,writer_for_subw,widget_for_subw);
      return;
   }

   Widget::const_iterator label_item=w.begin();
   Widget::const_iterator i=w.begin();
   
   const ChildParamList ch((*i).get_Child_params());
   if (ch.getProperty("type")=="label_item") ++i;
   else ++label_item;
   
   if ((*i).Class()!="Placeholder") AddChild(*i,f,instance);
   
   if ((*label_item).Class()!="Placeholder") 
   {  f.Statement() << instance << "set_label_widget(" 
   		<< Reference(*label_item) << ")";
   }
}

