/******************************************************************************\
 gnofin/cached-string.h   $Revision: 1.1 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef CACHED_STRING_H
#define CACHED_STRING_H

/* CachedString objects are attached in alpha-numeric order */

typedef struct _CachedString CachedString;
typedef struct _StringCache  StringCache;

struct _StringCache
{
  GList *cache;
  guint  length;
};

struct _CachedString
{
  guint        ref_count;
  guint        attach_count;
  StringCache *parent;
  gchar       *string;
};

/* CachedString interface
 */
CachedString *cached_string_new		   (const gchar *string);
CachedString *cached_string_new_attached   (const gchar *string, StringCache *);
void	      cached_string_ref		   (CachedString *);
void	      cached_string_unref	   (CachedString *);
CachedString *cached_string_copy	   (CachedString *);
CachedString *cached_string_copy_and_unref (CachedString *);
CachedString *cached_string_attach	   (CachedString *, StringCache *);
void	      cached_string_detach	   (CachedString *);
void	      cached_string_set_string	   (CachedString *, const gchar *string);
gint          cached_string_index          (CachedString *);

CachedString *string_cache_find		   (StringCache *, const gchar *string);
GList        *string_cache_get_strings     (const StringCache *);
void          string_cache_dump            (const StringCache *, const gchar *label);

#endif

// vim: ts=8 sw=2
