/******************************************************************************\
 gnofin/dialogs.h   $Revision: 1.10 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef DIALOGS_H
#define DIALOGS_H

#include <gtk/gtkwindow.h>
#include <libgnomeui/gnome-messagebox.h>
#include "data-types.h"
#include "ui-types.h"

GNOFIN_API_BEGIN


/******************************************************************************
 * Modal message dialogs
 */

void dialog_message (GtkWindow *parent, const gchar *message_type, const gchar *message, ... );
#define dialog_notice(w, m...)   dialog_message(w?GTK_WINDOW(w):w, GNOME_MESSAGE_BOX_INFO, ##m)
#define dialog_warning(w, m...)  dialog_message(w?GTK_WINDOW(w):w, GNOME_MESSAGE_BOX_WARNING, ##m)
#define dialog_error(w, m...)    dialog_message(w?GTK_WINDOW(w):w, GNOME_MESSAGE_BOX_ERROR, ##m)


/*****************************************************************************
 * Modal question dialog
 */

/* return values */
#define DIALOG_NONE  -1   /* if the dialog is closed or an argument is invalid */
#define DIALOG_YES    0
#define DIALOG_NO     1
#define DIALOG_CANCEL 2

#define dialog_question(p,m) dialog_question_yes_no_cancel (p,m)
gint dialog_question_yes_no                  (GtkWindow *parent, const gchar *message);
gint dialog_question_yes_no_cancel           (GtkWindow *parent, const gchar *message);
gint dialog_question_yes_no_with_checkbutton (GtkWindow *parent, const gchar *message,
					      const gchar *chk_message, gboolean *chk_value);


/******************************************************************************
 * Modal file selection dialog
 */

typedef struct
{
  gchar    *label;       /* text label placed beside optmenu */
  GSList   *strings;     /* list of strings displayed in format selector */
  gint      selection;   /* -1 if no selection */

} FileFormatSelection;

gchar *dialog_query_filename (GtkWindow   *parent, 
			      const gchar *title, 
			      const gchar *default_filename,   // can be NULL
			      gboolean     overwrite_protect,
			      FileFormatSelection *format_selection);  // can be NULL


/******************************************************************************
 * Modal dialog for manipulating account properties
 */

/* returns bitmask indicating modified fields */
guint dialog_account_info (GtkWindow *parent, AccountInfo *info);


/******************************************************************************
 * About dialog
 */

void dialog_about   (GtkWindow *parent);


/******************************************************************************
 * Record type dialog for adding/deleting/modifying record types
 */

typedef struct {
  RecordTypeInfo info;        /* type info to be modified */
  RecordType    *type;        /* type pointer used as an identifier (NULL if none) */
  guint          mask;        /* indicates which fields have been changed */
  guint          remove : 1;  /* TRUE if record type should be removed */
} RecordTypeContext;

/* return value indicates whether data has changed */
gboolean dialog_edit_record_types (GtkWindow *parent, GSList **contexts);


/******************************************************************************
 * Dialog to order account
 */
guint dialog_order_account (GtkWindow *parent, UI *ui);

GNOFIN_API_END

#endif
