/******************************************************************************\
 gnofin/file-filter.c   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include "file-filter.h"

static GSList *import_filters = NULL;
static GSList *export_filters = NULL;
static guint   import_filters_stamp = 0;
static guint   export_filters_stamp = 0;

static gint
compare_labels (const FileFilter *a, const FileFilter *b)
{
  return strcmp (a->label, b->label);
}

void
file_filter_register (const FileFilter *f)
{
  trace ("");
  g_return_if_fail (f);
  g_return_if_fail (f->label);

  if (f->import)
  {
    import_filters =
      g_slist_insert_sorted (import_filters, (gpointer) f, (GCompareFunc) compare_labels);
    import_filters_stamp++;
  }

  if (f->export)
  {
    export_filters =
      g_slist_insert_sorted (export_filters, (gpointer) f, (GCompareFunc) compare_labels);
    export_filters_stamp++;
  }
}

void
file_filter_unregister (const FileFilter *f)
{
  trace ("");
  g_return_if_fail (f);

  if (f->import)
  {
    import_filters = g_slist_remove (import_filters, (gpointer) f);
    import_filters_stamp++;
  }

  if (f->export)
  {
    export_filters = g_slist_remove (export_filters, (gpointer) f);
    export_filters_stamp++;
  }
}

GSList *
file_import_filters_get (guint *stamp)
{
  trace ("");

  if (stamp) *stamp = import_filters_stamp;
  return import_filters;
}

GSList *
file_export_filters_get (guint *stamp)
{
  trace ("");

  if (stamp) *stamp = export_filters_stamp;
  return export_filters;
}

gboolean
file_import_filters_changed (guint stamp)
{
  trace ("");
  return (stamp < import_filters_stamp);
}

gboolean
file_export_filters_changed (guint stamp)
{
  trace ("");
  return (stamp < export_filters_stamp);
}
