/******************************************************************************\
 gnofin/gtk-auto-combo.h   $Revision: 1.1 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * GtkAutoCombo: Extends GtkCombo to include auto completion
 *
 * Author:
 *   Darin Fisher (dfisher@jagger.me.berkeley.edu)
 *
 */
#ifndef _GTK_AUTO_COMBO_H_
#define _GTK_AUTO_COMBO_H_

#include <gtk/gtkcombo.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* 
 * Assumptions: strings are sorted (case sensistive)
 */

#define GTK_AUTO_COMBO(obj)          GTK_AUTO_COMBO (obj, gtk_auto_combo_get_type (), GtkAutoCombo)
#define GTK_AUTO_COMBO_CLASS(klass)  GTK_AUTO_CLASS_CAST (klass, gtk_auto_combo_get_type (), GtkAutoComboClass)
#define GTK_IS_AUTO_COMBO(obj)       GTK_CHECK_TYPE (obj, gtk_auto_combo_get_type ())

typedef struct _GtkAutoCombo        GtkAutoCombo;
typedef struct _GtkAutoComboPrivate GtkAutoComboPrivate;
typedef struct _GtkAutoComboClass   GtkAutoComboClass;

struct _GtkAutoCombo
{
  GtkCombo combo;
};

struct _GtkAutoComboClass
{
  GtkComboClass parent_class;
};

GtkType    gtk_auto_combo_get_type (void);
GtkWidget *gtk_auto_combo_new      (void);

#ifdef __cplusplus
};
#endif /* __cplusplus */

#endif /* _GTK_AUTO_COMBO_H_ */
