/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtklevels.c,v 1.4 2001/01/20 19:40:11 dengen Exp $
 *
 */

#include <gtk/gtkmain.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkprogressbar.h>
#include <gtk/gtksignal.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtkvbox.h>
#include "gtklevels.h"


static void gtk_levels_class_init    (GtkLevelsClass *klass);
static void gtk_levels_finalize      (GtkObject *object);
static void gtk_levels_init          (GtkLevels *levels);

static GtkContainerClass *parent_class = NULL;

GtkType
gtk_levels_get_type (void)
{
    static GtkType levels_type = 0;

    if (!levels_type)
    {
	static const GtkTypeInfo levels_info =
	{
	    "GtkLevels",
	    sizeof (GtkLevels),
	    sizeof (GtkLevelsClass),
	    (GtkClassInitFunc) gtk_levels_class_init,
	    (GtkObjectInitFunc) gtk_levels_init,
	    NULL,
	    NULL,
	    (GtkClassInitFunc) NULL,
	};

	levels_type = gtk_type_unique (GTK_TYPE_VBOX, &levels_info);
    }

    return levels_type;
}

static void
gtk_levels_class_init (GtkLevelsClass *klass)
{
    GtkWidgetClass *widget_class;
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass *) klass;
    widget_class = (GtkWidgetClass *) klass;

    parent_class = gtk_type_class (GTK_TYPE_VBOX);

    object_class->finalize = gtk_levels_finalize;
}

static void
gtk_levels_finalize (GtkObject *object)
{
    GtkLevels *Levels;
    g_return_if_fail (object != NULL);
    g_return_if_fail (GTK_IS_LEVELS (object));
    
    Levels = GTK_LEVELS (object);
    
    GTK_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gtk_levels_init (GtkLevels *levels)
{
    GtkBox *box;

    box = GTK_BOX (levels);
    box->spacing = 0;
    box->homogeneous = FALSE;
    gtk_container_set_border_width(GTK_CONTAINER(box), 2);

    levels->ClipHBox = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (levels->ClipHBox);
    gtk_box_pack_start (box, levels->ClipHBox, FALSE, FALSE, 2);

    levels->LClip = gtk_toggle_button_new_with_label ("C");
    gtk_widget_show (levels->LClip);
    gtk_box_pack_start (GTK_BOX (levels->ClipHBox), levels->LClip, TRUE, TRUE, 0);
    gtk_widget_set_name(GTK_WIDGET(levels->LClip), "ClipMeter0");

    levels->RClip = gtk_toggle_button_new_with_label ("C");
    gtk_widget_show (levels->RClip);
    gtk_box_pack_start (GTK_BOX (levels->ClipHBox), levels->RClip, TRUE, TRUE, 0);
    gtk_widget_set_name(GTK_WIDGET(levels->RClip), "ClipMeter1");

    levels->MetersHBox = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (levels->MetersHBox);
    gtk_box_pack_start (box, levels->MetersHBox, TRUE, TRUE, 0);

    levels->LMeter = gtk_progress_bar_new ();
    gtk_widget_show (levels->LMeter);
    gtk_box_pack_start (GTK_BOX (levels->MetersHBox), levels->LMeter, TRUE, TRUE, 0);
    gtk_progress_configure (GTK_PROGRESS (levels->LMeter), 0, 0, 128);
    gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (levels->LMeter), GTK_PROGRESS_BOTTOM_TO_TOP);
    gtk_widget_set_name(GTK_WIDGET(levels->LMeter), "LevelMeter0");

    levels->RMeter = gtk_progress_bar_new ();
    gtk_widget_show (levels->RMeter);
    gtk_box_pack_start (GTK_BOX (levels->MetersHBox), levels->RMeter, TRUE, TRUE, 0);
    gtk_progress_configure (GTK_PROGRESS (levels->RMeter), 0, 0, 128);
    gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (levels->RMeter), GTK_PROGRESS_BOTTOM_TO_TOP);
    gtk_widget_set_name(GTK_WIDGET(levels->RMeter), "LevelMeter1");
}

GtkWidget*
gtk_levels_new (void)
{
    return GTK_WIDGET (gtk_type_new (gtk_levels_get_type ()));
}

void
gtk_levels_set_levels (GtkLevels *levels, guint8 l, guint8 r)
{
    g_return_if_fail (GTK_IS_LEVELS (levels));

    if (GTK_WIDGET_REALIZED (levels))
    {
	gfloat lpeak = (gfloat)0 + l;
	gfloat rpeak = (gfloat)0 + r;

	gtk_progress_set_value (GTK_PROGRESS (levels->LMeter), lpeak);
	gtk_progress_set_value (GTK_PROGRESS (levels->RMeter), rpeak);
    }
}

void
gtk_levels_set_clip (GtkLevels *levels, guint8 channel)
{
    if (channel == 0)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (levels->LClip), TRUE);
    else if (channel == 1)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (levels->RClip), TRUE);
}
