/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgtkpacker.c -

  $Author: mutoh $
  $Date: 2002/07/20 13:29:15 $

  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/

#include "global.h"

static VALUE
packer_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_packer_new()); 
    return Qnil;
}

static VALUE
packer_add(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE child, side, anchor;
    VALUE arg0, arg1, arg2, arg3, arg4, arg5;
    int options, border_width, pad_x, pad_y, i_pad_x, i_pad_y;

    options = border_width = pad_x = pad_y = i_pad_x = i_pad_y = 0;

    rb_scan_args(argc, argv, "36", 
		&child, &side, &anchor, &arg0,
		&arg1, &arg2, &arg3, &arg4, &arg5);
    if (!NIL_P(arg0)) options = NUM2INT(arg0);
    if (!NIL_P(arg1)) border_width = NUM2INT(arg1);
    if (!NIL_P(arg2)) pad_x = NUM2INT(arg2);
    if (!NIL_P(arg3)) pad_y = NUM2INT(arg3);
    if (!NIL_P(arg4)) i_pad_x = NUM2INT(arg4);
    if (!NIL_P(arg5)) i_pad_y = NUM2INT(arg5);

    gtk_packer_add(GTK_PACKER(get_widget(self)),
		    get_widget(child),
		    NUM2INT(side), NUM2INT(anchor),
		    options, border_width, 
		    pad_x, pad_y, 
		    i_pad_x, i_pad_y);
    return self;
}

static VALUE
packer_reorder_child(self, child, pos)
    VALUE self;
    VALUE child;
    VALUE pos;
{
    gtk_packer_reorder_child(GTK_PACKER(get_widget(self)),
    		             get_widget(child),
			     NUM2INT(pos));
    return self;
}

static VALUE
packer_set_spacing(self, spacing)
    VALUE self;
    VALUE spacing;
{
    gtk_packer_set_spacing(GTK_PACKER(get_widget(self)),
		           NUM2INT(spacing));
	
    return self;
}

static VALUE
packer_set_default_border_width(self, border)
    VALUE self;
    VALUE border;
{
    gtk_packer_set_default_border_width(GTK_PACKER(get_widget(self)),
		    			NUM2INT(border));
	
    return self;
}

static VALUE
packer_set_default_pad(self, pad_x, pad_y)
    VALUE self;
    VALUE pad_x;
    VALUE pad_y;
{
    gtk_packer_set_default_pad(GTK_PACKER(get_widget(self)),
		    	       NUM2INT(pad_x),
			       NUM2INT(pad_y));
	
    return self;
}

static VALUE
packer_set_default_ipad(self, i_pad_x, i_pad_y)
    VALUE self;
    VALUE i_pad_x;
    VALUE i_pad_y;
{
    gtk_packer_set_default_pad(GTK_PACKER(get_widget(self)),
		    	       NUM2INT(i_pad_x),
			       NUM2INT(i_pad_y));
	
    return self;
}
static VALUE
packer_set_child_packing(self, child, side, anchor, options, border, pad_x, pad_y, i_pad_x, i_pad_y)
    VALUE self;
    VALUE child;
    VALUE side;
    VALUE anchor;
    VALUE options;
    VALUE border;
    VALUE pad_x;
    VALUE pad_y;
    VALUE i_pad_x;
    VALUE i_pad_y;
{
    gtk_packer_set_child_packing(
      GTK_PACKER(get_widget(self)),
      get_widget(child),
      NUM2INT(side), NUM2INT(anchor),
      NUM2INT(options), NUM2INT(border),
      NUM2INT(pad_x), NUM2INT(pad_y),
      NUM2INT(i_pad_x), NUM2INT(i_pad_y)
    );
    return self;
}

void Init_gtk_packer()
{
    gPacker = rb_define_class_under(mGtk, "Packer", gContainer);

    rb_define_method(gPacker, "initialize", packer_initialize, 0);
    rb_define_method(gPacker, "add", packer_add, -1);
    rb_define_method(gPacker, "reorder_child", packer_reorder_child, 2);
    rb_define_method(gPacker, "set_spacing", packer_set_spacing, 1);
    rb_define_method(gPacker, "set_default_border_width", packer_set_default_border_width, 1);
    rb_define_method(gPacker, "set_default_pad", packer_set_default_pad, 2);
    rb_define_method(gPacker, "set_default_ipad", packer_set_default_ipad, 2);
    rb_define_method(gPacker, "set_child_packing", packer_set_child_packing, 9);

}
