#!/usr/bin/perl -T
#####################################################
#  gnudip2.cgi           Part of GnuDIP 2.1.1       #
#                                                   #
#    GnuDIP Web Tool                                #
#                                                   #
#    See COPYING for licensing information          #
#                                                   #
#       Mike Machado <mike@innercite.com>           #
#                                                   #
#####################################################

  #### Load needed modules
  use DBI;
  use CGI;
  use MD5;
  use strict;
  my ($sth, $mons, $nummon, $printheader, $remote_ip);
  require 'gnudip-lib.pl';

  #### Set up variables
  my $gnudip2user = readconf('gnudipuser');
  my $gnudip2pass = readconf('gnudippassword');
  my $gnudip2server = readconf('gnudipserver');

  my $title = "GnuDIP2 Web Interface - Version 2.1.1";
  my $body = "<body bgcolor=\"FFFFFF\">";


  #### Contruct new handlers
  my $query = new CGI;
  my $dbh = DBI->connect("DBI:mysql:gnudip2:$gnudip2server", $gnudip2user, $gnudip2pass);
  my $thiscgi = $query->url();


  # Fix for web caches (squid), but only works if cache uses the forwarded-for option
  if ($ENV{'HTTP_X_FORWARDED_FOR'} && $ENV{'HTTP_X_FORWARDED_FOR'} ne "unknown") {
    $remote_ip = $ENV{'HTTP_X_FORWARDED_FOR'};
  } else {
    $remote_ip = $ENV{'REMOTE_ADDR'};
  }

  my ($ipa, $ipb, $ipc, $ipd) = split(/\./, $remote_ip);
  if (!(isoctet($ipa) && isoctet($ipb) && isoctet($ipc) && isoctet($ipd))) {
    $remote_ip = "0.0.0.0";
  }
    

#############################################################
#  do_signup                                                #
#                                                           #
#    Adds a new user to the database from the self          #
#    signup page                                            #
#                                                           #
#############################################################
if ($query->param("do_signup") ne "") {

    header();
    $printheader = "no";
    my $pref = getprefs();

    $sth = $dbh->prepare("select domain, addself from domains");
    $sth->execute;
    my $found = 0;
    my $pickedaddself;
    $found = 1 if $query->param('new_domain') eq $$pref{'GNUDIP_DOMAIN'};
    while (my ($domain, $addself) = $sth->fetchrow_array) {
      $found = 1 if $domain eq $query->param('new_domain');
      $pickedaddself = $addself;
      last if $domain eq $query->param('new_domain');
    }
    $sth->finish;
    $pickedaddself = 'YES' if $query->param('new_domain') eq $$pref{'GNUDIP_DOMAIN'} && $$pref{'ADD_SELF'} eq 'YES';
    error('unknown_dom') if !$found;
    error('no_add_self') if $pickedaddself ne 'YES';

    my @restricted = split(/\,/, $$pref{'RESTRICTED_USERS'});
    my $check;
    foreach my $baduser (@restricted) {
      $check = $baduser;
      $check =~ s/\*/\(\.\*\)/g;
      $check =~ s/\?/\(\.\?\)/g;
      error("restricted_user") if $query->param("new_username") =~ /^$check\b/;
    } 

    my $testuser = $query->param("new_username");
    $testuser =~ s/ //g;
    error("no_spaces") if $testuser ne $query->param("new_username") || $query->param("new_username") eq '';

    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
        $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."
\" and level = \"ADMIN\"");
        $sth->execute;
        my ($check) = $sth->fetchrow_array;
        error("restricted_user") if $check ne "";
        $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\" and domain = \"".$query->param('new_domain')."\"");
    } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
        $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\"");
    }
    $sth->execute;
    my ($check) = $sth->fetchrow_array;
    error("user_exists") if $check ne "";
    checkchars("new_username","new_password","new_password1"); 
    if ($query->param("new_password") ne $query->param("new_password1")) {
      error("not_same");
    }
    my $encpass = md5sum($query->param('new_password'));
    my $domain = $query->param("new_domain");
    $domain = '' if $$pref{'DOMAIN_TYPE'} eq 'GLOBAL';
    $sth = $dbh->do("insert into users values \(\"\",\"".$query->param("new_username")."\",\"$encpass\",\"$domain\",\"".$query->param("new_email")."\",NOW(),\"\",NOW(),\"USER\",\"0.0.0.0\",\"NO\"\)");

    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<br><center><h1>".font("black:4:arial","Registration Successful")."</h1></center>\n";
    print "<br><center><p>".font("black:2:arial","You may now log in the the GnuDIP server <a href=\"$thiscgi\">HERE</a>")."</p></center>\n";

    exit;
    

#############################################################
#  save_settings                                            #
#                                                           #
#    Saves the system settings back to the database         #
#                                                           #
#############################################################
} elsif ($query->param("save_settings") ne "") {


    header();
    $printheader = "no";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    $query->param("ALLOW_CHANGE_PASS", "NO") if $query->param("ALLOW_CHANGE_PASS") ne "YES";
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ALLOW_CHANGE_PASS")."\" where param = \"ALLOW_CHANGE_PASS\"");
    $query->param("ALLOW_CHANGE_HOSTNAME", "NO") if $query->param("ALLOW_CHANGE_HOSTNAME") ne "YES";
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ALLOW_CHANGE_HOSTNAME")."\" where param = \"ALLOW_CHANGE_HOSTNAME\"");
    $query->param("ADD_SELF", "NO") if $query->param("ADD_SELF") ne "YES";
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ADD_SELF")."\" where param = \"ADD_SELF\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("GNUDIP_DOMAIN")."\" where param = \"GNUDIP_DOMAIN\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ZONEFILE")."\" where param = \"ZONEFILE\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ZONETYPE")."\" where param = \"ZONETYPE\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("NDC_PATH")."\" where param = \"NDC_PATH\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("RESTRICTED_USERS")."\" where param = \"RESTRICTED_USERS\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("COOKIE_DOMAIN")."\" where param = \"COOKIE_DOMAIN\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("HEADER_FILE")."\" where param = \"HEADER_FILE\"");
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("DOMAIN_TYPE")."\" where param = \"DOMAIN_TYPE\"");
    $query->param("SHOW_DOMAINLIST", "NO") if $query->param("SHOW_DOMAINLIST") ne "YES";
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("SHOW_DOMAINLIST")."\" where param = \"SHOW_DOMAINLIST\"");
    $query->param("ALLOW_CHANGE_DOMAIN", "NO") if $query->param("ALLOW_CHANGE_DOMAIN") ne "YES";
    $sth = $dbh->do("update globalprefs set value = \"".$query->param("ALLOW_CHANGE_DOMAIN")."\" where param = \"ALLOW_CHANGE_DOMAIN\"");

    $query->param("login", "NOT NULL");


#############################################################
#  do_adddomain                                             #
#                                                           #
#    Adds a new domain to the database                      #
#                                                           #
#############################################################
} elsif ($query->param("do_adddomain") ne "") {

    header();
    my $pref = getprefs();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    error("not_admin") if $level ne "ADMIN";

    $sth = $dbh->prepare("select id from domains where domain = \"".$query->param("new_domain")."\"");
    $sth->execute;
    my ($check) = $sth->fetchrow_array;
    error('domain_exists') if $check;
    
    $query->param('ALLOW_CHANGEPASS', 'NO') if $query->param('ALLOW_CHANGEPASS') ne 'YES';
    $query->param('ADDSELF', 'NO') if $query->param('ADDSELF') ne 'YES';
    $sth = $dbh->do("insert into domains values \(\"\",\"".$query->param("new_domain")."\",\"".$query->param('new_zonefile')."\",\"".$query->param('new_zonetype')."\",\"".$query->param("ALLOW_CHANGEPASS")."\",\"".$query->param('ADDSELF')."\"\)");

    $query->param("managedomains_main","NOT NULL");



#############################################################
#  do_adduser                                               #
#                                                           #
#    Adds a new user to the database                        #
#                                                           #
#############################################################
} elsif ($query->param("do_adduser") ne "") {

    header();
    my $pref = getprefs();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    error("not_admin") if $level ne "ADMIN";

    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."
\" andlevel = \"ADMIN\"");
       $sth->execute;
       my ($check) = $sth->fetchrow_array;
       error("restricted_user") if $check ne "";
       $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\" and domain = \"".$query->param('new_domain')."\"");
      $sth->execute;
       my ($check) = $sth->fetchrow_array;
       error('user_exists') if $check;
    } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
       $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\"");
       $sth->execute;
       my ($check) = $sth->fetchrow_array;
       error('user_exists') if $check;
    }

    checkchars("new_username","new_password","new_password1"); 
    checkfirstlast($query->param("new_username"));
    if ($query->param("new_password") ne $query->param("new_password1")) {
      error("not_same");
    }
    my $encpass = md5sum($query->param("new_password"));
    my $userlevel = $query->param("user_level") || "USER";
    my $domain = $query->param("new_domain");
    $domain = '' if $$pref{'DOMAIN_TYPE'} eq 'GLOBAL';
    $sth = $dbh->do("insert into users values \(\"\",\"".$query->param("new_username")."\",\"$encpass\",\"$domain\",\"".$query->param("new_email")."\",NOW(),\"\",NOW(),\"$userlevel\",\"0.0.0.0\",\"NO\"\)");

    $query->param("manageusers_main","NOT NULL");



#############################################################
#  removeautourl                                            #
#                                                           #
#    Deletes the auto URL cookie and returns to main menu   #
#                                                           #
#############################################################
} elsif ($query->param("removeautourl") ne "") {

   my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
 
   my $pref = getprefs();
   my $cookiedomain = $$pref{'COOKIE_DOMAIN'};
   my ($cookie1, $cookie2, $cookie3);
   $cookie1 = $query->cookie(-name=>'gnudip2user',
                        -value=>'',
                        -expires=>'-1s',
                        -path=>'/',
                        -domain=>$cookiedomain);
   $cookie2 = $query->cookie(-name=>'gnudip2pass',
                        -value=>'',
                        -expires=>'-1s',
                        -path=>'/',
                        -domain=>$cookiedomain);
   $cookie3 = $query->cookie(-name=>'gnudip2domain',
                        -value=>'',
                        -expires=>'-1s',
                        -path=>'/',
                        -domain=>$cookiedomain);
   print $query->header(-cookie=>[$cookie1, $cookie2, $cookie3]);

   #FIXME: need new domain_type stuff here
   $sth = $dbh->do("update users set autourlon = \"NO\" where username = \"".$query->param("username")."\"");

    $query->param("login","NOT NULL");
    $printheader = "no";

#############################################################
#  updatehost                                               #
#                                                           #
#    Writes an entry into the queue for MODIFY              #
#                                                           #
#############################################################
} elsif ($query->param("updatehost") ne "") {

    my $pref = getprefs();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       $sth = $dbh->do("update users set currentip = \"$remote_ip\", updated = NOW() where username = \"".$query->param("username")."\" and domain = \"".$query->param("domain")."\"");
       $sth = $dbh->prepare("select id from queue where hostname = \"".$query->param("username")."\" and domain = \"".$query->param("domain")."\"");
    } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
       $sth = $dbh->do("update users set currentip = \"$remote_ip\", updated = NOW() where username = \"".$query->param("username")."\"");
       $sth = $dbh->prepare("select id from queue where hostname = \"".$query->param("username")."\"");
    }
    $sth->execute;
    my ($checkqueue) = $sth->fetchrow_array;
    checkchars("username");
    my $domain = '';
    $domain = $query->param('domain') if $$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL';
    if (!$checkqueue) {
      $sth = $dbh->do("insert into queue values \(\"\",\"".$query->param("username")."\",\"$domain\",\"$remote_ip\",\"MODIFY\"\)");
    } else {
      $sth = $dbh->do("update queue set domain = \"$domain\", ipaddress = \"$remote_ip\", action = \"MODIFY\" where id = \"$checkqueue\"");
    }
    $query->param("login","NOT NULL");


#############################################################
#  offline                                                  #
#                                                           #
#    Writes an entry into the queue for REMOVE              #
#                                                           #
#############################################################
} elsif ($query->param("offline") ne "") {

    my $pref = getprefs();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    $sth = $dbh->do("update users set currentip = \"0.0.0.0\", updated = NOW() where username = \"".$query->param("username")."\"");
    $sth = $dbh->prepare("select id from queue where hostname = \"".$query->param("username")."\"");
    $sth->execute;
    my $checkqueue = $sth->fetchrow_array;
    checkchars("username");
    my $domain = '';
    $domain = $query->param('domain') if $$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL';
    if ($checkqueue eq "") {
      $sth = $dbh->do("insert into queue values \(\"\",\"".$query->param("username")."\",\"$domain\",\"$remote_ip\",\"REMOVE\"\)");
    } else {
      $sth = $dbh->do("update queue set domain = \"$domain\", ipaddress = \"$remote_ip\", action = \"REMOVE\" where hostname = \"".$query->param("username")."\"");
    }
    $query->param("login","NOT NULL");


#############################################################
#  do_deldomain                                             #
#                                                           #
#    Delete the selected domainss from the database         #
#                                                           #
#############################################################
} elsif ($query->param("do_deldomain") ne "") {

    header();
    my $pref = getprefs();
    $printheader = "no";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";

    foreach my $delid ($query->param("domid")) {
      $sth = $dbh->do("delete from domains where id = \"$delid\"");
    }

    $query->param("managedomains_main","NOT NULL");


#############################################################
#  do_deluser                                               #
#                                                           #
#    Delete the selected users from the database            #
#                                                           #
#############################################################
} elsif ($query->param("do_deluser") ne "") {

    header();
    my $pref = getprefs();
    $printheader = "no";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";

    foreach my $delid ($query->param("userid")) {
      $sth = $dbh->prepare("select username, domain from users where id = \"$delid\"");
      $sth->execute;
      my ($deluid, $deldom) = $sth->fetchrow_array;
      $sth = $dbh->do("delete from users where id = \"$delid\"");
      if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
         $sth = $dbh->do("delete from queue where hostname = \"$deluid\" and domain = \"$deldom\"");
         $sth = $dbh->do("insert into queue values \(\"\", \"$deluid\", \"$deldom\", \"0.0.0.0\", \"REMOVE\"\)");
      } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
         $sth = $dbh->do("delete from queue where hostname = \"$deluid\"");
         $sth = $dbh->do("insert into queue values \(\"\", \"$deluid\", \"\", \"0.0.0.0\", \"REMOVE\"\)");
      }
    }

    $query->param("manageusers_main","NOT NULL");




#############################################################
#  do_editdomain                                            #
#                                                           #
#    Writes the changes back about the selected domain      #
#                                                           #
#############################################################
} elsif ($query->param("do_editdomain") ne "") {

    header();
    $printheader = "no";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";


   if ($query->param('ADDSELF') ne 'YES') {
     $query->param('ADDSELF','NO');
   }

   if ($query->param('ALLOW_CHANGEPASS') ne 'YES') {
     $query->param('ALLOW_CHANGEPASS','NO');
   }

   #### Now that weve checked everything, do the update
   my $sql = "update domains set domain = \"".$query->param('new_domain')."\", zonefile = \"".$query->param('new_zonefile')."\", zonetype = \"".$query->param('new_zonetype')."\", changepass = \"".$query->param('ALLOW_CHANGEPASS')."\", addself = \"".$query->param('ADDSELF')."\" where id = \"".$query->param('editdomid')."\"";
   $sth = $dbh->do($sql);
   
   $query->param("managedomains_main","NOT NULL");


#############################################################
#  do_edituser                                              #
#                                                           #
#    Writes the changes by admins back to the users record  #
#                                                           #
#############################################################
} elsif ($query->param("do_edituser") ne "") {

    header();
    $printheader = "no";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
   
    $sth = $dbh->prepare("select * from users where id = \"".$query->param("edituserid")."\"");
    $sth->execute;
    my @userinfo = $sth->fetchrow_array;

   my $pref = getprefs();
   my @restricted = split(/\,/, $$pref{'RESTRICTED_USERS'});
   my $check;
   foreach my $baduser (@restricted) {
      $check = $baduser;
      $check =~ s/\*/\(\.\*\)/g;
      $check =~ s/\?/\(\.\?\)/g;
      error("restricted_user") if $query->param("new_username") =~ /^$check\b/;
   }

   if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
      if ($userinfo[1] ne $query->param("new_username") || $userinfo[3] ne $query->param('new_domain')) {
        $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\" and domain = \"".$query->param('new_domain')."\"");
        $sth->execute;
        my ($check) = $sth->fetchrow_array;
        error('user_exists') if $check;
        $sth = $dbh->do("insert into queue values \(\"\",\"$userinfo[1]\",\"$userinfo[3]\",\"0.0.0.0\",\"REMOVE\"\)");
      }
   } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
      if (!($userinfo[1] eq $query->param("new_username"))) {
        $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\"");
        $sth->execute;
        my ($check) = $sth->fetchrow_array;
        error('user_exists') if $check;
        $sth = $dbh->do("insert into queue values \(\"\",\"$userinfo[1]\",\"",\"0.0.0.0\",\"REMOVE\"\)");
      }
   }


   checkchars("new_username","new_password","new_password1"); 
   checkfirstlast($query->param("new_username"));
   if ($query->param("new_password") ne $query->param("new_password1")) {
      header();
      error("not_same");
   }

   my $newencpass;
   if ($query->param("new_password") eq "") {
      $newencpass = md5sum($userinfo[2]);
   } else {
      $newencpass = md5sum($query->param("new_password"));
   }
   
   my $LEVEL;
   if ($query->param("user_level") eq "ADMIN") {
      $LEVEL = "ADMIN";
   } else {
      $LEVEL = "USER";
   }
   #### Now that weve checked everything, do the update
   my $sql = "update users set username = \"".$query->param("new_username")."\", domain = \"".$query->param('new_domain')."\", email = \"".$query->param('new_email')."\", forwardurl = \"".$query->param('new_forwardurl')."\", password = \"$newencpass\", level = \"$LEVEL\" where id = \"$userinfo[0]\"";
   $sth = $dbh->do($sql);
   
   $query->param("manageusers_main","NOT NULL");



#############################################################
#  do_updatesettings                                        #
#                                                           #
#    Writes users change back                               #
#                                                           #
#############################################################
} elsif ($query->param("do_updatesettings") ne "") {

    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    my $pref = getprefs();
   

    $sth = $dbh->prepare("select domain, changepass from domains");
    $sth->execute;
    my $found = 0;
    $found = 1 if $$pref{'DOMAIN_TYPE'} eq 'GLOBAL';
    $found = 1 if $query->param('new_domain') eq $$pref{'GNUDIP_DOMAIN'};
    my $domain = '';
    my $pickedchangepass = 'NO';
    my $changepass = 'NO';
    while (($domain, $changepass) = $sth->fetchrow_array) {
      $found = 1 if $domain eq $query->param('new_domain');
      $pickedchangepass = $changepass;
      last if $domain eq $query->param('new_domain');
    }
    $sth->finish;
    $pickedchangepass = $$pref{'ALLOW_CHANGE_PASS'} if $query->param('new_domain') eq $$pref{'GNUDIP_DOMAIN'};
    error('unknown_dom') if !$found;

    if($pickedchangepass ne 'YES' && $level ne 'ADMIN') {
      if ($query->param("new_password") ne '' && $query->param("new_password1") ne '') {
        header();
        error("no_changepass");
      }
    } else {
      checkchars("new_password","new_password1"); 
      if ($query->param("new_password") ne $query->param("new_password1")) {
        header();
        error("not_same");
      }
    }

    my @restricted = split(/\,/, $$pref{'RESTRICTED_USERS'});
    header();
    my $check;
    foreach my $baduser (@restricted) {
      $check = $baduser;
      $check =~ s/\*/\(\.\*\)/g;
      $check =~ s/\?/\(\.\?\)/g;
      error("restricted_user") if $query->param("new_username") =~ /^$check\b/;
    }

    if ($query->param("new_password") eq "") {
       $query->param("new_password", $query->param("password"));
    }


   my $changeduser = 0;
   if ($query->param("username") ne $query->param("new_username")) {
     $changeduser = 1;
     checkchars("new_username");
     checkfirstlast($query->param("new_username"));
     error("no_changehostname") if $$pref{'ALLOW_CHANGE_HOSTNAME'} eq 'NO' && $level ne 'ADMIN';
     if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
         $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\" and (domain = \"".$query->param("new_domain")."\" or domain = \"\") and username != \"".$query->param("username")."\"");
     } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
         $sth = $dbh->prepare("select id from users where username = \"".$query->param("new_username")."\" and username != \"".$query->param("username")."\"");
     }
     $sth->execute;
     my ($check) = $sth->fetchrow_array;
     error("user_exists") if $check ne '';

     $sth = $dbh->do("delete from queue where hostname = \"".$query->param("username")."\" and domain = \"".$query->param("domain")."\"");
     $sth = $dbh->do("insert into queue values \(\"\",\"".$query->param("username")."\",\"".$query->param("domain")."\",\"0.0.0.0\",\"REMOVE\"\)");
   }        
  
   my $newdomain = '';
   $newdomain = $query->param("new_domain") if $$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL';

   if ($newdomain ne $query->param("domain")) {

     $sth = $dbh->do("delete from queue where hostname = \"".$query->param("username")."\" and domain = \"".$query->param("domain")."\"") if !$changeduser;
     $sth = $dbh->do("insert into queue values \(\"\",\"".$query->param("username")."\",\"".$query->param("domain")."\",\"0.0.0.0\",\"REMOVE\"\)") if !$changeduser;
   }

   #### Now that weve checked everything, do the update
   my $newencpass = md5sum($query->param("new_password"));
   my $sql = "update users set username = \"".$query->param("new_username")."\", email = \"".$query->param("new_email")."\", domain = \"$newdomain\", password = \"$newencpass\", forwardurl = \"".$query->param("forwardurl")."\" where username = \"".$query->param("username")."\"";
   $sth = $dbh->do($sql);
   
   $query->param("changesettings","NOT NULL");
   $query->param("username", $query->param("new_username"));
   $query->param("password", $query->param("new_password"));
   $query->param("domain", $query->param("new_domain"));


#############################################################
#  getautourlinfo                                           #
#                                                           #
#    Retreive autoURL info and chage the users IP           #
#    and redirect them to their homepage                    #
#                                                           #
#############################################################
} elsif ($query->param("action") eq "getautourlinfo") {

    my $cookieuser = $query->cookie("gnudip2user");
    my $cookiepass = $query->cookie("gnudip2pass");
    my $cookiedomain = $query->cookie("gnudip2domain");
    if ($cookieuser eq "") {
      header();
      error("no_cookie");
    } else {
      $sth = $dbh->prepare("select username, domain, password, forwardurl, autourlon from users where username = \"$cookieuser\"");
      $sth->execute;
      my ($dbusername, $dbdomain, $dbpassword, $dbforwardurl, $dbautourlon) = $sth->fetchrow_array;
      if ($cookiepass ne $dbpassword || $dbusername eq "") {
        header();
        print "<html><head><title>Error!</title></head>$body\n";
        print "<br><center><h1>Error: Invalid Login</h1></center>\n";
        print "<br><p>The cookie passed by your browser contained an invalid username and/or password. Perhaps you did not reset your cookie after you changed your password.</p>";
      } elsif ($dbautourlon eq "YES") {
        # Redirect to their chosen page
       $sth = $dbh->do("delete from queue where hostname = \"$dbusername\" and domain = \"$dbdomain\"");
       $sth = $dbh->do("insert into queue values \(\"\",\"$dbusername\",\"$dbdomain\",\"$remote_ip\",\"MODIFY\"\)");
       $sth = $dbh->do("update users set currentip = \"$remote_ip\", updated = NOW() where username = \"$dbusername\" and domain = \"$dbdomain\"");
       if ($dbforwardurl eq '') {
         header();
         error("no_forwardurl");
       }
        print $query->redirect($dbforwardurl);
      } else {
       $sth = $dbh->do("delete from queue where hostname = \"$dbusername\" and domain = \"$dbdomain\"");
       $sth = $dbh->do("insert into queue values \(\"\",\"$dbusername\",\"$dbdomain\",\"$remote_ip\",\"MODIFY\"\)");
       $sth = $dbh->do("update users set autourlon = \"YES\", currentip = \"$remote_ip\", updated = NOW() where username = \"$dbusername\" and domain = \"$dbdomain\"");
       header();
       print "<html><head><title>Success</title></head>$body\n";
       print "<br><center><h1>Auto Update Successfull</h1></cener>\n";
       print "<p align=left>Your username and password were verified and your hostname now points to your new IP <i>$remote_ip</i>. Set this page as your default page and from now on it will automatically forward you to your Forward URL under the settings menu.</p>";
      }
    }
   exit;


}



#############################################################
#  signup                                                   #
#                                                           #
#    Print out self regsitration page                       #
#                                                           #
#############################################################
if ($query->param("action") eq "signup") {

    header();
    my $pref = getprefs();
    error("no_add_self") if $$pref{'ADD_SELF'} ne "YES";
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<br><center><h1>".font("black:4:arial","Self Registration")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Username")."</td><td><input type=\"text\" name=\"new_username\"></td></tr>\n";
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
      if ($$pref{'SHOW_DOMAINLIST'} eq 'YES') {
        print "<tr><td>".font("black:2:arial","Domain")."</td><td>";
        $sth = $dbh->prepare("select domain from domains");
        $sth->execute;
        my @domains = ($$pref{'GNUDIP_DOMAIN'});
        while (my ($dom) = $sth->fetchrow_array) {
          push(@domains, $dom);
        }
        print $query->scrolling_list(-name=>'new_domain', -values=>[@domains], -size=>1);
        print "</td></tr>\n";
      } else {
        print "<tr><td>".font("black:2:arial","Domain")."</td><td><input type=\"text\" name=\"new_domain\"></td></tr>\n";
      }
    }
    print "<tr><td>".font("black:2:arial","E-Mail Address")."</td><td><input type=\"text\" name=\"new_email\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password")."</td><td><input type=\"password\" name=\"new_password\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password Again")."</td><td><input type=\"password\" name=\"new_password1\"></td></tr>\n";
    print "</table></center>\n";
    print "<br><center><input type=\"submit\" name=\"do_signup\" value=\"Register\">\&nbsp\;<input type=reset value=\"Clear Form\"></center>\n";
    print "</form></body></html>\n";



#############################################################
#  system_setting                                           #
#                                                           #
#    Print out the systems settings page for admins         #
#                                                           #
#############################################################
} elsif ($query->param("system_settings") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<br><center><h1>".font("black:4:arial","System Settings")."</h1></center>\n";
    my $pref = getprefs();
    print "<form action=\"$thiscgi\" method=post>\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<br>\n";
    print "<center><table border=1>\n";
    my $CHECKED;
    if ($$pref{'ALLOW_CHANGE_PASS'} eq 'YES') {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr align=center><td align=left>Allow users to change their own password<br>";
    print "<blockquote><i>If this is set only the administrators can change the passwords for the users</i></blockquote></td><td width=40 valign=middle><input type=checkbox name=\"ALLOW_CHANGE_PASS\" value=\"YES\" $CHECKED></td>\n";
    if ($$pref{'ALLOW_CHANGE_HOSTNAME'} eq 'YES') {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr align=center><td align=left>Allow users to change their own hostname/username<br>";
    print "<blockquote><i>If this is set only the administrators can change the hostname/username of the accounts</i></blockquote></td><td width=40 valign=middle><input type=checkbox name=\"ALLOW_CHANGE_HOSTNAME\" value=\"YES\" $CHECKED></td>\n";

    if ($$pref{'ADD_SELF'} eq 'YES') {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr align=center><td align=left>Allow self registration<br>";
    print "<blockquote><i>If this is set people can register themselves into your dynamic DNS system using this URL: $thiscgi\?action=signup</i></blockquote></td><td width=40 valign=middle><input type=checkbox name=\"ADD_SELF\" value=\"YES\" $CHECKED></td>\n";

    if ($$pref{'SHOW_DOMAINLIST'} eq 'YES') {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr align=center><td align=left>Show domain list<br>";
    print "<blockquote><i>If this is set people can see all the domains your GnuDIP server is set to host. If you host a public site and you do not want everyone to know all the domains you host uncheck this box, and when someone goes to signup or change their domain they will have to know exaclly what domains you host. Only affected if Domain Type is INDIVIDUAL.</i></blockquote></td><td width=40 valign=middle><input type=checkbox name=\"SHOW_DOMAINLIST\" value=\"YES\" $CHECKED></td>\n";

    if ($$pref{'ALLOW_CHANGE_DOMAIN'} eq 'YES') {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr align=center><td align=left>Allow domain changes<br>";
    print "<blockquote><i>If this is set users will be able to change between the different domains this GnuDIP server hosts. Only affected if Domain Type is INDIVIDUAL.</i></blockquote></td><td width=40 valign=middle><input type=checkbox name=\"ALLOW_CHANGE_DOMAIN\" value=\"YES\" $CHECKED></td>\n";

    print "<tr align=center><td align=left>GnuDIP domain<br>";
    print "<blockquote><i>This is the domain for which users will have a hostname in. So, if there us a user jdoe then he would be jdoe.domaininthisbox.com</i></blockquote></td><td width=40 valign=middle><input type=text name=\"GNUDIP_DOMAIN\" size=25 value=\"$$pref{'GNUDIP_DOMAIN'}\"></td>\n";

    print "<tr align=center><td align=left>Path to DNS zone file<br>";
    print "<blockquote><i>Set this to the path to the zone file of the domain used for GnuDIP ex: /var/named/mydomain.zone</i></blockquote></td><td width=40 valign=middle><input type=text name=\"ZONEFILE\" size=25 value=\"$$pref{'ZONEFILE'}\"></td>\n";

    my ($INDIVIDUAL_CHECKED, $GLOBAL_CHECKED);
    if ($$pref{'DOMAIN_TYPE'} eq "INDIVIDUAL") {
      $INDIVIDUAL_CHECKED = "CHECKED";
    } elsif ($$pref{'DOMAIN_TYPE'} eq "GLOBAL") {
      $GLOBAL_CHECKED = "CHECKED";
    }
    print "<tr align=center><td align=left>Domain Type<br>";
    print "<blockquote><i>INDIVIDUAL means you can have the same username for different domains, ex: bob.domain1.com is a different user than bob.domain2.com. GLOBAL means that if you host domain1.com and domain2.com the user bob will have the same IP as both bob.domain1.com and bob.domain2.com. Note: In INDIVIDUAL mode, any user marked as as admin is treated as a global user. So, you cannot have the same admin username as different accounts. </i></blockquote></td><td width=40 valign=middle><input type=radio name=\"DOMAIN_TYPE\" value=\"INDIVIDUAL\" $INDIVIDUAL_CHECKED>INDIVIDUAL<br> <input type=radio name=\"DOMAIN_TYPE\" value=\"GLOBAL\" $GLOBAL_CHECKED>GLOBAL </td>\n";

    my ($STANDALONE_CHECKED, $INCLUDE_CHECKED);
    if ($$pref{'ZONETYPE'} eq "STANDALONE") {
      $STANDALONE_CHECKED = "CHECKED";
    } elsif ($$pref{'ZONETYPE'} eq "INCLUDE") {
      $INCLUDE_CHECKED = "CHECKED";
    }
    print "<tr align=center><td align=left>GnuDIP zone type<br>";
    print "<blockquote><i>STANDALONE tells GnuDIP that you will have seperate domain just for GnuDIP (most likely a subdomain of your main domain) and that it shoud handle the serial number for you (this method is usefull if you need to run a backup DNS server on this domain). INCLUDE allows you to use named's \$INCLUDE feature on the above zonefile to run your GnuDIP users within your domain you use for other stuff, but then it will not handle your serial number (if you don't have a backup DNS server then this will not be an issue) </i></blockquote></td><td width=40 valign=middle><input type=radio name=\"ZONETYPE\" value=\"STANDALONE\" $STANDALONE_CHECKED>STANDALONE<br> <input type=radio name=\"ZONETYPE\" value=\"INCLUDE\" $INCLUDE_CHECKED>INCLUDE </td>\n";

    print "<tr align=center><td align=left>Path to ndc<br>";
    print "<blockquote><i>Set this to the path of your ndc program. Usually /usr/sbin/ndc</i></blockquote></td><td width=40 valign=middle><input type=text name=\"NDC_PATH\" size=25 value=\"$$pref{'NDC_PATH'}\"></td>\n";

    print "<tr align=center><td align=left>Restricted usernames<br>";
    print "<blockquote><i>This is a comma seperated list of usernames you do not want to be allowed as GnuDIP usernames. <font color=red>NOTE: NO spaces between entries.</font> Useful to protect common hostnames from being used. An * can be used as a wild card to match a string of characters, and a ? can be used to match a single character. Common entries include www, ftp, ns?, mail*, etc...</i></blockquote></td><td width=40 valign=middle><input type=text name=\"RESTRICTED_USERS\" size=25 value=\"$$pref{'RESTRICTED_USERS'}\"></td>\n";

    print "<tr align=center><td align=left>Cookie domain<br>";
    print "<blockquote><i>Set this to the domain that is used for this CGI. This entry is used for genertaing cookies for the autoURL features. If this is not set to the domain from which the server hosting this cgi is in then the cookie will not be set in the users browser. Be sure to include a \".\" in front of this field unless you put the whole hostname of the server the CGI resides on in this box</i></blockquote></td><td width=40 valign=middle><input type=text name=\"COOKIE_DOMAIN\" size=25 value=\"$$pref{'COOKIE_DOMAIN'}\"></td>\n";

    print "<tr align=center><td align=left>Header file<br>";
    print "<blockquote><i>This is the path to a file containing HTML you want to be displayed at the login prompt. Leave blank to not use this feature. ex: /usr/local/apache/htdocs/gnudipwelcome.html</i></blockquote></td><td width=40 valign=middle><input type=text name=\"HEADER_FILE\" size=25 value=\"$$pref{'HEADER_FILE'}\"></td>\n";


    print "</table>\n";
    print "<br><center><input type=submit name=\"save_settings\" value=\"Save Settings\">\&nbsp\;<input type=submit name=\"login\" value=\"Main Menu\"></center></form>\n";
    print "</center></body></html>\n";
    

#############################################################
#  managedomains_edit                                       #
#                                                           #
#    Print out the edit domain section for the admin        #
#                                                           #
#############################################################
} elsif ($query->param("managedomains_edit") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    my $pref = getprefs();
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Edit Domain")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<input type=hidden name=\"editdomid\" value=\"".$query->param("editdomid")."\">\n";
    $sth = $dbh->prepare("select * from domains where id = \"".$query->param("editdomid")."\"");
    $sth->execute;
    my @userinfo = $sth->fetchrow_array;
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Domain")."</td><td><input type=\"text\" name=\"new_domain\" value=\"$userinfo[1]\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Zone File")."</td><td><input type=\"text\" name=\"new_zonefile\" value=\"$userinfo[2]\" size=35></td></tr>\n";
    my ($STANDALONE_CHECKED, $INCLUDE_CHECKED);
    if ($userinfo[3] eq 'STANDALONE') {
      $STANDALONE_CHECKED = "CHECKED";
    } elsif ($userinfo[3] eq 'INCLUDE') {
      $INCLUDE_CHECKED = "CHECKED";
    }
    print "<tr><td>".font("black:2:arial","Zone Type")."</td><td><input type=\"radio\" name=\"new_zonetype\" value=\"STANDALONE\" $STANDALONE_CHECKED>STANDALONE<br><input type=\"radio\" name=\"new_zonetype\" value=\"INCLUDE\" $INCLUDE_CHECKED>INCLUDE</td></tr>\n";
    my $CHECKED;
    if ($userinfo[4] eq "YES") {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr><td>".font("black:2:arial","Allow Password Changes")."</td><td><input type=\"checkbox\" name=\"ALLOW_CHANGEPASS\" value=\"YES\" $CHECKED></td></tr>\n";
    if ($userinfo[5] eq "YES") {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr><td>".font("black:2:arial","Self Registration")."</td><td><input type=\"checkbox\" name=\"ADDSELF\" value=\"YES\" $CHECKED></td></tr>\n";
    print "</table></center>\n";
    print "<br><center><input type=\"submit\" name=\"do_editdomain\" value=\"Save Changes\"></center>\n";
    print "</form></body></html>\n";
    exit;



#############################################################
#  manageusers_edituser                                     #
#                                                           #
#    Print out the edit tuser section for the admin         #
#                                                           #
#############################################################
} elsif ($query->param("manageusers_edituser") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    my $pref = getprefs();
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Edit User")."</h1></center>\n";
    print "<center>".font("red:2:arial","Note: Leave Password Fields Blank to Remain the Same")."<br><br></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<input type=hidden name=\"edituserid\" value=\"".$query->param("edituserid")."\">\n";
    $sth = $dbh->prepare("select * from users where id = \"".$query->param("edituserid")."\"");
    $sth->execute;
    my @userinfo = $sth->fetchrow_array;
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Created")."</td><td>$userinfo[5]</td></tr>\n";
    print "<tr><td>".font("black:2:arial","Username")."</td><td><input type=\"text\" name=\"new_username\" value=\"$userinfo[1]\"></td></tr>\n";
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       print "<tr><td>".font("black:2:arial","Domain")."</td><td>";
       $sth = $dbh->prepare("select domain from domains");
       $sth->execute;
       my @domains = ($$pref{'GNUDIP_DOMAIN'});
       while (my ($dom) = $sth->fetchrow_array) {
         push(@domains, $dom);
       }
       print $query->scrolling_list(-name=>'new_domain', -values=>[@domains], -size=>1, -default=>$userinfo[3]);
       print "</td></tr>\n";
    }
    print "<tr><td>".font("black:2:arial","E-Mail")."</td><td><input type=\"text\" name=\"new_email\" value=\"$userinfo[4]\" size=35></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Forward URL")."</td><td><input type=\"text\" name=\"new_forwardurl\" value=\"$userinfo[6]\" size=35></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password")."</td><td><input type=\"password\" name=\"new_password\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password Again")."</td><td><input type=\"password\" name=\"new_password1\"></td></tr>\n";
    my $CHECKED;
    if ($userinfo[8] eq "ADMIN") {
      $CHECKED = "CHECKED";
    } else {
      $CHECKED = "";
    }
    print "<tr><td>".font("black:2:arial","Admin")."</td><td><input type=\"checkbox\" name=\"user_level\" value=\"ADMIN\" $CHECKED></td></tr>\n";
    print "</table></center>\n";
    print "<br><center><input type=\"submit\" name=\"do_edituser\" value=\"Save Changes\"></center>\n";
    print "</form></body></html>\n";
    exit;



#############################################################
#  manageusers_adduser                                      #
#                                                           #
#    Print out the add user section for the admin           #
#                                                           #
#############################################################
} elsif ($query->param("manageusers_adduser") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    my $pref = getprefs();
    error("not_admin") if $level ne "ADMIN";
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Add User")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Username")."</td><td><input type=\"text\" name=\"new_username\"></td></tr>\n";
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       print "<tr><td>".font("black:2:arial","Domain")."</td><td>";
       $sth = $dbh->prepare("select domain from domains");
       $sth->execute;
       my @domains = ($$pref{'GNUDIP_DOMAIN'});
       while (my ($dom) = $sth->fetchrow_array) {
         push(@domains, $dom);
       }
       print $query->scrolling_list(-name=>'new_domain', -values=>[@domains], -size=>1);
       print "</td></tr>\n";
    }
    print "<tr><td>".font("black:2:arial","E-Mail Address")."</td><td><input type=\"text\" name=\"new_email\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password")."</td><td><input type=\"password\" name=\"new_password\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password Again")."</td><td><input type=\"password\" name=\"new_password1\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Admin")."</td><td><input type=\"checkbox\" name=\"user_level\" value=\"ADMIN\"></td></tr>\n";
    print "</table></center>\n";
    print "<br><center><input type=\"submit\" name=\"do_adduser\" value=\"Add User\"></center>\n";
    print "</form></body></html>\n";

    exit;


#############################################################
#  manageusers_main                                         #
#                                                           #
#    Print out the admin section for the administrator      #
#                                                           #
#############################################################
} elsif ($query->param("manageusers_main") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    print "<html><head><title>$title</title></head>\n";
    print qq!

<script language="javascript">

 function test() {
   message=("Delete Selected Users?")
   if(confirm(message)) {
      return true
   } else {
     return false
   }     
}

</script>

!;
    my $sortorder = '';
    if ($query->param('orderby') eq 'ASC' || !$query->param('orderby')) {
       $sortorder = ">";
    } elsif ($query->param('orderby') eq 'DESC') {
       $sortorder = "<";
    }
    my ($sortby, $byuser, $byip, $bydomain, $byupdated, $bylevel);
    if ($query->param("manage_users_sortby_username") ne "") {
       $sortby = "username";
       $byuser = "<font color=red size=4>*</font>$sortorder";
    } elsif ($query->param("manage_users_sortby_currentip") ne "") {
       $sortby = "currentip";
       $byip = "<font color=red size=4>*</font>$sortorder";
    } elsif ($query->param("manage_users_sortby_domain") ne "") {
       $sortby = "domain";
       $bydomain = "<font color=red size=4>*</font>$sortorder";
    } elsif ($query->param("manage_users_sortby_updated") ne "") {
       $sortby = "updated";
       $byupdated = "<font color=red size=4>*</font>$sortorder";
    } elsif ($query->param("manage_users_sortby_level") ne "") {
       $sortby = "level";
       $bylevel = "<font color=red size=4>*</font>$sortorder";
    } else {
       $sortby = "username";
       $byuser = "<font color=red size=4>*</font>$sortorder";
    }

    print "$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Manage Users")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"manageusers_main\" value=\"true\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    if ($query->param('orderby') eq 'ASC' || !$query->param('orderby')) {
       print "<input type=hidden name=\"orderby\" value=\"DESC\">\n";
    } elsif ($query->param('orderby') eq 'DESC') {
       print "<input type=hidden name=\"orderby\" value=\"ASC\">\n";
    }
    print "<center><table border=1>\n";
    print "<tr align=center><td><input type=submit name=\"manage_users_sortby_username\" value=\"Sort\">$byuser</td><td><input type=submit name=\"manage_users_sortby_currentip\" value=\"Sort\">$byip</td><td><input type=submit name=\"manage_users_sortby_domain\" value=\"Sort\">$bydomain</td><td><input type=submit name=\"manage_users_sortby_updated\" value=\"Sort\">$byupdated</td><td><input type=submit name=\"manage_users_sortby_level\" value=\"Sort\">$bylevel</td><td>-</td><td>-</td></tr>\n";
    print "<tr><th>Username</th><th>Current IP</th><th>Domain</th><th>Last Updated</th><th>Level</th><th>Edit User</th><th>Check<br>To Delete</th></tr>\n";
    $sth = $dbh->prepare("select * from users order by $sortby ".$query->param('orderby'));
    $sth->execute;
    my $rows = 0;
    while (my @userinfo = $sth->fetchrow_array) {
      my $CHECKED = "CHECKED" if $rows eq "0";
      print "<tr align=center><td>$userinfo[1]</td><td>$userinfo[9]</td><td>$userinfo[3]</td><td>$userinfo[7]</td><td>$userinfo[8]</td><td><input type=radio name=\"edituserid\" value=\"$userinfo[0]\" $CHECKED></td><td><input type=checkbox name=\"userid\" value=\"$userinfo[0]\"></td></tr>\n";
      $rows++;
    }
    print "</table><br><br>\n";
    print "<input type=submit name=\"manageusers_adduser\" value=\"Add User\">\&nbsp\;\n";
    print "<input type=submit name=\"do_deluser\" value=\"Delete Selected Users\" onclick=\"return test()\">\&nbsp\;\n";
    print "<input type=submit name=\"manageusers_edituser\" value=\"Edit Selected User\">\&nbsp\;\n";
    print "</form>\n";
    print "<form action=\"$thiscgi\" method=post>\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<input type=submit name=\"login\" value=\"Main Menu\"></center>\n";
    print "</form></body></html>\n";
    

#############################################################
#  managedomains_add                                        #
#                                                           #
#    Print out the add domain form                          #
#                                                           #
#############################################################
} elsif ($query->param("managedomains_add") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    my $pref = getprefs();
    error("not_admin") if $level ne "ADMIN";
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Add Domain")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Domain Name")."</td><td><input type=\"text\" name=\"new_domain\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Zone File")."</td><td><input type=\"text\" name=\"new_zonefile\" size=35></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Zone Type")."</td><td><input type=\"radio\" name=\"new_zonetype\" value=\"STANDALONE\" CHECKED>STANDALONE<br><input type=\"radio\" name=\"new_zonetype\" value=\"INCLUDE\">INCLUDE</td></tr>\n";
    print "<tr><td>".font("black:2:arial","Allow Password Changes")."</td><td><input type=\"checkbox\" name=\"ALLOW_CHANGEPASS\" value=\"YES\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Self Registration")."</td><td><input type=\"checkbox\" name=\"ADDSELF\" value=\"YES\"></td></tr>\n";
    print "</table></center>\n";
    print "<br><center><input type=\"submit\" name=\"do_adddomain\" value=\"Add Domain\"></center>\n";
    print "</form></body></html>\n";

    exit;


#############################################################
#  managedomains_main                                        #
#                                                           #
#    Print out the admin section for the administrator      #
#                                                           #
#############################################################
} elsif ($query->param("managedomains_main") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param('domain'));
    error("not_admin") if $level ne "ADMIN";
    print "<html><head><title>$title</title></head>\n";
    print qq!

<script language="javascript">

 function test() {
   message=("Delete Selected Domains?")
   if(confirm(message)) {
      return true
   } else {
     return false
   }     
}

</script>

!;
    print "$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center><h1>".font("black:4:arial","Manage Domains")."</h1></center>\n";
    print "<form action=\"$thiscgi\" method=\"post\">\n";
    print "<input type=hidden name=\"managedomains_main\" value=\"true\">\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<center><table border=1>\n";

    print "<tr><th>Domain</th><th>Zonefile</th><th>Zone Type</th><th>Allow Password Changes</th><th>Allow Add Self</th><th>Edit Domain</th><th>Check<br>To Delete</th></tr>\n";
    $sth = $dbh->prepare("select * from domains");
    $sth->execute;
    my $rows = 0;
    while (my @dominfo = $sth->fetchrow_array) {
      my $CHECKED = "CHECKED" if $rows eq "0";
      print "<tr align=center><td>$dominfo[1]</td><td>$dominfo[2]</td><td>$dominfo[3]</td><td>$dominfo[4]</td><td>$dominfo[5]</td><td><input type=radio name=\"editdomid\" value=\"$dominfo[0]\" $CHECKED></td><td><input type=checkbox name=\"domid\" value=\"$dominfo[0]\"></td></tr>\n";
      $rows++;
    }
    print "</table><br><br>\n";
    print "<input type=submit name=\"managedomains_add\" value=\"Add Domain\">\&nbsp\;\n";
    print "<input type=submit name=\"do_deldomain\" value=\"Delete Selected Domains\" onclick=\"return test()\">\&nbsp\;\n";
    print "<input type=submit name=\"managedomains_edit\" value=\"Edit Selected Domain\">\&nbsp\;\n";
    print "</form>\n";
    print "<form action=\"$thiscgi\" method=post>\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<input type=submit name=\"login\" value=\"Main Menu\"></center>\n";
    print "</form></body></html>\n";
    
  
  

#############################################################
#  changesettings                                           #
#                                                           #
#    Print out the current settings and let the user        #
#    change them                                            #
#                                                           #
#############################################################
} elsif ($query->param("changesettings") ne "") {

    header();
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    my $pref = getprefs();
    my ($id, $dbuser, $dbpass, $dbdomain, $dbemail, $forwardurl, $createdata) = getuserinfo($query->param("username"), $query->param("domain"));
   
    print "<html><head><title>$title</title></head>$body\n";
    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center>".font("black:4:arial","Current Settings:")."<br><br></center>\n";
    print "<center>".font("red:2:arial","Note: Leave Password Fields Blank to Remain the Same")."<br><br></center>\n";
    print "<form action=\"$thiscgi\" method=post>\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:2:arial","Username/Hostname")."</td><td><input type=\"text\" name=\"new_username\" value=\"$dbuser\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","E-Mail Address")."</td><td><input type=\"text\" name=\"new_email\" value=\"$dbemail\" size=\"40\"></td></tr>\n";
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       if ($$pref{'SHOW_DOMAINLIST'} eq 'YES') {
         $sth = $dbh->prepare("select domain from domains");
         $sth->execute;
         print "<tr><td>".font("black:2:arial","Domain")."</td><td>";
         my @domains = ($$pref{'GNUDIP_DOMAIN'});
         while (my $dom = $sth->fetchrow_array) {
             push(@domains, $dom);
         }
         print $query->scrolling_list(-name=>'new_domain', -values=>[@domains], -size=>1, -default=>$query->param("domain"));
         print "</td></tr>\n";
       } elsif ($$pref{'SHOW_DOMAINLIST'} eq 'NO') {
          print "<tr><td>".font("black:2:arial","Domain")."</td><td><input type=\"text\" name=\"domain\" value=\"$dbdomain\"></td></tr>\n";
       }
    }
    print "<tr><td>".font("black:2:arial","Forward URL ").font("red:1:arial","\(Do not forget http://\)")."</td><td><input type=\"text\" size=40 name=\"forwardurl\" value=\"$forwardurl\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password")."</td><td><input type=\"password\" name=\"new_password\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","New Password Again")."</td><td><input type=\"password\" name=\"new_password1\"></td></tr>\n";
    print "<tr><td></td><td><input type=\"submit\" name=\"do_updatesettings\" value=\"Save Settings\"></td></tr>\n";

    print "</table></center>\n";

    print "<br><br><center><input type=submit name=\"login\" value=\"Back to Main Menu\"></center>\n";



#############################################################
#  setautourl                                               #
#                                                           #
#    Display the auto URL page                              #
#                                                           #
#############################################################
} elsif ($query->param("setautourl") ne "") {

   my ($cookieuser, $cookiepass, $cookie1, $cookie2, $cookie3);
   my $pref = getprefs();
   my $cookiedomain = $$pref{'COOKIE_DOMAIN'};
   $cookieuser = $query->cookie("gnudip2user");
   $cookiepass = $query->cookie("gnudip2pass");
   $cookie1 = $query->cookie(-name=>'gnudip2user',
                        -value=>$query->param("username"),
                        -expires=>'+1M',
                        -path=>'/',
                        -domain=>$cookiedomain);
   my $encpass = md5sum($query->param("password"));
   $cookie2 = $query->cookie(-name=>'gnudip2pass',
                        -value=>$encpass,
                        -expires=>'+1M',
                        -path=>'/',
                        -domain=>$cookiedomain);
   $cookie3 = $query->cookie(-name=>'gnudip2domain',
                        -value=>$query->param("domain"),
                        -expires=>'+1M',
                        -path=>'/',
                        -domain=>$cookiedomain);
   print $query->header(-cookie=>[$cookie1, $cookie2, $cookie3]);
   print "<html><head><title>Auto URL Cookie Set!</title></head>$body\n";

   print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
   print qq!
    <p><font face=arial>Auto URL is a feature of GnuDIP2 that allows a user to set a cookie in their browser with their username, password and the URL of their homepage. 

    </p><br>The way it works is the GnuDIP2 CGI reads the username and password to update your hostname to point to your current IP address, then it automatically forwards you to your specified URL. This allows for quick updating of your hostname by not having to type your username and password every time and it also allows you to keep your homepage to what ever you want it to be. </p>

    <p>Now that the cookie has been set, you can test it by clicking the link below. After it succesfully updates your hostname set that page as your browsers default page</p>

   <br><center><a href=\"$thiscgi\?action=getautourlinfo\">Click Here To Test AUTO URL Cookie</a>

    !;

   print "<form action=\"$thiscgi\" method=\"post\">\n";
   print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
   print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
   print "<br><center><input type=submit name=\"removeautourl\" value=\"Remove Auto URL\">\&nbsp\;<input type=submit name=\"login\" value=\"Main Menu\"></center>\n";
   print "</form></body></html>\n";


#############################################################
#  login                                                    #
#                                                           #
#    Print out the options after user has logged in         #
#                                                           #
#############################################################
} elsif ($query->param("login") ne "") {
    
    header();
    print "<html><head><title>$title</title></head>$body\n";
    my $level = checkauth($query->param("username"), $query->param("password"), $query->param("domain"));
    my $pref = getprefs(); 
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
       $sth = $dbh->prepare("select currentip, updated from users where username = \"".$query->param("username")."\" and domain = \"".$query->param('domain')."\"");
    } elsif($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
       $sth = $dbh->prepare("select currentip, updated from users where username = \"".$query->param("username")."\"");
    }
    $sth->execute;
    my ($currentip, $updated) = $sth->fetchrow_array;
    $sth->finish; 
    my $domain = '';
    $domain = '.'.$query->param('domain') if $$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL';

    print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    print "<center>".font("red:4:arial","Hostname ".$query->param("username")."$domain Currently Points to $currentip <br> <i>\(Updated at $updated\)</i>")."</h1></center>\n";
    print "<br><center>".font("black:3:arial","Please Choose An Option:")."</center><br>\n";
    print "<form action=\"$thiscgi\" method=post>\n";
    print "<input type=hidden name=\"username\" value=\"".$query->param("username")."\">\n";
    print "<input type=hidden name=\"password\" value=\"".$query->param("password")."\">\n";
    print "<input type=hidden name=\"domain\" value=\"".$query->param("domain")."\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>Change hostname <b><i>".$query->param("username")."$domain</i></b><br> to new IP <b><i>$remote_ip</i><b></td><td><input type=submit name=\"updatehost\" value=\"Go\"></td></tr>\n";
    print "<tr><td>Set Offline <br> \(<i>Unpoints your hostname from current<br> address until next update</i>\) </td><td><input type=submit name=\"offline\" value=\"Go\"></td></tr>\n";
    print "<tr><td>Change Settings</td><td><input type=submit name=\"changesettings\" value=\"Go\"></td></tr>\n";
    print "<tr><td>Set Auto URL</td><td><input type=submit name=\"setautourl\" value=\"Go\"></td></tr>\n";
    if ($level eq "ADMIN") {
       print "<tr><td>Manage Users</td><td><input type=submit name=\"manageusers_main\" value=\"Go\"></td></tr>\n";
       print "<tr><td>Manage Domains</td><td><input type=submit name=\"managedomains_main\" value=\"Go\"></td></tr>\n";
       print "<tr><td>Administrative Settings</td><td><input type=submit name=\"system_settings\" value=\"Go\"></td></tr>\n";
    }
   
    print "</table></form></center>\n";

 
#############################################################
#  Default Section                                          #
#                                                           #
#    Print out the main GnuDIP2 page                        #
#                                                           #
#############################################################
} else {
   
    header();
    my $pref = getprefs();
    my $headerfile = $$pref{'HEADER_FILE'};
    print "<html><head><title>$title</title></head>$body\n";
    if ($headerfile && open(HEADER,"$headerfile")) {
      while (<HEADER>) {
        print;
      }
    } else {
      print "<center><h1>".font("black:6:arial","GnuDIP2 Web Interface")."</h1></center>\n";
    }
    print "<form action=\"$thiscgi\" method=\"POST\">\n";
    print "<br><center><table border=0>\n";
    print "<tr><td>Username/Hostname:</td><td><input type=\"text\" name=\"username\"></td></tr>\n";
    print "<tr><td>Password:</td><td><input type=\"password\" name=\"password\"></td></tr>\n";
    if ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
      if ($$pref{'SHOW_DOMAINLIST'} eq 'YES') {
        print "<tr><td>Domain:</td><td>";
        $sth = $dbh->prepare("select * from domains");
        $sth->execute;
        print "<select name=\"domain\">\n";
        print "<option value=\"$$pref{'GNUDIP_DOMAIN'}\">$$pref{'GNUDIP_DOMAIN'}\n";
        while (my @domains = $sth->fetchrow_array) {
          print "<option value=\"$domains[1]\">$domains[1]\n";
        }
        print "</select></td></tr>\n";
      } else {
        print "<tr><td>Domain:</td><td><input type=\"text\" name=\"domain\"></td></tr>\n";
      }
    }
    print "<tr><td></td><td><input type=\"submit\" name=\"login\" value=\"Login\"></td></tr>\n";
    print "</table></center></form>\n";
    print "</body></html>\n";

}

#  $dbh->disconnect;



#############################################################
# subs                                                      #
#                                                           #
#    Variuos subs for handleing repetitive tasks            #
#                                                           #
#############################################################

#### font sub for printing stings in different fonts
sub font {
  #### arg0 is in format color:size:face    return: font string
  my $options = $_[0];
  my ($color, $size, $face) = split(/:/, $options);
  my $string = $_[1];
  return "<font color=\"$color\" size=\"$size\" face=\"$face\">$string</font>";
}


#### error sub for various errors  return: nothing
sub error {

  header();

  my($error);
  $error = shift;
  print "<html><head><title>Error!</title></head>$body\n";

  if ($error eq "nouser") {
    print "<br><center><h1>Error: Unknown User</h1></center>\n";
    print "<p>You entered a username/domain combination which was unknown. Please go back and check for typos.</p>\n";
  } elsif ($error eq "badpass") {
    print "<br><center><h1>Error: Invalid Login</h1></center>\n";
    print "<p>The password you entered was invalid. Please go back and check for typos.</p>\n";
  } elsif ($error eq "not_same") {
    print "<br><center><h1>Error: Password Error </h1></center>\n";
    print "<p>You must enter the same password twice. Please go back and enter the same password twice.</p>\n";
  } elsif ($error eq "bad_str") {
    print "<br><center><h1>Error: Invalid Charator </h1></center>\n";
    print "<p>You entered an invalid character in the following fields:</p><br>\n";
    my ($field, $refbdfields);
    $refbdfields = $_[0];
    foreach $field (@$refbdfields) {
       print "<li>$field<br>\n";
    }
    print "<br><br><p>Please go back and check those fields<br>\n";
  } elsif ($error eq "bad_firstlast") {
    print "<br><center><h1>Error: Invalid Charator </h1></center>\n";
    print "<p>You entered an invalid character in first or last position of the hostname feild. Below is the invalid data you entered: </p><br>\n";
    my ($field, $refbdfields);
    $refbdfields = $_[0];
    foreach $field (@$refbdfields) {
       print "<li>$field<br>\n";
    }
    print "<br><br><p>Please go back and check this entry<br>\n";
  } elsif ($error eq "user_exists") {
    print "<br><center><h1>Error: User Exists</h1></center>\n";
    print "<br><p>Please go back and choose a username that is not already in use.\n";
  } elsif ($error eq "no_cookie") {
    print "<br><center><h1>Error: No Cookie</h1></center>\n";
    print "<br><p>No cookie was found with your settings. Please goto the main menu and choose 'Set Auto URL'.\n";
  } elsif ($error eq "no_changepass") {
    print "<br><center><h1>Error: Password Changes Not Allowed</h1></center>\n";
    print "<br><p>Your administrator has chosen not to allow users to change their own password. Please contact your administrator and ask them to change your password for you.\n";
  } elsif ($error eq "need_userchange") {
    print "<br><center><h1>Error: Set Password</h1></center>\n";
    print "<br><p>You must re-enter your password when changing the username. Please go back and enter a valid password.\n";
  } elsif ($error eq "not_admin") {
    print "<br><center><h1>Error: Not Administrator</h1></center>\n";
    print "<br><p>You are not marked as an administrator. Please log in again if you feel this is an error.\n";
  } elsif ($error eq "restricted_user") {
    print "<br><center><h1>Error: Restricted Username</h1></center>\n";
    print "<br><p>The username you have chosen has been marked as restricted. Please contact your administrator if you feel this is an error.\n";
  } elsif ($error eq "no_changehostname") {
    print "<br><center><h1>Error: Hostname changes not allowed</h1></center>\n";
    print "<br><p>Your administrator has chosen not to allow users to change their hostnames. Please contact your administrator if you feel this is an error.\n";
  } elsif ($error eq "no_spaces") {
    print "<br><center><h1>Error: No Spaces or Blanks Allowed</h1></center>\n";
    print "<br><p>You entered a string which contained spaces or was left blank. Please go back and check your username.\n";
  } elsif ($error eq "no_add_self") {
    print "<br><center><h1>Error: Self registration not allowed</h1></center>\n";
    print "<br><p>Your administrator has chosen not to allow self registration. Please contact your administrator for an account .\n";
  } elsif ($error eq "no_forwardurl") {
    print "<br><center><h1>Error: Forward URL Not Set</h1></center>\n";
    print "<br><p>You have chosen to use Auto URL, but have not set a URL to forward to. Please set a Forward URL in your GnuDIP settings.</p>\n";
  } elsif ($error eq "unknown_dom") {
    print "<br><center><h1>Error: Unknown Domain</h1></center>\n";
    print "<br><p>The domain you have selected is not known by the server. Please go back and check what you entered.</p>\n";
  }


  exit;
}      

#### print an html header   return: nothing
sub header {
    print "Content-type: text/html\n\n" if $printheader ne "no";
    $printheader = "no";
}

#### checkauth  return: auth level
sub checkauth {
  my $user = shift;
  my $pass = shift;
  my $domain = shift;
  my $pref = getprefs();
  if ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
     $sth = $dbh->prepare("select username, password, domain, level from users where username = \"$user\"");
  } elsif ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
     $sth = $dbh->prepare("select username, password, domain, level from users where username = \"$user\" and domain = \"$domain\"");
  }
  $sth->execute;
  my ($dbuser, $dbpass, $dbdomain, $dblevel) = $sth->fetchrow_array;
  $sth->finish;
  if ($dbuser eq '' && $$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
      $sth = $dbh->prepare("select username, password, domain, level from users where username = \"$user\" and level = \"ADMIN\"");
      $sth->execute;
      ($dbuser, $dbpass, $dbdomain, $dblevel) = $sth->fetchrow_array;
  }
  error("nouser") if $dbuser eq "";
  my $encpass = gensum($pass);
  if ($dblevel eq 'ADMIN') {
     if(!($dbuser eq $user && $dbpass eq $encpass)) {
       error("badpass");
     }
  } elsif ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
     if(!($dbuser eq $user && $dbpass eq $encpass)) {
       error("badpass");
     }
  } elsif ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
     if(!($dbuser eq $user && $dbpass eq $encpass && $dbdomain eq $domain)) {
       error("badpass");
     }
  }
  return $dblevel;
}

#### Checks for invalid characters   return: nothing
sub checkchars {
 my (@badfields, $foundbadfield); 
 my @fields = @_;
 foreach my $field (@fields) {
    my $chkstr = $query->param($field);
    $chkstr =~ tr/\_\\\|\!\@\#\$\%\^\&\*\)\(\{\}\[\]\;\"\'\>\<\,\.\?\~\`/ /;
    $chkstr =~ s/ //g;
    if($query->param($field) ne $chkstr) {
      $foundbadfield = "YES";
      @badfields = (@badfields, $field); 
    }
 }
 if ($foundbadfield eq "YES") {
   header();
   error("bad_firstlast", \@badfields); 
 }

}

#### Checks for invalid characters in the first and last position   return: nothing
sub checkfirstlast {
 my (@fields, @badfields, $field, $chkstr, $foundbadfield, $invalid); 
 @fields = @_;
 my @invalids = ("_","-",".");
 foreach $field (@fields) {
    $chkstr = substr($field, 0, 1);
    foreach $invalid (@invalids) {
      if($chkstr eq $invalid) {
        $foundbadfield = "YES";
        @badfields = (@badfields, $field); 
      }
    }
    $chkstr = substr($field, length($field) -1, length($field));
    foreach $invalid (@invalids) {
      if($chkstr eq $invalid) {
        $foundbadfield = "YES";
        @badfields = (@badfields, $field); 
      }
    }
 }
 if ($foundbadfield eq "YES") {
   header();
   error("bad_firstlast", \@badfields); 
 }

}

#### Get prefs
sub getprefs {
 my %PREF;
 $sth = $dbh->prepare("select * from globalprefs");
 $sth->execute;
 while (my @prefs = $sth->fetchrow_array) {
   $PREF{$prefs[1]} = $prefs[2];
 }
 return \%PREF;

}

#### Return an array with users settings
sub getuserinfo {
  my $username = shift;
  my $domain = shift;
  my @userinfo;

  my $pref = getprefs();
  if ($$pref{'DOMAIN_TYPE'} eq 'GLOBAL') {
     $sth = $dbh->prepare("select id, username, password, domain, email, forwardurl, createdate from users where username = \"$username\"");
     $sth->execute;
     @userinfo = $sth->fetchrow_array;
  } elsif ($$pref{'DOMAIN_TYPE'} eq 'INDIVIDUAL') {
     $sth = $dbh->prepare("select id, username, password, domain, email, forwardurl, createdate from users where username = \"$username\" and domain = \"$domain\"");
     $sth->execute;
     @userinfo = $sth->fetchrow_array;
     if (!@userinfo) {
        $sth = $dbh->prepare("select id, username, password, domain, email, forwardurl, createdate from users where username = \"$username\" and level = \"ADMIN\"");
        $sth->execute;
        @userinfo = $sth->fetchrow_array;
     } 
  }
  return @userinfo;

}

#### Returns MD5 sum on string
sub md5sum {

 my $string = shift;
 
 my $md5 = new MD5;
 $md5->add($string);
 my $digest = $md5->digest();
 my $md5sum = unpack("H*", $digest);

 return $md5sum;
}
