#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# ingres/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Holger Meyer's Ingres/Python Driver
# (including OpenIngres 1.2, CA Ingres 6.4, CA Ingres II)
# Requires ingmod (http://www.informatik.uni-rostock.de/~hme/software/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     dbame=      This is the Ingres database to use (required)
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2
from DataObject import *

try:
  import ingmod as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('ingmod', None)


class Connection(DBSIG2.Connection):
  _driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(9,"Ingres database driver initializing")
    try:
      # TODO: I have no clue how to pass a Password!!!!!
      self.native = SIG2api.connect(connectData['dbname'], \
                user=connectData['_username'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

