#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# config/ResultSet.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with configuration files
#
# NOTES and TODO:
#
# @see Connection.py
#

from gnue.common.datasources.drivers.Base.ResultSet import ResultSet
from RecordSet import Configfile_RecordSet
from gnue.common.apps import GDebug

#
# Configfile_ResultSet
#
class Configfile_ResultSet(ResultSet): 
  def __init__(self, dataObject, cursor=None, \
        defaultValues={}, masterRecordSet=None): 
    ResultSet.__init__(self, dataObject, cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Configfile_RecordSet
    
    GDebug.printMesg(9, 'Configfile_ResultSet created')


  def _loadNextRecord(self):
    retval=0
    # all records has to be loaded in cache during resultset initialisation
    if self._cursor:
   
      # load all records at once  
      for dict in self._cursor:
            
        record=self._recordSetClass(parent=self,initialData=dict)
        self._cachedRecords.append (record)

        # increase record count by one
        self._recordCount=self._recordCount+1

        retval=1
        
      self._cursor=[] # after adding the values, delete them from cursor
      
    # if no record returned return a zero
    return retval
