#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/ToolBar.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.forms.uidrivers.html.widgets._base import HtmlWidget
from gnue.forms.uidrivers.html.common import *
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as _BaseToolBar
from gnue.common.apps import GConfig
from gnue.common import events


class ToolBar(_BaseToolBar):

  # Create the menu
  def init(self):
    dhtml = ''
    self.toolbar = HtmlWidget(self.container, self.driver, 'TOOLBAR', dhtml, getNextId())
    
  # Add a menu item (action)
  def addAction(self, name, userAction):
    iconloc = userAction.getIconLocation(size="24x24")

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = iconloc
        _cachedIcons[iconloc] = icon
    else:
      print "** WARNING: Cannot add '%s' to toolbar; no icon" % userAction.event
      return

    parent = self.toolbar
    label = name

    # Create an event binding in windows
    id = getNextId()
    event = 'request' + userAction.event
    self.container.Connect(id, lambda l=self.driver, e=event, f=self.form: l.dispatchEvent(events.Event(e,_form=f)))

    dhtml = '<input type="IMAGE" name="%s" src="file://%s" value="%s" alt="%s" />' % (event, icon, event, label)
    newwidget = HtmlWidget(self.container, self.driver, 'TOOLBAR', dhtml, id)

    return (parent, id)

  # Add a separator
  def addSeparator(self):
    id = getNextId()
    dhtml = ' '
    newwidget = HtmlWidget(self.container, self.driver, 'SEPARATOR', dhtml, id)

  # Enable a menu item
  def enableItem(self, item):
    pass

  # Disable a menu item
  def disableItem(self, item):
    pass

  def startingItem(self, item):
    pass

  def endingItem(self, item):
    pass

_cachedIcons = {}
