typedef struct _GoatGeometry
{
  gint x;
  gint y;
  gint px;
  gint py;
  gint width;
  gint height;
  gint dx;
  gint dy;
} GoatGeometry;

typedef struct _Goat
{
  gboolean dragging;
  gboolean resizing;
  gchar *name;
  GConfClient *gconf_client;
  guint gconf_settings_notify_id;
  guint gconf_properties_notify_id;
  gchar *gconf_path;
  gchar *xml_file;
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *text_view;
  GtkWidget *eventbox[3];
  GtkWidget *title;
  GtkWidget *menu;
  GtkWidget *cross;
  GdkPixbuf *icon;
  GdkColor *fg;
  GdkColor *bg;
  GdkColor *bg_topbar;
  GoatGeometry *geometry;
  GladeXML *alarm_xml;
  GladeXML *menu_xml;
  gboolean alarm_inited;
} Goat;

Goat *goat_new(const gchar *name, gboolean is_new);
void goat_delete(Goat *goat);
void goat_alarm_init(Goat *goat);

void goat_raise(Goat *goat);
void goat_lower(Goat *goat);
void goat_insert_text(Goat *goat, const gchar *text);
void goat_print(Goat *goat);
void goat_popup(Goat *goat);

gint goat_get_topbar_height(Goat *goat);
void goat_set_text(Goat *goat, const gchar *text);
void goat_set_size(Goat *goat, gint width, gint height);
void goat_set_hidden(Goat *goat, gboolean hidden);
void goat_set_shaded(Goat *goat, gboolean shaded);
void goat_set_sticky(Goat *goat, gboolean sticky);
void goat_set_floating(Goat *goat, gboolean floating);
void goat_set_title(Goat *goat, const gchar *title);
void goat_set_delete_hides(Goat *goat, gboolean delete_hides);
void goat_set_bg(Goat *goat, GdkColor *color);
void goat_set_fg(Goat *goat, GdkColor *color);
void goat_set_font(Goat *goat, const gchar *font_name);
void goat_set_position(Goat *goat, gint x, gint y);

void goat_set_alarm_time(Goat *goat, gulong time);
void goat_set_alarm_active(Goat *goat, gboolean active);
void goat_create_alarm_dialog(Goat *goat);

gboolean goat_get_bool(Goat *goat, const gchar *name);
void goat_set_bool(Goat *goat, const gchar *name, gboolean value);
gchar *goat_get_string(Goat *goat, const gchar *name);
void goat_set_string(Goat *goat, const gchar *name, const gchar *value);
gint goat_get_int(Goat *goat, const gchar *name);
void goat_set_int(Goat *goat, const gchar *name, gint value);
void goat_set_gdk_color(Goat *goat, gchar *name,
			GdkColor *color);
GdkColor *goat_get_gdk_color(Goat *goat, gchar *name);
