indexing

	description:

		"Binary input files containing extended ASCII %
		%characters (8-bit code between 0 and 255)"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:49:50 $"
	revision: "$Revision: 1.17 $"

class KL_BINARY_INPUT_FILE

inherit

	KI_BINARY_INPUT_FILE
		undefine






			read_to_buffer
		end

	KL_INPUT_FILE


		rename
			index as position
		undefine
			medium_table_type

		redefine






			file_reopen, file_open, file_dopen

		end



	RAW_FILE
		rename
			make as old_make,
			name as string_name,
			count as old_count,
			exists as old_exists,
			is_readable as old_is_readable,
			is_open_read as old_is_open_read,
			is_open_write as old_is_open_write,
			end_of_file as old_end_of_file,
			is_closed as old_is_closed,
			open_read as old_open_read,
			open_write as old_open_write,
			open_append as old_open_append,
			put_character as old_put_character,
			put_string as old_put_string,
			put_integer as old_put_integer,
			put_boolean as old_put_boolean,
			put_new_line as old_put_new_line,
			read_character as old_read_character,
			read_stream as old_read_stream,
			read_line as old_read_line,



			change_name as old_change_name,
			flush as old_flush,
			close as old_close,
			delete as old_delete,
			reset as old_reset,
			append as old_append
		export
			{NONE} all
		undefine
			file_readable
		redefine






			file_reopen, file_open, file_dopen

		end
















creation

	make
















feature {NONE} -- Implementation



















































	file_open (f_name: POINTER; how: INTEGER): POINTER is
			-- File pointer for file `f_name', in mode `how'.
		external
			"C | <eif_file.h>"
		alias
			"file_binary_open"
		end

	file_dopen (fd, how: INTEGER): POINTER is
			-- File pointer for file of descriptor `fd' in mode `how'
			-- (which must fit the way `fd' was obtained).
		external
			"C | <eif_file.h>"
		alias
			"file_binary_dopen"
		end

	file_reopen (f_name: POINTER; how: INTEGER; file: POINTER): POINTER is
		   -- File pointer to `file', reopened to have new name `f_name'
		   -- in a mode specified by `how'.
		external
			"C | <eif_file.h>"
		alias
			"file_binary_reopen"
		end



end
