indexing

	description:

		"Imported routines that ought to be in class FIXED_ARRAY. %
		%A fixed array is a zero-based indexed sequence of values, %
		%equipped with features `put', `item' and `count'."

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 1999, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:49:18 $"
	revision: "$Revision: 1.3 $"

class KL_IMPORTED_FIXED_ARRAY_ROUTINES

feature -- Access

	FIXED_ANY_ARRAY_: KL_FIXED_ARRAY_ROUTINES [ANY] is
			-- Routines that ought to be in class FIXED_ARRAY
		once
			create Result
		ensure
			fixed_any_array_routines_not_void: Result /= Void
		end

	FIXED_BOOLEAN_ARRAY_: KL_FIXED_ARRAY_ROUTINES [BOOLEAN] is
			-- Routines that ought to be in class FIXED_ARRAY
		once
			create Result
		ensure
			fixed_boolean_array_routines_not_void: Result /= Void
		end

	FIXED_CHARACTER_ARRAY_: KL_FIXED_ARRAY_ROUTINES [CHARACTER] is
			-- Routines that ought to be in class FIXED_ARRAY
		once
			create Result
		ensure
			fixed_character_array_routines_not_void: Result /= Void
		end

	FIXED_INTEGER_ARRAY_: KL_FIXED_ARRAY_ROUTINES [INTEGER] is
			-- Routines that ought to be in class FIXED_ARRAY
		once
			create Result
		ensure
			fixed_integer_array_routines_not_void: Result /= Void
		end

	FIXED_STRING_ARRAY_: KL_FIXED_ARRAY_ROUTINES [STRING] is
			-- Routines that ought to be in class FIXED_ARRAY
		once
			create Result
		ensure
			fixed_string_array_routines_not_void: Result /= Void
		end

feature -- Type anchors















	FIXED_ANY_ARRAY_TYPE: ARRAY [ANY] is do end
	FIXED_BOOLEAN_ARRAY_TYPE: ARRAY [BOOLEAN] is do end
	FIXED_CHARACTER_ARRAY_TYPE: ARRAY [CHARACTER] is do end
	FIXED_INTEGER_ARRAY_TYPE: ARRAY [INTEGER] is do end
	FIXED_STRING_ARRAY_TYPE: ARRAY [STRING] is do end


			-- Type anchors

end
