/*
 * GPG Keys 
 * config.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

/*
 * Edit theese options before you compile to reflect your system.
 * Most of theese options might be changed at run-time by the user
 * through the Properties dialog.
 */

#define BASEDIR     "/usr/share/gpgkeys"
#define LANGUAGEDIR BASEDIR "/language"
#define AUTHORSFILE BASEDIR "/AUTHORS"
#define LICENSEFILE BASEDIR "/COPYING"

/* General */
#define MAINSIGS    FALSE
#define UTF8_USERID TRUE

/* Enviroment */
#define GPGPATH     "gpg"
#define TERMINAL    "xterm -e"

/* Key Server */
#define KEYSERVER   "keyserver.pgp.com"
#define SERVERPORT  11371
#define SERVERSIGS  FALSE

/* Look and Feel */
#define LANGUAGE    "English"
#define STD_FAMILY  "Helvetica"
#define STD_SIZE    12
#define STD_WEIGHT  QFont::Normal
#define STD_ITALIC  FALSE
#define FIX_FAMILY  "Courier"
#define FIX_SIZE    12
#define FIX_WEIGHT  QFont::Normal
#define FIX_ITALIC  FALSE

/*
 * Do not edit values below
 */
 
#undef   CLIPBOARD_SUPPORT
#define  STD_FONT    STD_FAMILY, STD_SIZE, STD_WEIGHT, STD_ITALIC
#define  FIX_FONT    FIX_FAMILY, FIX_SIZE, FIX_WEIGHT, FIX_ITALIC

