dnl -*- Mode: autoconf; -*-

AC_DEFUN(AM_WITH_PG, [
  AC_PATH_PROG(PG_CONFIG, pg_config, "")
  if test -n "$PG_CONFIG"; then
    PG_CFLAGS="-I`$PG_CONFIG --includedir`"
    PG_LIBS="-L`$PG_CONFIG --libdir` -lpq"
    ifelse($1,, true, $1) # ACTION-IF-FOUND
  else
    AC_MSG_CHECKING([for PostgreSQL headers])
    dir=""
    for basedir in /usr/local /usr; do
      for x in "" /postgresql; do
        dir=$basedir/include$x
	if test -f $dir/libpq-fe.h; then break; fi;
	dir=""
      done
    done
    if test -n "$dir"; then
      AC_MSG_RESULT($dir)
      PG_CFLAGS="-I$dir"
      AC_CHECK_LIB(pq, PQconnectdb, [PG_LIBS="-lpq"], [PG_LIBS=""])
      if test -z "$PG_LIBS"; then
        ifelse($2,, true, $2) # ACTION-IF-NOT-FOUND
      else
        ifelse($1,, true, $1) # ACTION-FOUND
      fi
    else
      AC_MSG_RESULT([not found])
      ifelse($2,, true, $2) # ACTION-IF-NOT-FOUND
    fi
  fi
  AC_SUBST(PG_CFLAGS)
  AC_SUBST(PG_LIBS)
])
