#ifdef HAVE_CONFIG_H
#  include <config.h> 
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "interface.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"


GtkWidget *MainWindow;
GtkWidget *ConnectionTypesWindow;
GtkWidget *ConnectionsWindow;
GtkWidget *PropertiesDialog;

GSList *ConnectionsSList;
gboolean ConnectionsSListIsDirty;

GSList *ConnectionTypesSList;
gboolean ConnectionTypesSListIsDirty;

gchar* TerminalProgram;
gchar* TerminalProgramOptions;

SORT_OPTION SortOption = SORT_NONE;
gboolean DisplayUsernameInMainWindow = FALSE;

int
main (int argc, char *argv[])
{
	gchar *geom = NULL;
	gint width, height;
	GConfClient *gconf_client = NULL;
	GError *err = NULL;
	gchar *version = NULL;

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			    argc, argv,
			    GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR, NULL);

	gconf_init (argc, argv, NULL);

	gconf_client = gconf_client_get_default ();
	version =
		gconf_client_get_string (gconf_client, GCONF_RCM_VERSION,
					 NULL);
	if (version == NULL)
		rcm_first_run ();
	else if (strcmp (VERSION, version) != 0)
		rcm_upgrade (version);
	
	SortOption = gconf_client_get_int(gconf_client, GCONF_RCM_SORTING_OPTION, NULL);
	TerminalProgram = gconf_client_get_string(gconf_client, GCONF_RCM_TERMINAL_OPTION, NULL);
	if(!TerminalProgram)
		TerminalProgram = "gnome-terminal";
	TerminalProgramOptions = gconf_client_get_string(gconf_client, GCONF_RCM_TERMINAL_ARGUMENTS_OPTION, NULL);
	if(!TerminalProgramOptions)
		TerminalProgramOptions = "-x";
	
	DisplayUsernameInMainWindow = gconf_client_get_int(gconf_client, GCONF_RCM_DISPLAY_USERNAMES, NULL);
	
	ConnectionsSList = NULL;
	ConnectionTypesSList = NULL;
	rcm_load_types_from_disk ();
	rcm_load_connections_from_disk ();

	MainWindow = create_MainWindow ();
	gnome_app_enable_layout_config (GNOME_APP (MainWindow), TRUE);
	rcm_update_main_window ();

	width = gconf_client_get_int (gconf_client, GCONF_MAIN_WINDOW_WIDTH,
				      &err);
	if (err)
		width = 0;
	height = gconf_client_get_int (gconf_client, GCONF_MAIN_WINDOW_HEIGHT,
				       &err);
	if (err)
		height = 0;

	if (width && height)
		gtk_window_resize (GTK_WINDOW (MainWindow), width, height);

	gtk_widget_show (MainWindow);
	
	PropertiesDialog = create_PropertiesWindow();
	
	ConnectionTypesWindow = CreateConnectionTypesWindow ();
	width = gconf_client_get_int (gconf_client,
				      GCONF_CONNECTION_TYPES_WINDOW_WIDTH,
				      &err);
	if (err)
		width = 0;
	height = gconf_client_get_int (gconf_client,
				       GCONF_CONNECTION_TYPES_WINDOW_HEIGHT,
				       &err);
	if (err)
		height = 0;

	if (width && height)
		gtk_window_resize (GTK_WINDOW (ConnectionTypesWindow), width,
				   height);
	rcm_update_connectiontypes_window_list ();

	ConnectionsWindow = CreateConnectionsWindow ();
	width = gconf_client_get_int (gconf_client,
				      GCONF_CONNECTIONS_WINDOW_WIDTH, &err);
	if (err)
		width = 0;
	height = gconf_client_get_int (gconf_client,
				       GCONF_CONNECTIONS_WINDOW_HEIGHT, &err);
	if (err)
		height = 0;

	if (width && height)
		gtk_window_resize (GTK_WINDOW (ConnectionsWindow), width,
				   height);
	rcm_update_connections_window_list ();

	g_object_unref (gconf_client);

	gtk_main ();
	return 0;
}

void
rcm_quit ()
{
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();

	gtk_window_get_size (GTK_WINDOW (MainWindow), &width, &height);
	gconf_client_set_int (gconf_client, GCONF_MAIN_WINDOW_WIDTH, width,
			      NULL);
	gconf_client_set_int (gconf_client, GCONF_MAIN_WINDOW_HEIGHT, height,
			      NULL);
	gconf_client_set_string (gconf_client, GCONF_RCM_VERSION, VERSION,
				 NULL);
	gconf_client_set_string (gconf_client, GCONF_RCM_TERMINAL_OPTION, TerminalProgram,
				 NULL);
	gconf_client_set_string (gconf_client, GCONF_RCM_TERMINAL_ARGUMENTS_OPTION, TerminalProgramOptions,
				 NULL);
	gconf_client_set_int (gconf_client, GCONF_RCM_SORTING_OPTION, SortOption,
			      NULL);
	gconf_client_set_int (gconf_client, GCONF_RCM_DISPLAY_USERNAMES, DisplayUsernameInMainWindow,
			      NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	gtk_exit (0);
}

GtkWidget *
CreateConnectionTypesWindow ()
{
	GtkTreeSelection *select;
	GtkWidget* widget;
	GtkWidget *pConnectionTypesWindow = create_ConnectionTypesWindow ();
	GtkWidget *ConnectionTypesList;
	GtkListStore *TypesStore;
	GtkCellRenderer *renderer1;
	GtkTreeViewColumn *column1;
	GtkCellRenderer *renderer2;
	GtkTreeViewColumn *column2;
	GtkCellRenderer *renderer3;
	GtkTreeViewColumn *column3;
	GtkCellRenderer *renderer4;
	GtkTreeViewColumn *column4;
	GtkCellRenderer *renderer5;
	GtkTreeViewColumn *column5;
	
	widget = lookup_widget(pConnectionTypesWindow,"ConnectionTypesIconEntry");
	gnome_icon_entry_set_pixmap_subdir(GNOME_ICON_ENTRY(widget),PACKAGE);
	
	gtk_window_set_transient_for (GTK_WINDOW (pConnectionTypesWindow),
				      GTK_WINDOW (MainWindow));

	ConnectionTypesList =
		lookup_widget (pConnectionTypesWindow, "ConnectionTypesList");
	TypesStore =
		gtk_list_store_new (CONNECTION_TYPE_N_COLUMNS,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_BOOLEAN,
				    G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (ConnectionTypesList),
				 GTK_TREE_MODEL (TypesStore));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW
					   (ConnectionTypesList), TRUE);
	g_object_unref (G_OBJECT (TypesStore));


	renderer1 = gtk_cell_renderer_text_new ();
	column1 =
		gtk_tree_view_column_new_with_attributes (_("Name"),
							  renderer1, "text",
							  CONNECTION_TYPE_NAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionTypesList),
				     column1);


	renderer2 = gtk_cell_renderer_text_new ();
	column2 =
		gtk_tree_view_column_new_with_attributes (_("Command"),
							  renderer2, "text",
							  CONNECTION_TYPE_COMMAND_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionTypesList),
				     column2);

	renderer3 = gtk_cell_renderer_text_new ();
	column3 =
		gtk_tree_view_column_new_with_attributes (_("Arguments"),
							  renderer3, "text",
							  CONNECTION_TYPE_ARGS_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionTypesList),
				     column3);

	renderer4 = gtk_cell_renderer_toggle_new ();
	column4 =
		gtk_tree_view_column_new_with_attributes (_("Terminal"),
							  renderer4, "radio",
							  CONNECTION_TYPE_TERMINAL_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionTypesList),
				     column4);

	renderer5 = gtk_cell_renderer_text_new ();
	column5 =
		gtk_tree_view_column_new_with_attributes (_("Icon"),
							  renderer5, "text",
							  CONNECTION_TYPE_ICON_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionTypesList),
				     column5);

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionTypesList));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
			  G_CALLBACK
			  (on_ConnectionTypesList_selection_changed_cb),
			  NULL);
	return pConnectionTypesWindow;
}

GtkWidget *
CreateConnectionsWindow ()
{
	GtkTreeSelection *select;
	GtkWidget *combo;
	GtkWidget *pConnectionsWindow = create_ConnectionsWindow ();
	GtkWidget *ConnectionList;
	GtkListStore *ConnStore;
	GtkCellRenderer *renderer1;
	GtkTreeViewColumn *column1;
	GtkCellRenderer *renderer2;
	GtkTreeViewColumn *column2;
	GtkCellRenderer *renderer3;
	GtkTreeViewColumn *column3;
	
	gtk_window_set_transient_for (GTK_WINDOW (pConnectionsWindow),
				      GTK_WINDOW (MainWindow));

	ConnectionList =
		lookup_widget (pConnectionsWindow, "ConnectionsList");
	ConnStore =
		gtk_list_store_new (CONNECTION_TYPE_N_COLUMNS,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_BOOLEAN,
				    G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (ConnectionList),
				 GTK_TREE_MODEL (ConnStore));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW
					   (ConnectionList), TRUE);
	g_object_unref (G_OBJECT (ConnStore));


	renderer1 = gtk_cell_renderer_text_new ();
	column1 =
		gtk_tree_view_column_new_with_attributes (_("Name"),
							  renderer1, "text",
							  CONNECTION_NAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionList), column1);

	renderer2 = gtk_cell_renderer_text_new ();
	column2 =
		gtk_tree_view_column_new_with_attributes (_("Hostname"),
							  renderer2, "text",
							  CONNECTION_HOSTNAME_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionList), column2);

	renderer3 = gtk_cell_renderer_text_new ();
	column3 =
		gtk_tree_view_column_new_with_attributes (_("Type"),
							  renderer3, "text",
							  CONNECTION_TYPE_COLUMN,
							  NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ConnectionList), column3);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ConnectionList));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
			  G_CALLBACK
			  (on_ConnectionsList_selection_changed_cb), NULL);
	combo = lookup_widget (pConnectionsWindow, "ConnectionTypeCombo");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo)->entry),
				   FALSE);
	return pConnectionsWindow;
}

void
rcm_warn (const gchar * msg, GtkWidget * parent)
{
	GtkWidget *dialog = gnome_message_box_new (msg,
						   GNOME_MESSAGE_BOX_WARNING,
						   GNOME_STOCK_BUTTON_OK,
						   NULL);
	gtk_window_set_transient_for (GTK_WINDOW (dialog),
				      GTK_WINDOW (parent));
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
}

void
rcm_error (const gchar * msg, GtkWidget * parent)
{
	GtkWidget *dialog = gnome_message_box_new (msg,
						   GNOME_MESSAGE_BOX_ERROR,
						   GNOME_STOCK_BUTTON_OK,
						   NULL);
	gtk_window_set_transient_for (GTK_WINDOW (dialog),
				      GTK_WINDOW (parent));
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
}


void
rcm_update_main_window (void)
{
	GtkWidget *widget;
	gint i, len;
	GList *l = NULL;
	gint selected_index;
	Connection *connection;
	ConnectionType *type;
	gchar icon_text[MAX_BUFFER_LENGTH];

	widget = lookup_widget (MainWindow, "MainList");
	g_return_if_fail (widget != NULL);
	gnome_icon_list_freeze (GNOME_ICON_LIST (widget));
	l = gnome_icon_list_get_selection (GNOME_ICON_LIST (widget));

	if (l)
	{
		selected_index = GPOINTER_TO_INT (l->data);
	}

	gnome_icon_list_clear (GNOME_ICON_LIST (widget));

	len = g_slist_length (ConnectionsSList);
	for (i = 0; i < len; i++)
	{
		connection = g_slist_nth_data (ConnectionsSList, i);
		type = g_slist_nth_data (ConnectionTypesSList,
					 connection->Type);
		if(DisplayUsernameInMainWindow)
			snprintf(icon_text,MAX_BUFFER_LENGTH,"%s@%s",connection->Username,connection->Name);
		else
			snprintf(icon_text,MAX_BUFFER_LENGTH,"%s",connection->Name);
		gnome_icon_list_append (GNOME_ICON_LIST (widget), type->Icon,icon_text);
	}

	if (l)
		gnome_icon_list_select_icon (GNOME_ICON_LIST (widget),
					     selected_index);
	gnome_icon_list_thaw (GNOME_ICON_LIST (widget));
}

gint rcm_compare_Ascending(gconstpointer a, gconstpointer b)
{
	return strcmp(((Connection*)a)->Name,((Connection*)b)->Name);
}

gint rcm_compare_Descending(gconstpointer a, gconstpointer b)
{
	return strcmp(((Connection*)b)->Name,((Connection*)a)->Name);
}

gint rcm_compare_Types(gconstpointer a, gconstpointer b)
{
	ConnectionType* aa = g_slist_nth_data(ConnectionTypesSList,((Connection*)a)->Type);
	ConnectionType* bb = g_slist_nth_data(ConnectionTypesSList,((Connection*)b)->Type);;
	return strcmp(((ConnectionType*)aa)->Name,((ConnectionType*)bb)->Name);
}

void rcm_ascending_sort(void)
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Ascending);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window();
}


void rcm_descending_sort()
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Descending);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window();
}


void rcm_type_sort()
{
	ConnectionsSList = g_slist_sort(ConnectionsSList,rcm_compare_Types);
	ConnectionsSListIsDirty = TRUE;
	rcm_save_connections_to_disk();
	rcm_update_main_window();
}

void rcm_translate_arg(gchar* args, const gchar* arg, const gchar* fspec, guint length)
{
	GString* str = NULL;
	gchar* tmp = NULL;
	guint index = 0;
	
	str = g_string_new(args);
	tmp = strstr(args,fspec);
	if(tmp == NULL)
	{
		return;
	}
	index = (tmp - args); 
	g_string_erase(str,index,2);
	g_string_insert(str,index,arg);
	memset(args,0,length);
	strncat(args,str->str,length);
	g_string_free(str,TRUE);
}

void
rcm_first_run (void)
{
	ConnectionType type;
	Connection connection;
	GtkWidget *dialog = NULL;
	
	memset(&type,0,sizeof(struct ConnectionType));
	memset(&connection,0,sizeof(struct Connection));
	
	strncpy(type.Command,"ftp",MAX_BUFFER_LENGTH);
	strncpy(type.Name,"FTP",MAX_BUFFER_LENGTH);
	strncpy(type.Icon,PACKAGE_PIXMAP_DIR,MAX_BUFFER_LENGTH);
	strncat(type.Icon,"/ftp.xpm",MAX_BUFFER_LENGTH);
	type.Terminal = TRUE;
	
	strncpy(connection.Arguments,"%h",MAX_BUFFER_LENGTH);
	strncpy(connection.Hostname,"ftp.gnome.org",MAX_BUFFER_LENGTH);
	strncpy(connection.Name,"Gnome FTP Site",MAX_BUFFER_LENGTH);
	
	rcm_save_type(type);
	rcm_save_types_to_disk();
	rcm_save_connection(connection);
	rcm_save_connections_to_disk();
	
	dialog = gnome_message_box_new (_("It appears you have never run grcm before,\nso I have added a few entries to get you started."),
						   GNOME_MESSAGE_BOX_INFO,
						   GNOME_STOCK_BUTTON_OK,
						   NULL);
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
}

void rcm_show_ConnectionTypesWindow()
{
	g_return_if_fail (ConnectionTypesWindow != NULL);
	rcm_update_connectiontypes_window_list ();
	rcm_clear_types_window();
	gtk_widget_show (ConnectionTypesWindow);
}

void rcm_show_ConnectionsWindow()
{
	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list ();
	rcm_clear_connections_window();
	gtk_widget_show (ConnectionsWindow);
}

void
rcm_upgrade (gchar * version)
{
}
