/* Gridlock
Copyright (c) 2002-2003 by Brian Nenninger. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#import <Foundation/Foundation.h>
#import "Game.h"

@interface GameConfiguration : NSObject {
  NSString *gameName;
  NSString *variationName;
  Game *initialGame;
}

-(GameConfiguration *)initWithName:(NSString *)name variation:(NSString *)variation;
/*
+(GameConfiguration *)configurationWithDisplayName:(NSString *)name
                              variationDisplayName:(NSString *)variation;
*/
+(GameConfiguration *)configurationFromDefaults;
-(void)saveToDefaults;

-(NSString *)gameName;
-(NSString *)variationName;
-(NSString *)gameDisplayName;
-(NSString *)variationDisplayName;

idAccessor_h(initialGame, setInitialGame)
-(void)createNewInitialGame;

-(id)aiWithName:(NSString *)aiName;
-(id)viewDelegate;

+(NSArray *)allGameDisplayNames;
+(NSArray *)allGameNames;

-(NSArray *)allVariationDisplayNames;
-(NSArray *)allVariationNames;
  // FIXME: handle all AI state in this class
-(NSArray *)allAINames;
-(NSArray *)allAIDisplayNames;

-(id)propertyList;
-(id)initFromPropertyList:(id)plist;

@end
