/* Gnometoaster's dialog routines,wrapping around gnome's dialog-util 
 * and displaying a gtkdialog box in the gtk version */

#ifndef DIALOG_H
#define DIALOG_H

#include "config.h"

#define DIALOG_YES 0
#define DIALOG_NO  1

#ifdef HAVE_GNOME
#include <gnome.h>

#define dialog_replycallback GnomeReplyCallback
#define dialog_stringcallback GnomeStringCallback

#define dialog_ok(messagetext) gnome_ok_dialog(messagetext)
#define dialog_error(messagetext) gnome_error_dialog(messagetext)
#define dialog_warning(messagetext) gnome_warning_dialog(messagetext)
#define dialog_question(messagetext,callback,data) \
	   gnome_question_dialog(messagetext,callback,data)
#define dialog_string(prompt,defaulttext,maxlength,callback,data) \
	   gnome_request_dialog(0,prompt,defaulttext,maxlength,callback,data,NULL)

#else
#include <gtk/gtk.h>

typedef void (*dialog_replycallback)(gint reply,gpointer data);
typedef void (*dialog_stringcallback)(gchar *string,gpointer data);

GtkWidget *dialog_ok(const gchar *msg);
#define dialog_error dialog_ok
#define dialog_warning dialog_ok
GtkWidget *dialog_question(const gchar *msg,			
			   dialog_replycallback callback,
			   gpointer data);
GtkWidget *dialog_string(const gchar *prompt,
			 const gchar *defaulttext,
			 int maxlength,
			 dialog_stringcallback callback,
			 gpointer data);
#endif
/* show a user defined widget within a dialog window.
 * This dialog has a common codebase for the Gtk and the Gnome version,
 * only the buttons differ.
 * Pass one of the definitions below to get a specific type of dialog,
 * _OK will show a dialog with an OK button, callback and data are undefined
 * _QUESTION will show a Yes/No dialog with the result passed to the
 * specified callback function.
 * _OKCANCEL will show a Yes/No dialog with the buttons labelled 'OK' and
 * 'CANCEL' instead */
#define DIALOG_USERWIDGET_OK        1
#define DIALOG_USERWIDGET_QUESTION  2
#define DIALOG_USERWIDGET_OKCANCEL  4
GtkWidget *dialog_showuserwidget(gchar *title,
				 GtkWidget *w,
				 int type,
				 dialog_replycallback callback,
				 gpointer data);

#endif // DIALOG_H
